/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.osgi.util.NLS;
import org.jboss.jdf.stacks.model.ArchetypeVersion;
import org.jboss.tools.maven.core.IArtifactResolutionService;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.maven.project.examples.Messages;
import org.jboss.tools.maven.project.examples.internal.stacks.StacksArchetypeUtil;
import org.jboss.tools.maven.project.examples.xpl.DependencyKey;
import org.jboss.tools.project.examples.model.ProjectExample;

public class MavenArtifactHelper {
    private static final String JBOSS_SPEC = "org.jboss.spec:jboss-javaee-web-6.0";
    private static final String[] JBOSS_SPEC_VERSIONS = new String[]{"org.jboss.spec:jboss-javaee-web-6.0:pom:3.0.2.Final-redhat-5", "org.jboss.spec:jboss-javaee-web-6.0:pom:3.0.2.Final-redhat-4", "org.jboss.spec:jboss-javaee-web-6.0:pom:3.0.2.Final-redhat-3"};
    private static final String COORDS = "org.jboss.spec:jboss-javaee-web-6.0:[0,)";

    @Deprecated
    public static boolean isEnterpriseRepositoryAvailable() {
        boolean isRepoAvailable = MavenArtifactHelper.redHatArtifactExists(COORDS);
        if (!isRepoAvailable) {
            IArtifactResolutionService resolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            try {
                List repos = MavenPlugin.getMaven().getArtifactRepositories();
                Iterator<String> ite = Arrays.asList(JBOSS_SPEC_VERSIONS).iterator();
                NullProgressMonitor npm = new NullProgressMonitor();
                while (ite.hasNext() && !isRepoAvailable) {
                    String gav = ite.next();
                    isRepoAvailable = resolutionService.isResolved(gav, repos, (IProgressMonitor)npm);
                }
            }
            catch (CoreException e) {
                MavenProjectExamplesActivator.log(e);
            }
        }
        return isRepoAvailable;
    }

    @Deprecated
    public static boolean isArtifactAvailable(String dependencyKey) {
        try {
            IArtifactResolutionService resolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            List repos = MavenPlugin.getMaven().getArtifactRepositories();
            return resolutionService.isResolved(dependencyKey, repos, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MavenProjectExamplesActivator.log(e);
            return false;
        }
    }

    public static boolean isArtifactAvailable(DependencyKey key) {
        return MavenArtifactHelper.isArtifactAvailable(key.toPortableString());
    }

    @Deprecated
    public static IStatus checkEnterpriseRequirementsAvailable(ProjectExample project) {
        IStatus status = Status.OK_STATUS;
        if (project != null && (status = MavenArtifactHelper.checkRequirementsAvailable(project)).isOK() && !MavenArtifactHelper.isEnterpriseRepositoryAvailable()) {
            status = new Status(4, "org.jboss.tools.maven.project.examples", NLS.bind((String)Messages.ArchetypeExamplesWizardFirstPage_Unresolved_Enterprise_Repo, (Object)JBOSS_SPEC));
        }
        return status;
    }

    public static IStatus checkRequirementsAvailable(ProjectExample project) {
        Set requirements;
        if (project != null && (requirements = project.getEssentialEnterpriseDependencyGavs()) != null && !requirements.isEmpty()) {
            List repos;
            IArtifactResolutionService resolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            try {
                repos = MavenPlugin.getMaven().getArtifactRepositories();
            }
            catch (CoreException coreException) {
                return new Status(4, "org.jboss.tools.maven.project.examples", "Can't load maven repositories");
            }
            for (String gav : requirements) {
                boolean isResolved = false;
                try {
                    isResolved = resolutionService.isResolved(gav, repos, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    MavenProjectExamplesActivator.log(e);
                }
                if (isResolved) continue;
                return new Status(4, "org.jboss.tools.maven.project.examples", NLS.bind((String)Messages.ArchetypeExamplesWizardFirstPage_Unresolved_Essential_Dependency, (Object)gav));
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkRequirementsAvailable(ArchetypeVersion archetypeVersion) {
        List repos;
        if (archetypeVersion == null) {
            return Status.OK_STATUS;
        }
        Set<String> requirements = StacksArchetypeUtil.getRequiredDependencies(archetypeVersion);
        if (requirements == null || requirements.isEmpty()) {
            return Status.OK_STATUS;
        }
        IArtifactResolutionService resolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
        try {
            repos = MavenPlugin.getMaven().getArtifactRepositories();
        }
        catch (CoreException coreException) {
            return new Status(4, "org.jboss.tools.maven.project.examples", "Can't load maven repositories");
        }
        for (String gav : requirements) {
            boolean isResolved = false;
            try {
                isResolved = resolutionService.isResolved(gav, repos, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MavenProjectExamplesActivator.log(e);
            }
            if (isResolved) continue;
            return new Status(4, "org.jboss.tools.maven.project.examples", NLS.bind((String)Messages.ArchetypeExamplesWizardFirstPage_Unresolved_Essential_Dependency, (Object)gav));
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean redHatArtifactExists(String coords) {
        try {
            String version;
            IArtifactResolutionService resolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            List repositories = MavenPlugin.getMaven().getArtifactRepositories();
            List availableVersions = resolutionService.getAvailableReleasedVersions(coords, repositories, (IProgressMonitor)new NullProgressMonitor());
            Iterator iterator = availableVersions.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((version = (String)iterator.next()) == null || !version.toString().contains("redhat"));
            return true;
        }
        catch (CoreException e) {
            MavenProjectExamplesActivator.log(e);
        }
        return false;
    }
}

