/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.internal.stacks;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.jdf.stacks.model.ArchetypeVersion;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;

public class StacksArchetypeUtil {
    private static final String TARGET_PRODUCT = "product";
    private static final String TARGET_COMMUNITY = "community";
    private static final String ARCHETYPE_IS_BLANK = "isBlank";
    private static final String ARCHETYPE_ENVIRONMENT = "environment";
    private static final String ARCHETYPE_TARGET = "target";
    private static final String ARCHETYPE_TYPE = "type";
    private static final String WEB_EE6 = "web-ee6";
    private static final String FULL_EE6 = "full-ee6";
    private static final String WEB_EE7 = "web-ee7";
    private static final String FULL_EE7 = "full-ee7";
    private static final String UNDEFINED_EE = "undefined";
    private static Map<String, List<String>> ENVIRONMENTS_MAP = new HashMap<String, List<String>>(4);
    private Set<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> facetedRuntimes;

    static {
        ENVIRONMENTS_MAP.put(FULL_EE7, Arrays.asList(FULL_EE7, WEB_EE7, FULL_EE6, WEB_EE6));
        ENVIRONMENTS_MAP.put(WEB_EE7, Arrays.asList(WEB_EE7, WEB_EE6));
        ENVIRONMENTS_MAP.put(FULL_EE6, Arrays.asList(FULL_EE6, WEB_EE6));
        ENVIRONMENTS_MAP.put(WEB_EE6, Arrays.asList(WEB_EE6));
    }

    public StacksArchetypeUtil() {
        this(null);
    }

    public StacksArchetypeUtil(Set<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> facetedRuntimes) {
        this.facetedRuntimes = facetedRuntimes == null ? RuntimeManager.getRuntimes() : facetedRuntimes;
    }

    private String getEnvironment(IRuntime runtime) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = this.getFacetedRuntime(runtime);
        if (facetedRuntime == null) {
            return UNDEFINED_EE;
        }
        if (facetedRuntime.supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_70)) {
            return FULL_EE7;
        }
        if (facetedRuntime.supports(IJ2EEFacetConstants.DYNAMIC_WEB_31)) {
            return WEB_EE7;
        }
        if (facetedRuntime.supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_60)) {
            return FULL_EE6;
        }
        if (facetedRuntime.supports(IJ2EEFacetConstants.DYNAMIC_WEB_30)) {
            return WEB_EE6;
        }
        return UNDEFINED_EE;
    }

    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime getFacetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        String id = runtime.getId();
        if (id == null) {
            return null;
        }
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime fr : this.facetedRuntimes) {
            if (!id.equals(fr.getProperty("id"))) continue;
            return fr;
        }
        return null;
    }

    public ArchetypeVersion getArchetype(String archetypeType, boolean isBlank, IRuntime runtime, Stacks stacks) {
        if (archetypeType == null) {
            throw new IllegalArgumentException("Archetype type cannot be null");
        }
        String targetProduct = RuntimeUtils.isEAP((IRuntime)runtime) ? TARGET_PRODUCT : TARGET_COMMUNITY;
        String environment = this.getEnvironment(runtime);
        String runtimeTypeId = runtime == null || runtime.getRuntimeType() == null ? null : runtime.getRuntimeType().getId();
        return this.getArchetype(archetypeType, isBlank, targetProduct, environment, runtimeTypeId, stacks);
    }

    public ArchetypeVersion getArchetype(String archetypeType, boolean isBlank, String targetProduct, String environment, Stacks stacks) {
        return this.getArchetype(archetypeType, isBlank, targetProduct, environment, null, stacks);
    }

    public ArchetypeVersion getArchetype(String archetypeType, boolean isBlank, String targetProduct, String environment, String serverId, Stacks stacks) {
        if (archetypeType == null) {
            throw new IllegalArgumentException("Archetype type cannot be null");
        }
        Map<ArchetypeVersion, Integer> matchingArchetypes = this.getBestMatchingArchetype(archetypeType, isBlank, targetProduct, environment, serverId, stacks);
        if (!matchingArchetypes.isEmpty()) {
            return matchingArchetypes.keySet().iterator().next();
        }
        return null;
    }

    private Map<ArchetypeVersion, Integer> getBestMatchingArchetype(String archetypeType, boolean isBlank, String targetProduct, String environment, String serverId, Stacks stacks) {
        Runtime rt;
        HashMap<ArchetypeVersion, Integer> matchingArchetypes = new HashMap<ArchetypeVersion, Integer>();
        if (targetProduct == null) {
            targetProduct = TARGET_COMMUNITY;
        }
        for (ArchetypeVersion archetype : stacks.getAvailableArchetypeVersions()) {
            List<String> supportedEnvironments;
            Properties properties = archetype.getLabels();
            String type = properties.getProperty(ARCHETYPE_TYPE);
            if (!archetypeType.equals(type)) continue;
            int score = 0;
            String archetypeTargetProduct = properties.getProperty(ARCHETYPE_TARGET);
            if (targetProduct.equals(archetypeTargetProduct)) {
                score += 2;
            }
            if ((supportedEnvironments = ENVIRONMENTS_MAP.get(environment)) != null) {
                String tEnv = properties.getProperty(ARCHETYPE_ENVIRONMENT);
                int envScore = supportedEnvironments.size();
                for (String env : supportedEnvironments) {
                    if (env.equals(tEnv)) break;
                    --envScore;
                }
                score += envScore;
            }
            if (isBlank == this.isBlank(archetype)) {
                ++score;
            }
            matchingArchetypes.put(archetype, score);
        }
        if (serverId != null && (rt = this.getRuntimeFromWtp(stacks, serverId)) != null && rt.getArchetypes() != null) {
            for (ArchetypeVersion a : rt.getArchetypes()) {
                if (!matchingArchetypes.containsKey(a)) continue;
                matchingArchetypes.put(a, (Integer)matchingArchetypes.get(a) + 3);
            }
        }
        ArrayList entries = new ArrayList(matchingArchetypes.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<ArchetypeVersion, Integer>>(){

            @Override
            public int compare(Map.Entry<ArchetypeVersion, Integer> e1, Map.Entry<ArchetypeVersion, Integer> e2) {
                int compare = e2.getValue().compareTo(e1.getValue());
                if (compare == 0 && e1.getKey().getArchetype().equals((Object)e2.getKey().getArchetype())) {
                    ComparableVersion v1 = new ComparableVersion(e1.getKey().getVersion());
                    ComparableVersion v2 = new ComparableVersion(e2.getKey().getVersion());
                    return v2.compareTo(v1);
                }
                return compare;
            }
        });
        LinkedHashMap<ArchetypeVersion, Integer> result = new LinkedHashMap<ArchetypeVersion, Integer>(entries.size());
        for (Map.Entry entry : entries) {
            result.put((ArchetypeVersion)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    private Runtime getRuntimeFromWtp(Stacks stacks, String wtpRuntimeId) {
        if (wtpRuntimeId != null) {
            for (Runtime runtime : stacks.getAvailableRuntimes()) {
                Properties p = runtime.getLabels();
                if (p == null || !wtpRuntimeId.equals(p.get("wtp-runtime-type"))) continue;
                return runtime;
            }
        }
        return null;
    }

    public static Map<String, String> getAdditionalRepositories(ArchetypeVersion archetype) {
        if (archetype != null) {
            Object additionalRepos = archetype.getLabels().get("additionalRepositories");
            if (additionalRepos instanceof Map) {
                return new LinkedHashMap<String, String>((Map)additionalRepos);
            }
            if (additionalRepos instanceof Collection) {
                Collection additionalReposList = (Collection)additionalRepos;
                LinkedHashMap<String, String> additionalReposMap = new LinkedHashMap<String, String>(additionalReposList.size());
                for (String url : additionalReposList) {
                    String id = StacksArchetypeUtil.inferIdFromUrl(url);
                    if (id == null) continue;
                    additionalReposMap.put(id, url);
                }
                return additionalReposMap;
            }
        }
        return null;
    }

    private static String inferIdFromUrl(String sUrl) {
        try {
            URI url = new URI(sUrl);
            String id = url.getHost();
            if (id != null) {
                return (String.valueOf(id) + url.getPath()).replace('/', ' ').trim().replaceAll("[^a-z\\d]", "-");
            }
        }
        catch (Exception e) {
            MavenProjectExamplesActivator.log(e);
        }
        return null;
    }

    public static Set<String> getRequiredDependencies(ArchetypeVersion archetype) {
        Object essentialDeps;
        if (archetype != null && (essentialDeps = archetype.getLabels().get("essentialDependencies")) instanceof Collection) {
            return new LinkedHashSet<String>((Collection)essentialDeps);
        }
        return null;
    }

    public boolean hasBlankArchetype(ArchetypeVersion archetype, IRuntime runtime, Stacks stacks) {
        if (archetype == null) {
            return false;
        }
        if (this.isBlank(archetype)) {
            return true;
        }
        Properties labels = archetype.getLabels();
        String type = labels.getProperty(ARCHETYPE_TYPE);
        if (type == null) {
            return archetype.getArchetype().getBlank() != null || archetype.getArchetype().getArtifactId().contains("-blank");
        }
        ArchetypeVersion candidate = this.getArchetype(type, true, runtime, stacks);
        return this.isBlank(candidate);
    }

    private boolean isBlank(ArchetypeVersion archetype) {
        Properties labels = archetype.getLabels();
        boolean isArchetypeBlank = Boolean.parseBoolean("" + labels.get(ARCHETYPE_IS_BLANK));
        return isArchetypeBlank;
    }
}

