/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.tools.maven.project.examples.Messages;
import org.jboss.tools.maven.project.examples.offline.MavenOfflinePropertyChangeListener;
import org.jboss.tools.maven.project.examples.xpl.UpdateMavenProjectJob;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.stacks.core.model.StacksManager;
import org.osgi.framework.BundleContext;

public class MavenProjectExamplesActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.maven.project.examples";
    private static MavenProjectExamplesActivator plugin;
    private MavenOfflinePropertyChangeListener mavenOfflinePropertyChangeListener;
    private Stacks stacks;
    private long lastUpdate;
    private static long DEFAULT_CACHE_TIMEOUT;

    static {
        DEFAULT_CACHE_TIMEOUT = 3600000L;
    }

    public synchronized Stacks getCachedStacks() {
        if (System.currentTimeMillis() - this.lastUpdate > DEFAULT_CACHE_TIMEOUT) {
            this.stacks = null;
        }
        if (this.stacks == null) {
            final Stacks[] s = new Stacks[1];
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                progressDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.MavenProjectExamplesActivator_Downloading_Examples_Wizards_Metadata, 100);
                        try {
                            Stacks[] result = new StacksManager().getStacks(Messages.MavenProjectExamplesActivator_Downloading_Examples_Wizards_Metadata, monitor, new StacksManager.StacksType[]{StacksManager.StacksType.STACKS_TYPE});
                            if (result != null && result.length > 0) {
                                s[0] = result[0];
                            }
                        }
                        catch (Exception e) {
                            MavenProjectExamplesActivator.log(e, Messages.MavenProjectExamplesActivator_Error_Retrieving_Stacks_MetaData);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException ex) {
                MavenProjectExamplesActivator.log(ex, Messages.MavenProjectExamplesActivator_Error_Retrieving_Stacks_MetaData);
            }
            catch (InterruptedException interruptedException) {}
            if (s[0] != null) {
                this.stacks = s[0];
                this.lastUpdate = System.currentTimeMillis();
            }
        }
        return this.stacks;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.mavenOfflinePropertyChangeListener = new MavenOfflinePropertyChangeListener();
        ProjectExamplesActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.mavenOfflinePropertyChangeListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ProjectExamplesActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.mavenOfflinePropertyChangeListener);
        this.mavenOfflinePropertyChangeListener = null;
        this.stacks = null;
        super.stop(context);
    }

    public static MavenProjectExamplesActivator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        MavenProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, e);
        MavenProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(1, PLUGIN_ID, message);
        MavenProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static String getProjectName(MavenProjectInfo projectInfo, ProjectImportConfiguration configuration) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        File pomFile = projectInfo.getPomFile();
        Model model = projectInfo.getModel();
        IMaven maven = MavenPlugin.getMaven();
        if (model == null) {
            model = maven.readModel(pomFile);
            projectInfo.setModel(model);
        }
        String projectName = configuration.getProjectName(model);
        File projectDir = pomFile.getParentFile();
        String projectParent = projectDir.getParentFile().getAbsolutePath();
        if (projectInfo.getBasedirRename() == 2) {
            File newProject = new File(projectDir.getParent(), projectName);
            if (!projectDir.equals(newProject)) {
                projectDir = newProject;
            }
        } else if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            projectName = projectDir.getName();
        }
        return projectName;
    }

    public static ImageDescriptor getNewWizardImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/new_wiz.png");
    }

    public static void updateMavenConfiguration(String projectName, List<String> includedProjects, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.isAccessible()) {
            try {
                project.refreshLocal(2, monitor);
            }
            catch (CoreException coreException) {}
        }
        IProject[] selectedProjects = new IProject[includedProjects.size() + 1];
        selectedProjects[0] = project;
        if (includedProjects.size() > 0) {
            int i = 1;
            for (String selectedProjectName : includedProjects) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(selectedProjectName);
                selectedProjects[i++] = project;
                try {
                    project.refreshLocal(2, monitor);
                }
                catch (CoreException coreException) {}
            }
        }
        UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(selectedProjects);
        updateJob.schedule();
        try {
            updateJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

