/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IHost;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmAttachHandler;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.IConstants;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Tools;
import org.jboss.tools.jmx.jvmmonitor.tools.Activator;

public class JvmAttachHandler
implements IJvmAttachHandler,
IPropertyChangeListener,
IConstants {
    private IHost localhost;
    Timer timer;

    public void setHost(IHost host) {
        this.localhost = host;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean hasValidJdk() {
        return Tools.getInstance().isReady();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.startMonitoring();
    }

    private void startMonitoring() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    JvmAttachHandler.this.updatesActiveJvms();
                }
                catch (Throwable t) {
                    Activator.log(4, Messages.updateTimerCanceledMsg, t);
                    JvmAttachHandler.this.timer.cancel();
                }
            }
        };
        long period = Activator.getDefault().getPreferenceStore().getLong("org.jboss.tools.jmx.jvmmonitor.tools.updatePeriod");
        this.timer.schedule(timerTask, 0L, period);
    }

    void updatesActiveJvms() throws JvmCoreException {
        Object monitoredHost = Tools.getInstance().invokeGetMonitoredHost("localhost");
        Set<Integer> activeJvms = Tools.getInstance().invokeActiveVms(monitoredHost);
        List previousVms = this.localhost.getActiveJvms();
        for (int pid : activeJvms) {
            if (JvmAttachHandler.containJvm(previousVms, pid)) continue;
            this.addActiveJvm(pid, monitoredHost);
        }
        for (IActiveJvm jvm : previousVms) {
            Integer pid = jvm.getPid();
            if (activeJvms.contains(pid)) continue;
            this.localhost.removeJvm(pid.intValue());
        }
    }

    private static boolean containJvm(List<IActiveJvm> jvms, int pid) {
        for (IActiveJvm jvm : jvms) {
            if (jvm.getPid() != pid) continue;
            return true;
        }
        return false;
    }

    private void addActiveJvm(int pid, Object monitoredHost) {
        String message;
        String vmId = String.format("//%d?mode=r", pid);
        Tools tools = Tools.getInstance();
        Object monitoredVm = null;
        try {
            monitoredVm = tools.invokeGetMonitoredVm(monitoredHost, tools.invokeVmIdentifier(vmId));
        }
        catch (JvmCoreException e) {
            Activator.log(4, Messages.getMonitoredJvmFailedMsg, e);
        }
        String mainClass = null;
        String launchCommand = null;
        String localConnectorAddress = null;
        String stateMessage = null;
        if (monitoredVm != null) {
            mainClass = JvmAttachHandler.getMainClass(monitoredVm, pid);
            launchCommand = JvmAttachHandler.getJavaCommand(monitoredVm, pid);
            try {
                localConnectorAddress = JvmAttachHandler.getLocalConnectorAddress(monitoredVm, pid);
            }
            catch (JvmCoreException e) {
                stateMessage = e.getMessage();
                message = NLS.bind((String)Messages.getLocalConnectorAddressFailedMsg, (Object)pid);
                Activator.log(2, message, e);
            }
        }
        try {
            this.localhost.addLocalActiveJvm(pid, mainClass, launchCommand, localConnectorAddress, stateMessage);
        }
        catch (JvmCoreException e) {
            message = NLS.bind((String)Messages.connectTargetJvmFailedMsg, (Object)pid);
            Activator.log(2, message, e);
        }
    }

    private static String getMainClass(Object monitoredVm, int pid) {
        String javaCommand = JvmAttachHandler.getJavaCommand(monitoredVm, pid);
        if (!"".equals(javaCommand)) {
            String[] elements = javaCommand.split(" -");
            String mainClass = elements.length > 0 ? elements[0] : javaCommand;
            return mainClass;
        }
        return "";
    }

    private static String getJavaCommand(Object monitoredVm, int pid) {
        Object monitor;
        Tools tools;
        String javaCommand;
        block3: {
            javaCommand = null;
            try {
                tools = Tools.getInstance();
                monitor = tools.invokeFindByName(monitoredVm, "sun.rt.javaCommand");
                if (monitor != null) break block3;
                return "";
            }
            catch (JvmCoreException e) {
                String message = NLS.bind((String)Messages.getMainClassNameFailed, (Object)pid);
                Activator.log(4, message, e);
                return "";
            }
        }
        javaCommand = tools.invokeGetValue(monitor).toString();
        return javaCommand == null ? "" : javaCommand;
    }

    private static String getLocalConnectorAddress(Object monitoredVm, int pid) throws JvmCoreException {
        String url = null;
        Tools tools = Tools.getInstance();
        Object virtualMachine = null;
        try {
            virtualMachine = tools.invokeAttach(pid);
            String javaHome = ((Properties)tools.invokeGetSystemProperties(virtualMachine)).getProperty("java.home");
            File file = new File(String.valueOf(javaHome) + IConstants.MANAGEMENT_AGENT_JAR);
            if (!file.exists()) {
                String message = NLS.bind((String)Messages.fileNotFoundMsg, (Object)file.getPath());
                throw new JvmCoreException(4, message, (Throwable)new Exception());
            }
            tools.invokeLoadAgent(virtualMachine, file.getAbsolutePath(), "com.sun.management.jmxremote");
            Properties props = tools.invokeGetAgentProperties(virtualMachine);
            url = (String)props.get("com.sun.management.jmxremote.localConnectorAddress");
        }
        catch (Throwable throwable) {
            if (virtualMachine != null) {
                try {
                    tools.invokeDetach(virtualMachine);
                }
                catch (JvmCoreException jvmCoreException) {}
            }
            throw throwable;
        }
        if (virtualMachine != null) {
            try {
                tools.invokeDetach(virtualMachine);
            }
            catch (JvmCoreException jvmCoreException) {}
        }
        return url;
    }

    public synchronized void beginPolling() {
        this.startMonitoring();
    }

    public synchronized void suspendPolling() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void refreshJVMs() throws JvmCoreException {
        this.updatesActiveJvms();
    }

    public synchronized boolean isPolling() {
        return this.timer != null;
    }
}

