/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.properties;

import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jboss.tools.modeshape.rest.domain.ModeShapeDomainObject;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.properties.PropertyDisplayNameProvider;
import org.modeshape.common.util.CheckArg;

public final class ModeShapePropertySource
implements IPropertySource {
    private static final String SERVER_PASSWORD_PERSISTED = "server.passwordPersisted";
    private static final String SERVER_URL = "server.url";
    private static final String SERVER_USER = "server.user";
    private static final String WORKSPACE_NAME = "workspace.name";
    private static final String WORKSPACE_REPOSITORY = "workspace.repository";
    private IPropertyDescriptor[] descriptors;
    private final ModeShapeDomainObject modeShapeObject;

    public ModeShapePropertySource(ModeShapeDomainObject modeShapeObject) {
        CheckArg.isNotNull((Object)modeShapeObject, (String)"modeShapeObject");
        this.modeShapeObject = modeShapeObject;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            if (this.modeShapeObject instanceof ModeShapeServer) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)SERVER_URL, PropertyDisplayNameProvider.getDisplayName(SERVER_URL));
                descriptor.setCategory(PropertyDisplayNameProvider.getCategory(SERVER_URL));
                temp.add(descriptor);
                descriptor = new PropertyDescriptor((Object)SERVER_USER, PropertyDisplayNameProvider.getDisplayName(SERVER_USER));
                descriptor.setCategory(PropertyDisplayNameProvider.getCategory(SERVER_USER));
                temp.add(descriptor);
                descriptor = new PropertyDescriptor((Object)SERVER_PASSWORD_PERSISTED, PropertyDisplayNameProvider.getDisplayName(SERVER_PASSWORD_PERSISTED));
                descriptor.setCategory(PropertyDisplayNameProvider.getCategory(SERVER_PASSWORD_PERSISTED));
                temp.add(descriptor);
            } else if (this.modeShapeObject instanceof ModeShapeRepository) {
                for (String propKey : ((ModeShapeRepository)this.modeShapeObject).getProperties().keySet()) {
                    PropertyDescriptor descriptor = new PropertyDescriptor((Object)propKey, PropertyDisplayNameProvider.getDisplayName(propKey));
                    descriptor.setCategory(PropertyDisplayNameProvider.getCategory(propKey));
                    temp.add(descriptor);
                }
            } else if (this.modeShapeObject instanceof ModeShapeWorkspace) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)WORKSPACE_NAME, PropertyDisplayNameProvider.getDisplayName(WORKSPACE_NAME));
                descriptor.setCategory(PropertyDisplayNameProvider.getCategory(WORKSPACE_NAME));
                temp.add(descriptor);
                descriptor = new PropertyDescriptor((Object)WORKSPACE_REPOSITORY, PropertyDisplayNameProvider.getDisplayName(WORKSPACE_REPOSITORY));
                descriptor.setCategory(PropertyDisplayNameProvider.getCategory(WORKSPACE_REPOSITORY));
                temp.add(descriptor);
            }
            this.descriptors = temp.toArray(new IPropertyDescriptor[temp.size()]);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (this.modeShapeObject instanceof ModeShapeServer) {
            ModeShapeServer server = (ModeShapeServer)this.modeShapeObject;
            if (SERVER_URL.equals(id)) {
                return server.getOriginalUrl();
            }
            if (SERVER_USER.equals(id)) {
                return server.getUser();
            }
            if (SERVER_PASSWORD_PERSISTED.equals(id)) {
                return server.isPasswordBeingPersisted();
            }
        } else {
            if (this.modeShapeObject instanceof ModeShapeRepository) {
                Object value = ((ModeShapeRepository)this.modeShapeObject).getProperties().get(id);
                if (value instanceof String) {
                    return value;
                }
                if (value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    StringBuilder txt = new StringBuilder();
                    int i = 0;
                    int size = values.length;
                    while (i < size) {
                        txt.append(values[i]);
                        if (i < size - 1) {
                            txt.append(", ");
                        }
                        ++i;
                    }
                    return txt.toString();
                }
                return value.toString();
            }
            if (this.modeShapeObject instanceof ModeShapeWorkspace) {
                ModeShapeWorkspace workspace = (ModeShapeWorkspace)this.modeShapeObject;
                if (WORKSPACE_NAME.equals(id)) {
                    return workspace.getName();
                }
                if (WORKSPACE_REPOSITORY.equals(id)) {
                    return workspace.getRepository().getName();
                }
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

