/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.preferences;

import org.eclipse.core.resources.IResource;
import org.jboss.tools.modeshape.rest.preferences.IgnoredResourcesModel;
import org.jboss.tools.modeshape.rest.preferences.ResourcePattern;
import org.modeshape.common.util.CheckArg;

public final class PublishingFileFilter {
    private final IgnoredResourcesModel model;

    public static boolean matches(String text, String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        return text.matches(regex);
    }

    public PublishingFileFilter(IgnoredResourcesModel model) {
        CheckArg.isNotNull((Object)model, (String)"model");
        this.model = model;
    }

    public boolean accept(IResource resource) {
        CheckArg.isNotNull((Object)resource, (String)"resource");
        String name = resource.getName();
        for (ResourcePattern pattern : this.model.getPatterns()) {
            if (!pattern.isEnabled() || !PublishingFileFilter.matches(name, pattern.getPattern())) continue;
            return false;
        }
        if (resource.getParent() == null) {
            return true;
        }
        return this.accept((IResource)resource.getParent());
    }
}

