/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.modeshape.web.jcr.rest.client.Status;

public final class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String PREFERENCES_FILE = "prefs.properties";
    private Properties preferenceDefaults;

    public void initializeDefaultPreferences() {
        IEclipsePreferences defaultValues = DefaultScope.INSTANCE.getNode("org.jboss.tools.modeshape.rest");
        if (defaultValues == null) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.preferenceDefaultScopeNotFound, (Object)"org.jboss.tools.modeshape.rest"), null));
        } else {
            this.load();
            for (String property : this.preferenceDefaults.stringPropertyNames()) {
                defaultValues.put(property, this.preferenceDefaults.getProperty(property));
            }
        }
    }

    private void load() {
        block14: {
            this.preferenceDefaults = new Properties();
            InputStream input = null;
            try {
                try {
                    input = ((Object)((Object)this)).getClass().getResource(PREFERENCES_FILE).openStream();
                    if (input == null) {
                        Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.preferenceFileNotFound, (Object)PREFERENCES_FILE), null));
                        break block14;
                    }
                    this.preferenceDefaults.load(input);
                }
                catch (IOException iOException) {
                    Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.preferenceFileNotFound, (Object)PREFERENCES_FILE), null));
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.getDefault().log(new Status(Status.Severity.ERROR, e.getMessage(), (Throwable)e));
                    }
                }
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().log(new Status(Status.Severity.ERROR, e.getMessage(), (Throwable)e));
                }
            }
        }
    }
}

