/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.tools.modeshape.rest.preferences.ResourcePattern;
import org.modeshape.common.util.CheckArg;

public final class IgnoredResourcesModel {
    private static final char DELIMITER = '\n';
    private final Set<ResourcePattern> patterns = new HashSet<ResourcePattern>();

    public static String createList(ResourcePattern ... patterns) {
        StringBuilder value = new StringBuilder();
        ResourcePattern[] resourcePatternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            ResourcePattern pattern = resourcePatternArray[n2];
            value.append(pattern.getPattern()).append('\n').append(pattern.isEnabled()).append('\n');
            ++n2;
        }
        return value.toString();
    }

    public ResourcePattern[] parseList(String stringList) {
        if (stringList != null && !stringList.equals("")) {
            StringTokenizer st = new StringTokenizer(stringList, Character.toString('\n'));
            ResourcePattern[] patterns = new ResourcePattern[st.countTokens() > 0 ? st.countTokens() / 2 : 0];
            int i = 0;
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                boolean enabled = Boolean.parseBoolean(st.nextToken());
                patterns[i++] = new ResourcePattern(pattern, enabled);
            }
            return patterns;
        }
        return new ResourcePattern[0];
    }

    public void addPattern(ResourcePattern pattern) {
        CheckArg.isNotNull((Object)pattern, (String)"pattern");
        this.patterns.add(pattern);
    }

    public String createList() {
        return IgnoredResourcesModel.createList(this.patterns.toArray(new ResourcePattern[this.patterns.size()]));
    }

    public Collection<ResourcePattern> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public void load(String stringList) {
        this.patterns.clear();
        ResourcePattern[] temp = this.parseList(stringList);
        if (temp.length != 0) {
            this.patterns.addAll(Arrays.asList(temp));
        }
    }

    public void removePattern(ResourcePattern pattern) {
        CheckArg.isNotNull((Object)pattern, (String)"pattern");
        this.patterns.remove(pattern);
    }
}

