/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.domain;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.modeshape.rest.domain.ModeShapeDomainObject;
import org.jboss.tools.modeshape.rest.properties.ModeShapePropertySource;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;

@Immutable
public final class ModeShapeServer
implements IAdaptable,
ModeShapeDomainObject {
    private Server delegate;
    private final boolean persistPassword;

    public ModeShapeServer(String url, String user, String password, boolean persistPassword) {
        this.delegate = new Server(url, user, password);
        this.persistPassword = persistPassword;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ModeShapeServer that = (ModeShapeServer)obj;
        if (this.delegate.equals((Object)that.delegate)) {
            return this.persistPassword == that.persistPassword;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new ModeShapePropertySource(this);
        }
        return null;
    }

    public Server getDelegate() throws Exception {
        return this.validateDelegate();
    }

    @Override
    public String getName() {
        return this.delegate.getOriginalUrl();
    }

    public String getOriginalUrl() {
        return this.delegate.getOriginalUrl();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public String getShortDescription() {
        return this.delegate.getShortDescription();
    }

    public String getUrl() throws Exception {
        return this.validateDelegate().getUrl();
    }

    public String getUser() {
        return this.delegate.getUser();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean hasSameKey(ModeShapeServer server) {
        return this.delegate.hasSameKey(server.delegate);
    }

    public boolean isPasswordBeingPersisted() {
        return this.persistPassword;
    }

    public Server validateDelegate() throws Exception {
        if (!this.delegate.isValidated()) {
            this.delegate = new JsonRestClient().validate(this.delegate);
        }
        return this.delegate;
    }
}

