/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.dialogs;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.PublishedResourceHelper;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.modeshape.common.util.CheckArg;

public final class PublishedLocationsDialog
extends MessageDialog {
    private static final int SERVER_URL_COL = 0;
    private static final int USER_COL = 1;
    private static final int REPOSITORY_COL = 2;
    private static final int WORKSPACE_COL = 3;
    private static final int FILE_URL_COL = 4;
    private static final int[] COLUMNS;
    private static final String[] HEADERS;
    private Button btnCopy;
    private TableViewer viewer;
    private final Collection<PublishedResourceHelper.WorkspaceLocation> workspaceLocations;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        COLUMNS = nArray;
        HEADERS = new String[]{RestClientI18n.publishedLocationsDialogServerUrlColumnHeader, RestClientI18n.publishedLocationsDialogUserColumnHeader, RestClientI18n.publishedLocationsDialogRepositoryColumnHeader, RestClientI18n.publishedLocationsDialogWorkspaceColumnHeader, RestClientI18n.publishedLocationsDialogFileUrlColumnHeader};
    }

    public PublishedLocationsDialog(Shell parentShell, IFile file, Collection<PublishedResourceHelper.WorkspaceLocation> workspaceLocations) {
        super(parentShell, RestClientI18n.publishedLocationsDialogTitle, Activator.getDefault().getImage("icons/views/modeShape_icon_16x.png"), NLS.bind((String)RestClientI18n.publishedLocationsDialogMsg, (Object)file.getFullPath()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        CheckArg.isNotNull(workspaceLocations, (String)"workspaceLocations");
        this.workspaceLocations = workspaceLocations;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createCustomArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(panel, 2816);
        LocationsTableProvider provider = new LocationsTableProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                PublishedLocationsDialog.this.handleTableSelection();
            }
        });
        Table table = this.viewer.getTable();
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ((GridData)table.getLayoutData()).minimumHeight = table.getItemHeight() * 3;
        int locations = this.workspaceLocations.size() + 2;
        int numRows = locations < 6 ? locations : Math.min(locations, 12);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * numRows;
        int numCols = COLUMNS.length;
        int i = 0;
        while (i < numCols) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(HEADERS[i]);
            Image image = null;
            image = i == 0 || i == 1 ? Activator.getDefault().getImage("icons/objects/server.gif") : (i == 2 ? Activator.getDefault().getImage("icons/objects/repository.gif") : (i == 3 ? Activator.getDefault().getImage("icons/objects/workspace.gif") : Activator.getDefault().getImage("icons/views/blank.gif")));
            column.setImage(image);
            ++i;
        }
        this.viewer.setInput((Object)this);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            column.setWidth(column.getWidth() + 10);
            ++n2;
        }
        this.btnCopy = new Button(panel, 8);
        this.btnCopy.setText(RestClientI18n.publishedLocationsDialogCopyUrlButton);
        this.btnCopy.setToolTipText(RestClientI18n.publishedLocationsDialogCopyUrlButtonToolTip);
        this.btnCopy.setEnabled(false);
        this.btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishedLocationsDialog.this.handleCopyUrl();
            }
        });
        return panel;
    }

    String getPublishedAtUrl(PublishedResourceHelper.WorkspaceLocation workspaceLocation) {
        return workspaceLocation.getUrl();
    }

    Object[] getWorkspaceLocations() {
        return this.workspaceLocations.toArray();
    }

    void handleCopyUrl() {
        PublishedResourceHelper.WorkspaceLocation workspaceLocation = (PublishedResourceHelper.WorkspaceLocation)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        String url = this.getPublishedAtUrl(workspaceLocation);
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.setContents(new Object[]{url}, new Transfer[]{TextTransfer.getInstance()});
    }

    void handleTableSelection() {
        boolean enable;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean bl = enable = selection.size() == 1;
        if (this.btnCopy.getEnabled() != enable) {
            this.btnCopy.setEnabled(enable);
        }
    }

    class LocationsTableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        LocationsTableProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PublishedResourceHelper.WorkspaceLocation workspaceLocation = (PublishedResourceHelper.WorkspaceLocation)element;
            if (columnIndex == 0) {
                return workspaceLocation.getServer().getOriginalUrl();
            }
            if (columnIndex == 1) {
                return workspaceLocation.getServer().getUser();
            }
            if (columnIndex == 2) {
                return workspaceLocation.getRepository().getName();
            }
            if (columnIndex == 3) {
                return workspaceLocation.getWorkspace().getName();
            }
            if (columnIndex == 4) {
                return PublishedLocationsDialog.this.getPublishedAtUrl(workspaceLocation);
            }
            assert (false);
            return "";
        }

        public Object[] getElements(Object inputElement) {
            return PublishedLocationsDialog.this.getWorkspaceLocations();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

