/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.PublishedResourceHelper;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.dialogs.PublishedLocationsDialog;
import org.modeshape.web.jcr.rest.client.Status;

public final class ShowPublishedLocationsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection temp = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        assert (temp != null) : "selection is null";
        assert (!temp.isEmpty()) : "selection is empty";
        assert (temp instanceof IStructuredSelection) : "selection is not an IStructuredSelection";
        IStructuredSelection selection = (IStructuredSelection)temp;
        assert (selection.size() == 1) : "selection size is greater than one";
        assert (selection.getFirstElement() instanceof IFile) : "selected element is not a file";
        ServerManager serverManager = Activator.getDefault().getServerManager();
        PublishedResourceHelper resourceHelper = new PublishedResourceHelper(serverManager);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        try {
            Set<PublishedResourceHelper.WorkspaceLocation> workspaceLocations = resourceHelper.getPublishedWorkspaceLocations((IFile)selection.getFirstElement());
            PublishedLocationsDialog dialog = new PublishedLocationsDialog(shell, (IFile)selection.getFirstElement(), workspaceLocations);
            dialog.open();
        }
        catch (Exception e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.showPublishedLocationsErrorMsg, (Throwable)e));
            MessageDialog.openError((Shell)shell, (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.showPublishedLocationsErrorMsg);
        }
        return null;
    }
}

