/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.wizards.ServerWizard;

public final class EditServerAction
extends BaseSelectionListenerAction {
    private ModeShapeServer serverBeingEdited;
    private final ServerManager serverManager;
    private final Shell shell;

    public EditServerAction(Shell shell, ServerManager serverManager) {
        super(RestClientI18n.editServerActionText);
        this.setToolTipText(RestClientI18n.editServerActionToolTip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/edit_server.gif"));
        this.setEnabled(false);
        this.shell = shell;
        this.serverManager = serverManager;
    }

    public void run() {
        ServerWizard wizard = new ServerWizard(this.serverManager, this.serverBeingEdited);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setImage(Activator.getDefault().getImage("icons/views/modeShape_icon_16x.png"));
            }
        };
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() > 1) {
            this.serverBeingEdited = null;
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof ModeShapeServer) {
            this.serverBeingEdited = (ModeShapeServer)obj;
            return true;
        }
        this.serverBeingEdited = null;
        return false;
    }
}

