/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.jobs.PublishJob;
import org.jboss.tools.modeshape.rest.wizards.PublishWizard;
import org.modeshape.web.jcr.rest.client.Status;

abstract class BasePublishingHandler
implements IHandler {
    private final PublishJob.Type type;

    protected BasePublishingHandler(PublishJob.Type type) {
        this.type = type;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) {
        ISelection temp = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        assert (temp != null);
        assert (!temp.isEmpty());
        assert (temp instanceof IStructuredSelection);
        IStructuredSelection selection = (IStructuredSelection)temp;
        List<IResource> resources = selection.size() == 1 ? Collections.singletonList((IResource)selection.getFirstElement()) : selection.toList();
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        try {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)new PublishWizard(this.type, resources, Activator.getDefault().getServerManager())){

                protected void initializeBounds() {
                    super.initializeBounds();
                    this.getShell().setImage(Activator.getDefault().getImage("icons/views/modeShape_icon_16x.png"));
                }
            };
            dialog.open();
        }
        catch (CoreException e) {
            String msg = null;
            msg = this.type == PublishJob.Type.PUBLISH ? RestClientI18n.basePublishingActionPublishingWizardErrorMsg : RestClientI18n.basePublishingActionUnpublishingWizardErrorMsg;
            Activator.getDefault().log(new Status(Status.Severity.ERROR, msg, (Throwable)e));
            MessageDialog.openError((Shell)shell, (String)RestClientI18n.errorDialogTitle, (String)msg);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

