/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.web.jcr.rest.client.Status;

public final class PublishedResourceHelper {
    private static final String ID_DELIM = "$";
    private static final String DELIM = "|";
    private static QualifiedName PUBLISHED_RESOURCE_PROPERTY = new QualifiedName("org.jboss.tools.modeshape.rest", "publishedLocations");
    private final ServerManager serverManager;

    public PublishedResourceHelper(ServerManager serverManager) {
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        this.serverManager = serverManager;
    }

    public void addPublishedProperty(IFile file, ModeShapeWorkspace workspace, String url) throws Exception {
        CheckArg.isNotNull((Object)file, (String)"file");
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)url, (String)"url");
        Set<WorkspaceLocation> workspaceLocations = this.getPublishedWorkspaceLocations(file);
        workspaceLocations.add(new WorkspaceLocation(workspace, url));
        this.setPublishedOnPropertyValue(file, workspaceLocations);
    }

    private String createPublishedPropertyValue(Set<WorkspaceLocation> workspaceLocations) {
        StringBuilder value = new StringBuilder();
        for (WorkspaceLocation workspaceLocation : workspaceLocations) {
            value.append(this.createWorkspaceLocationId(workspaceLocation)).append(DELIM);
        }
        return value.toString();
    }

    private String createWorkspaceLocationId(WorkspaceLocation workspaceLocation) {
        ModeShapeWorkspace workspace = workspaceLocation.getWorkspace();
        StringBuilder result = new StringBuilder();
        result.append(workspace.getServer().getOriginalUrl()).append(ID_DELIM).append(workspace.getServer().getUser()).append(ID_DELIM);
        result.append(workspace.getRepository().getName()).append(ID_DELIM);
        result.append(workspace.getName()).append(ID_DELIM);
        result.append(workspaceLocation.getUrl());
        return result.toString();
    }

    public Set<WorkspaceLocation> getPublishedWorkspaceLocations(IFile file) throws Exception {
        CheckArg.isNotNull((Object)file, (String)"file");
        HashSet<WorkspaceLocation> publishedWorkspaceLocations = null;
        String value = file.getPersistentProperty(PUBLISHED_RESOURCE_PROPERTY);
        if (value == null) {
            publishedWorkspaceLocations = new HashSet<WorkspaceLocation>(1);
        } else {
            StringTokenizer wsTokenizer = new StringTokenizer(value, DELIM);
            publishedWorkspaceLocations = new HashSet(wsTokenizer.countTokens());
            block0: while (wsTokenizer.hasMoreTokens()) {
                StringTokenizer propsTokenizer = new StringTokenizer(wsTokenizer.nextToken(), ID_DELIM);
                while (propsTokenizer.hasMoreTokens()) {
                    String user;
                    String url = propsTokenizer.nextToken();
                    ModeShapeServer server = this.serverManager.findServer(url, user = propsTokenizer.nextToken());
                    if (server == null || !this.serverManager.ping(server).isOk()) continue block0;
                    Collection<ModeShapeRepository> repositories = this.serverManager.getRepositories(server);
                    if (repositories.isEmpty()) continue;
                    String repositoryName = propsTokenizer.nextToken();
                    for (ModeShapeRepository repository : repositories) {
                        Collection<ModeShapeWorkspace> workspaces;
                        if (!repository.getName().equals(repositoryName) || (workspaces = this.serverManager.getWorkspaces(repository)).isEmpty()) continue;
                        String workspaceName = propsTokenizer.nextToken();
                        for (ModeShapeWorkspace workspace : workspaces) {
                            if (!workspace.getName().equals(workspaceName)) continue;
                            String publishedUrl = propsTokenizer.nextToken();
                            publishedWorkspaceLocations.add(new WorkspaceLocation(workspace, publishedUrl));
                            continue block0;
                        }
                    }
                }
            }
        }
        return publishedWorkspaceLocations;
    }

    public boolean isPublished(IFile file) {
        CheckArg.isNotNull((Object)file, (String)"file");
        try {
            return !this.getPublishedWorkspaceLocations(file).isEmpty();
        }
        catch (Exception e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.publishedResourcePropertyErrorMsg, (Object)file), (Throwable)e));
            return false;
        }
    }

    public void removePublishedProperty(IFile file, ModeShapeWorkspace workspace, String url) throws Exception {
        CheckArg.isNotNull((Object)file, (String)"file");
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)url, (String)"url");
        Set<WorkspaceLocation> workspaceLocations = this.getPublishedWorkspaceLocations(file);
        workspaceLocations.remove(new WorkspaceLocation(workspace, url));
        this.setPublishedOnPropertyValue(file, workspaceLocations);
    }

    public void clear(IFile file) throws CoreException {
        file.setPersistentProperty(PUBLISHED_RESOURCE_PROPERTY, null);
    }

    private void setPublishedOnPropertyValue(IFile file, Set<WorkspaceLocation> workspaceLocations) throws CoreException {
        if (workspaceLocations == null || workspaceLocations.isEmpty()) {
            this.clear(file);
        } else {
            String value = this.createPublishedPropertyValue(workspaceLocations);
            file.setPersistentProperty(PUBLISHED_RESOURCE_PROPERTY, value);
        }
    }

    public class WorkspaceLocation {
        private final ModeShapeWorkspace workspace;
        private final String url;

        public WorkspaceLocation(ModeShapeWorkspace workspace, String url) {
            this.workspace = workspace;
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            WorkspaceLocation thatLocation = (WorkspaceLocation)obj;
            if (this.workspace.equals(thatLocation.workspace)) {
                if (this.url == null || this.url.equals("")) {
                    return thatLocation.url == null || thatLocation.url.equals("");
                }
                return this.url.equals(thatLocation.url);
            }
            return false;
        }

        public ModeShapeRepository getRepository() {
            return this.workspace.getRepository();
        }

        public ModeShapeServer getServer() {
            return this.workspace.getServer();
        }

        public ModeShapeWorkspace getWorkspace() {
            return this.workspace;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.workspace, this.url});
        }
    }
}

