/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.internal.command.ICommand;

public class CommandContainer
implements ICommand {
    List<ICommand> commands = new ArrayList<ICommand>();
    IFeatureProvider featureProvider;

    public CommandContainer(IFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    public boolean canExecute() {
        boolean ret = true;
        for (ICommand c : this.commands) {
            boolean bl = ret = ret && c.canExecute();
            if (!ret) break;
        }
        return ret;
    }

    public boolean execute() {
        if (!this.canExecute()) {
            return false;
        }
        boolean ret = true;
        for (ICommand c : this.commands) {
            boolean bl = ret = ret && c.execute();
        }
        return ret;
    }

    public boolean canUndo() {
        boolean ret = true;
        for (ICommand c : this.commands) {
            boolean bl = ret = ret && c.canUndo();
            if (!ret) break;
        }
        return ret;
    }

    public boolean undo() {
        if (!this.canUndo()) {
            return false;
        }
        boolean ret = true;
        for (ICommand c : this.commands) {
            boolean bl = ret = ret && c.undo();
        }
        return ret;
    }

    public void add(ICommand command) {
        this.commands.add(command);
    }

    public String getDescription() {
        int size = this.commands.size();
        String ret = "";
        if (size > 0) {
            if (size > 1) {
                ret = String.valueOf(size) + " " + Messages.CommandContainer_0_xfld;
                ret = String.valueOf(ret) + " (";
                boolean begin = true;
                for (ICommand c : this.commands) {
                    if (!begin) {
                        ret = String.valueOf(ret) + ", ";
                    }
                    ret = String.valueOf(ret) + c.getDescription();
                    begin = false;
                }
                ret = String.valueOf(ret) + ")";
            } else {
                ICommand firstCommand = this.commands.get(0);
                if (firstCommand != null) {
                    ret = firstCommand.getDescription();
                }
            }
        }
        return ret;
    }

    public boolean containsCommands() {
        return this.commands != null && this.commands.size() > 0;
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public ICommand[] getCommands() {
        return this.commands.toArray(new ICommand[0]);
    }
}

