/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.services.Graphiti;

public class UpdateNoBoFeature
extends AbstractUpdateFeature {
    public UpdateNoBoFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return context.getPictogramElement() != null;
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramLink linkForPictogramElement;
        IReason ret = Reason.createFalseReason();
        PictogramElement pe = context.getPictogramElement();
        if (pe != null && (linkForPictogramElement = Graphiti.getLinkService().getLinkForPictogramElement(pe)) != null && linkForPictogramElement.getBusinessObjects().isEmpty()) {
            ret = new Reason(true, "No business object linked to graphical representation");
        }
        return ret;
    }

    public boolean update(IUpdateContext context) {
        EList businessObject;
        PictogramLink linkForPictogramElement;
        boolean ret = false;
        PictogramElement pe = context.getPictogramElement();
        if (pe != null && (linkForPictogramElement = Graphiti.getLinkService().getLinkForPictogramElement(pe)) != null && (businessObject = linkForPictogramElement.getBusinessObjects()) != null && businessObject.isEmpty()) {
            ret = this.removeIfPossible(pe);
            ret = true;
        }
        return ret;
    }

    private boolean removeIfPossible(PictogramElement pe) {
        RemoveContext context = new RemoveContext(pe);
        IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature(context);
        if (removeFeature != null && removeFeature.canRemove(context)) {
            removeFeature.remove(context);
            return true;
        }
        return false;
    }
}

