/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public class DefaultReconnectionFeature
extends AbstractFeature
implements IReconnectionFeature {
    private static final String NAME = Messages.DefaultReconnectionFeature_0_xfld;

    public DefaultReconnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canReconnect(IReconnectionContext context) {
        Connection connection = context.getConnection();
        Anchor newAnchor = this.getNewAnchor(context);
        boolean ret = connection != null && newAnchor != null && connection.getStart() != null && connection.getEnd() != null && !(newAnchor.getParent() instanceof Diagram);
        return ret;
    }

    protected Anchor getNewAnchor(IReconnectionContext context) {
        return context.getNewAnchor();
    }

    public final void reconnect(IReconnectionContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        this.preReconnect(context);
        Connection connection = context.getConnection();
        Anchor newAnchor = context.getNewAnchor();
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
            connection.setStart(this.getNewAnchor(context));
        } else {
            connection.setEnd(newAnchor);
        }
        this.postReconnect(context);
    }

    public void preReconnect(IReconnectionContext context) {
    }

    public void postReconnect(IReconnectionContext context) {
    }

    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IReconnectionContext) {
            ret = this.canReconnect((IReconnectionContext)context);
        }
        return ret;
    }

    public void execute(IContext context) {
        if (context instanceof IReconnectionContext) {
            this.reconnect((IReconnectionContext)context);
        }
    }

    public String getName() {
        return NAME;
    }

    public void canceledReconnect(IReconnectionContext context) {
    }
}

