/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.util.ModelUtil;

public class AddDimensionViewHandleCommand
extends AbstractCrosstabCommand {
    private CrosstabCellAdapter handleAdpter;
    private int type = -1;
    private Object after = null;
    private LevelHandle[] levelHandles;
    private DimensionHandle[] dimensionHandles;
    private static final String NAME = Messages.getString("AddDimensionViewHandleCommand.TransName");

    public AddDimensionViewHandleCommand(CrosstabCellAdapter handleAdpter, int type, DimensionHandle dimensionHandle, Object after) {
        super((DesignElementHandle)dimensionHandle);
        this.setHandleAdpter(handleAdpter);
        this.setType(type);
        this.setDimensionHandles(new DimensionHandle[]{dimensionHandle});
        this.after = after;
        this.setLabel(NAME);
    }

    public void setHandleAdpter(CrosstabCellAdapter handleAdpter) {
        this.handleAdpter = handleAdpter;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean canExecute() {
        return this.getType() != -1;
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle crosstabHandle = this.handleAdpter.getCrosstabCellHandle().getCrosstab();
        int position = this.findPosition();
        int i = 0;
        while (i < this.dimensionHandles.length) {
            DimensionHandle dimensionHandle = this.dimensionHandles[i];
            try {
                if (crosstabHandle.getCube() == null) {
                    crosstabHandle.setCube(CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)dimensionHandle));
                }
                DimensionViewHandle viewHandle = crosstabHandle.insertDimension(dimensionHandle, this.getType(), position);
                LevelHandle[] levels = this.getLevelHandles(dimensionHandle);
                int j = 0;
                while (j < levels.length) {
                    LevelHandle levelHandle = levels[j];
                    if (levelHandle == null) {
                        this.rollBack();
                        return;
                    }
                    DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)crosstabHandle.getModelHandle()), levelHandle);
                    LevelViewHandle levelViewHandle = viewHandle.insertLevel(levelHandle, j);
                    CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                    cellHandle.addContent((DesignElementHandle)dataHandle);
                    ActionHandle actionHandle = levelHandle.getActionHandle();
                    if (actionHandle != null) {
                        ArrayList<IStructure> source = new ArrayList<IStructure>();
                        source.add(actionHandle.getStructure());
                        ArrayList newAction = ModelUtil.cloneStructList(source);
                        dataHandle.setAction((Action)newAction.get(0));
                    }
                    CrosstabUtil.addLabelToHeader((LevelViewHandle)levelViewHandle);
                    ++j;
                }
            }
            catch (Exception e) {
                this.rollBack();
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            ++i;
        }
        this.transEnd();
    }

    private LevelHandle[] getLevelHandles(DimensionHandle dimensionHandle) {
        if (this.levelHandles == null) {
            LevelHandle[] dimensionLevelHandles = new LevelHandle[dimensionHandle.getDefaultHierarchy().getLevelCount()];
            int i = 0;
            while (i < dimensionLevelHandles.length) {
                dimensionLevelHandles[i] = dimensionHandle.getDefaultHierarchy().getLevel(i);
                ++i;
            }
            return dimensionLevelHandles;
        }
        return this.levelHandles;
    }

    private int findPosition() {
        int index;
        int base = CrosstabAdaptUtil.getDimensionViewHandle((ExtendedItemHandle)this.handleAdpter.getCrosstabCellHandle().getModelHandle()).getModelHandle().getIndex();
        if (this.after instanceof DesignElementHandle && (index = ((DesignElementHandle)this.after).getIndex()) == 0) {
            return base;
        }
        return base + 1;
    }

    public void setLevelHandles(LevelHandle[] levelHandles) {
        this.levelHandles = levelHandles;
    }

    public DimensionHandle[] getDimensionHandles() {
        return this.dimensionHandles;
    }

    public void setDimensionHandles(DimensionHandle[] dimensionHandles) {
        this.dimensionHandles = dimensionHandles;
    }
}

