/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.LevelViewDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class ExtendedDataColumnXtabDropAdapter
implements IDropAdapter {
    private IExtendedDataModelUIAdapter adapter = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();

    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (!(transfer instanceof ReportElementHandle) || this.adapter == null || !this.adapter.isExtendedDataItem((ReportElementHandle)transfer)) {
            return 0;
        }
        if (target instanceof EditPart && (editPart = (EditPart)target).getModel() instanceof IVirtualValidator) {
            if (this.handleValidate(editPart, transfer) != null) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart targetPart = (EditPart)target;
            CrosstabReportItemHandle crosstab = this.getCrosstab(targetPart);
            if (crosstab == null) {
                return false;
            }
            CommandStack cmdStack = crosstab.getModuleHandle().getCommandStack();
            cmdStack.startTrans(Messages.getFormattedString("ExtendedDataColumnXtabDropAdapter.trans.add", new String[]{((ReportElementHandle)transfer).getName()}));
            ReportElementHandle extendedData = this.adapter.getBoundExtendedData((ReportItemHandle)crosstab.getModelHandle());
            if (!(extendedData != null && extendedData.equals(this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))) || this.adapter.setExtendedData((ReportItemHandle)crosstab.getModelHandle(), this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))))) {
                cmdStack.rollback();
                return false;
            }
            Object[] element = this.handleValidate(targetPart, transfer);
            if (element instanceof MeasureHandle) {
                CreateRequest request = new CreateRequest();
                request.getExtendedData().put("newObject", element);
                request.setLocation(location.getPoint());
                Command command = targetPart.getCommand((Request)request);
                if (command != null && command.canExecute()) {
                    targetPart.getViewer().getEditDomain().getCommandStack().execute(command);
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                    if (crosstab.getDimensionCount(1) != 0) {
                        DimensionViewHandle viewHnadle = crosstab.getDimension(1, crosstab.getDimensionCount(1) - 1);
                        CrosstabUtil.addLabelToHeader((LevelViewHandle)viewHnadle.getLevel(viewHnadle.getLevelCount() - 1));
                    }
                    cmdStack.commit();
                    return true;
                }
            } else if (element instanceof DimensionHandle) {
                if (((DimensionHandle)element).isTimeType()) {
                    LevelViewDialog dialog = new LevelViewDialog(UIUtil.getDefaultShell());
                    dialog.setInput((DimensionHandle)element, this.adapter.getLevelHints((DimensionHandle)element));
                    if (dialog.open() != 0) {
                        cmdStack.rollback();
                        return false;
                    }
                    element = ((List)dialog.getResult()).toArray();
                }
                CreateRequest request = new CreateRequest();
                request.getExtendedData().put("newObject", element);
                request.setLocation(location.getPoint());
                Command command = targetPart.getCommand((Request)request);
                if (command != null && command.canExecute()) {
                    targetPart.getViewer().getEditDomain().getCommandStack().execute(command);
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                    cmdStack.commit();
                    return true;
                }
            }
        }
        return false;
    }

    private CrosstabReportItemHandle getCrosstab(EditPart editPart) {
        CrosstabReportItemHandle crosstab = null;
        Object tmp = editPart.getModel();
        if (!(tmp instanceof CrosstabCellAdapter)) {
            return null;
        }
        if (tmp instanceof VirtualCrosstabCellAdapter) {
            return ((VirtualCrosstabCellAdapter)tmp).getCrosstabReportItemHandle();
        }
        CrosstabCellHandle handle = ((CrosstabCellAdapter)tmp).getCrosstabCellHandle();
        if (handle != null) {
            crosstab = handle.getCrosstab();
        }
        return crosstab;
    }

    private Object handleValidate(EditPart editPart, Object transfer) {
        ReportElementHandle[] supportedTypes;
        if (!(transfer instanceof ReportElementHandle)) {
            return null;
        }
        ReportElementHandle[] reportElementHandleArray = supportedTypes = this.adapter.getSupportedTypes((ReportElementHandle)transfer, (ReportElementHandle)this.getCrosstab(editPart).getCube());
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ReportElementHandle type = reportElementHandleArray[n2];
            if (((IVirtualValidator)editPart.getModel()).handleValidate((Object)type)) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

