/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.runtime.ext;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.events.CommandExecuted;

public class EventHandler {
    private static final String ESCAPE = new String(new char[]{'\u001b', '%'});
    @Inject
    private Shell shell;
    private static boolean ENABLED = true;

    public void handleCommandExecuted(@Observes CommandExecuted event) {
        if (!ENABLED) {
            return;
        }
        Resource currentResource = this.shell.getCurrentResource();
        String currentResourceName = currentResource.getFullyQualifiedName();
        String currentResourceType = currentResource.getClass().getSimpleName();
        Project project = this.shell.getCurrentProject();
        String projectName = "";
        if (project != null) {
            projectName = project.getProjectRoot().getFullyQualifiedName();
        }
        String parameterString = this.getParameterString(event);
        String command = String.valueOf(event.getCommand().getParent().getName()) + " " + event.getCommand().getName();
        this.sendEscaped(" EC: " + command + " CRN: " + currentResourceName + " CRT: " + currentResourceType + " CPN: " + projectName + " PAR: " + parameterString);
    }

    public static void setEnabled(boolean b) {
        ENABLED = b;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    private String getParameterString(CommandExecuted event) {
        return this.flattenObjectArray(event.getParameters());
    }

    private String flattenObjectArray(Object[] objects) {
        String result = "";
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Object[]) {
                result = String.valueOf(result) + '[' + this.flattenObjectArray((Object[])object) + ']';
            } else {
                result = String.valueOf(result) + object;
                result = String.valueOf(result) + ' ';
            }
            ++n2;
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEscaped(String str) {
        Shell shell = this.shell;
        synchronized (shell) {
            this.shell.print(String.valueOf(ESCAPE) + str + ESCAPE);
        }
    }
}

