/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.facet;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.esb.core.StatusUtils;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.messages.JBossFacetCoreMessages;

public class UninstallJBossClassPathCommand {
    IProject project;

    public UninstallJBossClassPathCommand(IProject project, IDataModel model) {
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeOverride(monitor);
    }

    public IStatus executeOverride(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            boolean isServerSupplied = Boolean.getBoolean(this.project.getPersistentProperty(IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME));
            if (!isServerSupplied) {
                String runtimeName = this.project.getPersistentProperty(IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME);
                status = this.removeClassPath(this.project, runtimeName);
            }
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus(JBossFacetCoreMessages.Error_Remove_Facet_JBossESB, e);
        }
        return status;
    }

    public IStatus removeClassPath(IProject project, String segment) {
        IStatus status = Status.OK_STATUS;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] oldClasspathEntries = javaProject.readRawClasspath();
            boolean isFolderInClassPathAlready = false;
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < oldClasspathEntries.length && !isFolderInClassPathAlready) {
                if (!oldClasspathEntries[i].getPath().equals((Object)new Path("org.jboss.esb.runtime.classpath").append(segment))) {
                    classpathEntries.add(oldClasspathEntries[i]);
                }
                ++i;
            }
            if (classpathEntries.size() < oldClasspathEntries.length) {
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            status = StatusUtils.errorStatus(NLS.bind((String)JBossFacetCoreMessages.Error_Remove_Facet_JBossESB, (Object[])new String[]{e.getLocalizedMessage()}), e);
            return status;
        }
        return status;
    }
}

