/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.switchyard.tools.cxf.WSDL2JavaOptions;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateJavaFromWSDLOperation;

public class WSDL2JavaOptionsWizardPage
extends NewTypeWizardPage {
    private static final String WSDL_FILE = "WSDL_FILE";
    private IStatus _wsdlFileStatus = Status.OK_STATUS;
    private StringButtonDialogField _wsdlFileDialogField;
    private SelectionButtonDialogField _overwriteCheckField;
    private SelectionButtonDialogField _generateTypesCheckField;
    private SelectionButtonDialogField _wrappedCheckField;

    public WSDL2JavaOptionsWizardPage() {
        super(true, WSDL2JavaOptionsWizardPage.class.getName());
        this.setTitle(Messages.WSDL2JavaOptionsWizardPage_wizardPageTitle);
        this.setDescription(Messages.WSDL2JavaOptionsWizardPage_wizardPageDescription);
        this._wsdlFileDialogField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                WSDL2JavaOptionsWizardPage.this.browseWSDL();
            }
        });
        this._wsdlFileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                WSDL2JavaOptionsWizardPage.this.handleFieldChanged(WSDL2JavaOptionsWizardPage.WSDL_FILE);
            }
        });
        this._wsdlFileDialogField.setLabelText(Messages.WSDL2JavaOptionsWizardPage_labelWSDLFile);
        this._wsdlFileDialogField.setButtonLabel(Messages.WSDL2JavaOptionsWizardPage_buttonBrowse);
        this._wrappedCheckField = new SelectionButtonDialogField(32);
        this._wrappedCheckField.setLabelText(Messages.WSDL2JavaOptionsWizardPage_checkboxLabelCreateWrapperForMessageParts);
        this._generateTypesCheckField = new SelectionButtonDialogField(32);
        this._generateTypesCheckField.setLabelText(Messages.WSDL2JavaOptionsWizardPage_checkboxLabelGenerateParameterAndResultTypes);
        this._overwriteCheckField = new SelectionButtonDialogField(32);
        this._overwriteCheckField.setLabelText(Messages.WSDL2JavaOptionsWizardPage_checkboxLabelOverwriteExistingFiles);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        WSDL2JavaOptions options = new WSDL2JavaOptions();
        options.setGenerateTypes(this._generateTypesCheckField.isSelected());
        options.setOutputFolder((IContainer)this.getPackageFragmentRoot().getResource());
        options.setOverwrite(this._overwriteCheckField.isSelected());
        options.setTargetPackage(this.getPackageFragment());
        options.setWrapped(this._wrappedCheckField.isSelected());
        options.setWSDLFile(this.getWSDLFile());
        new CreateJavaFromWSDLOperation(options).run(monitor);
    }

    public void init(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IJavaElement elem = this.getInitialJavaElement(selection);
        this.initContainerPage(elem);
        this.initTypePage(elem);
        IFile file = (IFile)Platform.getAdapterManager().getAdapter(selection.getFirstElement(), IFile.class);
        if (this.wsdlFileChanged(file).isOK()) {
            this._wsdlFileDialogField.setText(file.getFullPath().toString());
        }
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof ISwitchYardNode) {
                return JavaUtil.getInitialJavaElementForResource((IResource)((ISwitchYardNode)obj).getRoot().getProject());
            }
            if (obj instanceof IJavaElement) {
                return JavaUtil.getInitialPackageForProject(((IJavaElement)obj).getJavaProject());
            }
            if (obj instanceof IResource) {
                return JavaUtil.getInitialJavaElementForResource((IResource)((IResource)obj).getProject());
            }
        }
        return super.getInitialJavaElement(selection);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 4;
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(nColumns, false));
        this.createContainerControls(contents, nColumns);
        this.createPackageControls(contents, nColumns);
        this.createSeparator(contents, nColumns);
        this.createTypeSelectionControls(contents, nColumns);
        this.createWrappedControls(contents, nColumns);
        this.createGenerateTypesControls(contents, nColumns);
        this.createOverwriteControls(contents, nColumns);
        this._generateTypesCheckField.setSelection(true);
        this._overwriteCheckField.setSelection(true);
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.handleFieldChanged(WSDL_FILE);
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    private void createTypeSelectionControls(Composite composite, int nColumns) {
        this._wsdlFileDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this._wsdlFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        TextFieldNavigationHandler.install((Text)text);
    }

    private void createWrappedControls(Composite composite, int nColumns) {
        DialogField.createEmptySpace((Composite)composite);
        this._wrappedCheckField.doFillIntoGrid(composite, nColumns - 1);
    }

    private void createGenerateTypesControls(Composite composite, int nColumns) {
        DialogField.createEmptySpace((Composite)composite);
        this._generateTypesCheckField.doFillIntoGrid(composite, nColumns - 1);
    }

    private void createOverwriteControls(Composite composite, int nColumns) {
        DialogField.createEmptySpace((Composite)composite);
        this._overwriteCheckField.doFillIntoGrid(composite, nColumns - 1);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (WSDL_FILE.equals(fieldName)) {
            this._wsdlFileStatus = this.wsdlFileChanged(this.getWSDLFile());
        } else if ("NewTypeWizardPage.package".equals(fieldName) && !this.fPackageStatus.matches(4) && this.getPackageFragment().isDefaultPackage()) {
            ((StatusInfo)this.fPackageStatus).setError(Messages.WSDL2JavaOptionsWizardPage_errorMessage_cannotGenerateIntoDefaultPackage);
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this._wsdlFileStatus});
    }

    private void browseWSDL() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)this.getWorkspaceRoot(), 1){

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredResourcesSelectionDialog.ResourceFilter(this){

                    public boolean matchItem(Object item) {
                        IResource resource = (IResource)item;
                        return super.matchItem(item) && "wsdl".equals(resource.getFileExtension());
                    }
                };
            }
        };
        dialog.setInitialPattern("* ");
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length != 1 || !(result[0] instanceof IResource)) {
                return;
            }
            this._wsdlFileDialogField.setText(((IResource)result[0]).getFullPath().toString());
        }
    }

    private IFile getWSDLFile() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this._wsdlFileDialogField.getText());
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private IStatus wsdlFileChanged(IFile wsdlFile) {
        if (wsdlFile == null || !wsdlFile.exists() || !wsdlFile.isAccessible()) {
            return new Status(4, "org.switchyard.tools.ui", Messages.WSDL2JavaOptionsWizardPage_errorStatus_specifiedWSDLDoesNotExist);
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType wsdlType = manager.getContentType("org.eclipse.wst.wsdl.wsdlsource");
        IContentType[] iContentTypeArray = manager.findContentTypesFor(wsdlFile.getName());
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType type = iContentTypeArray[n2];
            if (type.isKindOf(wsdlType)) {
                return Status.OK_STATUS;
            }
            ++n2;
        }
        return new Status(4, "org.switchyard.tools.ui", Messages.WSDL2JavaOptionsWizardPage_errorStatus_specifiedFileNotAWSDL);
    }
}

