/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.ui.explorer.ISwitchYardRootNode;
import org.switchyard.tools.ui.explorer.impl.ComponentReference;
import org.switchyard.tools.ui.explorer.impl.ComponentService;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.wizards.Java2WSDLWizard;

public class Java2WSDLOptionsWizardPage
extends WizardPage {
    private static final String DEFAULT_LOCATION = "http://localhost:8080/%1$s/%2$s";
    private static final String DEFAULT_LOCATION_MATCH = "(^.+?:.*\\/)%1$s$";
    private IStructuredSelection _selection;
    private boolean _isInitialized;
    private IType _serviceInterface;
    private String _serviceName;
    private String _oldServiceName;
    private String _targetNamespace;
    private String _applicationName;
    private String _locationURI = String.format("http://localhost:8080/%1$s/%2$s", "", "");
    private boolean _useImportedSchema;
    private boolean _useWrappedMessages = true;
    private Text _serviceInterfaceText;
    private Text _serviceNameText;
    private Text _targetNamespaceText;
    private Text _locationURIText;
    private Button _useWrappedMessagesCheck;
    private Button _useImportedSchemaCheck;

    public Java2WSDLOptionsWizardPage() {
        super(Java2WSDLOptionsWizardPage.class.getName());
        this.setTitle(Messages.Java2WSDLOptionsWizardPage_wizardPageTitle);
        this.setDescription(Messages.Java2WSDLOptionsWizardPage_wizardPageDescription);
    }

    public void init(IStructuredSelection selection) {
        this._selection = selection;
    }

    private void init() {
        if (this._selection == null || this._selection.isEmpty()) {
            return;
        }
        this._isInitialized = true;
        Object obj = this._selection.getFirstElement();
        if (obj instanceof IProject) {
            this.initFromProject((IProject)obj);
        } else if (obj instanceof ISwitchYardRootNode) {
            this.initFromSwitchYardRoot((ISwitchYardRootNode)obj);
        } else if (obj instanceof ComponentService) {
            this.initFromComponentService((ComponentService)obj);
        } else if (obj instanceof ComponentReference) {
            this.initFromComponentReference((ComponentReference)obj);
        } else if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            IJavaElement javaElement = JavaCore.create((IFile)file);
            if (javaElement instanceof IType) {
                this.initFromType((IType)javaElement);
            } else if (javaElement instanceof ICompilationUnit) {
                this.initFromCU((ICompilationUnit)javaElement);
            } else {
                this.initFromProject(file.getProject());
            }
        } else if (obj instanceof IResource) {
            this.initFromProject(((IResource)obj).getProject());
        } else if (obj instanceof IJavaElement) {
            this.initFromJavaElement((IJavaElement)obj);
        }
    }

    private void initFromJavaElement(IJavaElement javaElement) {
        if (javaElement.getElementType() == 7) {
            this.initFromType((IType)javaElement);
        } else if (javaElement.getElementType() == 5) {
            this.initFromCU((ICompilationUnit)javaElement);
        } else if (javaElement.getJavaProject() != null) {
            this.initFromProject(javaElement.getJavaProject().getProject());
        }
    }

    private void initFromCU(ICompilationUnit icu) {
        this._serviceInterface = icu.findPrimaryType();
        if (this._serviceInterface != null) {
            this.initFromType(this._serviceInterface);
        }
    }

    private void initFromType(IType type) {
        this._serviceInterface = type;
        this._serviceName = this._serviceInterface.getElementName();
        if (this._serviceInterface.getJavaProject() != null) {
            this.initFromProject(this._serviceInterface.getJavaProject().getProject());
        }
    }

    private void initFromComponentReference(ComponentReference reference) {
        IJavaProject javaProject = JavaCore.create((IProject)reference.getRoot().getProject());
        if (reference.getModel().getInterface() != null && reference.getModel().getInterface().getInterface() != null) {
            try {
                this._serviceInterface = javaProject.findType(reference.getModel().getInterface().getInterface());
            }
            catch (JavaModelException e) {
                e.fillInStackTrace();
            }
        }
        this._serviceName = reference.getModel().getName();
        this._targetNamespace = reference.getRoot().getTargetNamespace();
        this._applicationName = reference.getRoot().getName();
        this._locationURI = String.format(DEFAULT_LOCATION, this._applicationName, this._serviceName);
    }

    private void initFromComponentService(ComponentService service) {
        IJavaProject javaProject = JavaCore.create((IProject)service.getRoot().getProject());
        if (service.getModel().getInterface() != null && service.getModel().getInterface().getInterface() != null) {
            try {
                this._serviceInterface = javaProject.findType(service.getModel().getInterface().getInterface());
            }
            catch (JavaModelException e) {
                e.fillInStackTrace();
            }
        }
        this._serviceName = service.getModel().getName();
        this._targetNamespace = service.getRoot().getTargetNamespace();
        this._applicationName = service.getRoot().getName();
        this._locationURI = String.format(DEFAULT_LOCATION, this._applicationName, this._serviceName);
    }

    private void initFromSwitchYardRoot(ISwitchYardRootNode root) {
        this._targetNamespace = root.getTargetNamespace();
        this._applicationName = root.getName();
        this._locationURI = String.format(DEFAULT_LOCATION, this._applicationName, "");
    }

    private void initFromProject(final IProject project) {
        try {
            this.getWizard().getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SwitchYardRootNode switchYardNode = new SwitchYardRootNode(project);
                    switchYardNode.reload(monitor);
                    Java2WSDLOptionsWizardPage.this._targetNamespace = switchYardNode.getTargetNamespace();
                    Java2WSDLOptionsWizardPage.this._applicationName = switchYardNode.getName();
                    Java2WSDLOptionsWizardPage.this._locationURI = String.format(Java2WSDLOptionsWizardPage.DEFAULT_LOCATION, Java2WSDLOptionsWizardPage.this._applicationName, Java2WSDLOptionsWizardPage.this._serviceName == null ? "" : Java2WSDLOptionsWizardPage.this._serviceName);
                }
            });
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(contents, 0);
        label.setText(Messages.Java2WSDLOptionsWizardPage_labelServiceInterface);
        this._serviceInterfaceText = new Text(contents, 2060);
        this._serviceInterfaceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button selectType = new Button(contents, 8);
        selectType.setText(Messages.Java2WSDLOptionsWizardPage_labelSelectType);
        selectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Object[] result;
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Java2WSDLOptionsWizardPage.this.getShell(), (IRunnableContext)Java2WSDLOptionsWizardPage.this.getWizard().getContainer(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JavaCore.create((IProject)Java2WSDLOptionsWizardPage.this.getTargetProject())}), (int)6, (boolean)false, (String)Java2WSDLOptionsWizardPage.this._serviceInterfaceText.getText());
                    if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof IType) {
                        Java2WSDLOptionsWizardPage.this._serviceInterface = (IType)result[0];
                        Java2WSDLOptionsWizardPage.this._serviceInterfaceText.setText(Java2WSDLOptionsWizardPage.this._serviceInterface.getFullyQualifiedName());
                        String newServiceName = Java2WSDLOptionsWizardPage.this._serviceInterface.getElementName();
                        if (Java2WSDLOptionsWizardPage.this.updateDefault(Java2WSDLOptionsWizardPage.this._oldServiceName, newServiceName, Java2WSDLOptionsWizardPage.this._serviceName)) {
                            Java2WSDLOptionsWizardPage.this._serviceNameText.setText(newServiceName);
                        }
                        Java2WSDLOptionsWizardPage.this._oldServiceName = newServiceName;
                    }
                }
                catch (JavaModelException e) {
                    e.fillInStackTrace();
                }
            }
        });
        label = new Label(contents, 0);
        label.setText(Messages.Java2WSDLOptionsWizardPage_labelServiceName);
        this._serviceNameText = new Text(contents, 2052);
        this._serviceNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._serviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Matcher matcher = Pattern.compile(String.format(Java2WSDLOptionsWizardPage.DEFAULT_LOCATION_MATCH, Java2WSDLOptionsWizardPage.this._serviceName == null ? "" : Java2WSDLOptionsWizardPage.this._serviceName)).matcher(Java2WSDLOptionsWizardPage.this._locationURI);
                Java2WSDLOptionsWizardPage.this._serviceName = Java2WSDLOptionsWizardPage.this._serviceNameText.getText();
                if (matcher.matches()) {
                    Java2WSDLOptionsWizardPage.this._locationURIText.setText(matcher.replaceFirst("$1" + Java2WSDLOptionsWizardPage.this._serviceName));
                }
                Java2WSDLOptionsWizardPage.this.validate();
            }
        });
        label = new Label(contents, 0);
        label.setText(Messages.Java2WSDLOptionsWizardPage_labelTargetNamespace);
        this._targetNamespaceText = new Text(contents, 2052);
        this._targetNamespaceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._targetNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2WSDLOptionsWizardPage.this._targetNamespace = Java2WSDLOptionsWizardPage.this._targetNamespaceText.getText();
                Java2WSDLOptionsWizardPage.this.validate();
            }
        });
        label = new Label(contents, 0);
        label.setText(Messages.Java2WSDLOptionsWizardPage_labelEndpointURI);
        this._locationURIText = new Text(contents, 2052);
        this._locationURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._locationURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2WSDLOptionsWizardPage.this._locationURI = Java2WSDLOptionsWizardPage.this._locationURIText.getText();
                Java2WSDLOptionsWizardPage.this.validate();
            }
        });
        new Label(contents, 0);
        this._useWrappedMessagesCheck = new Button(contents, 32);
        this._useWrappedMessagesCheck.setText(Messages.Java2WSDLOptionsWizardPage_checkboxUseWrappedMessages);
        this._useWrappedMessagesCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._useWrappedMessagesCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2WSDLOptionsWizardPage.this._useWrappedMessages = Java2WSDLOptionsWizardPage.this._useWrappedMessagesCheck.getSelection();
                Java2WSDLOptionsWizardPage.this.validate();
            }
        });
        new Label(contents, 0);
        this._useImportedSchemaCheck = new Button(contents, 32);
        this._useImportedSchemaCheck.setText(Messages.Java2WSDLOptionsWizardPage_checkboxUseImportsForGeneratedSchemas);
        this._useImportedSchemaCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._useImportedSchemaCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2WSDLOptionsWizardPage.this._useImportedSchema = Java2WSDLOptionsWizardPage.this._useImportedSchemaCheck.getSelection();
                Java2WSDLOptionsWizardPage.this.validate();
            }
        });
        this.setDefaults();
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    public IType getServiceInterface() {
        return this._serviceInterface;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getLocationURI() {
        return this._locationURI;
    }

    public boolean isUseWrappedMessages() {
        return this._useWrappedMessages;
    }

    public boolean isUseImportedSchema() {
        return this._useImportedSchema;
    }

    private IProject getTargetProject() {
        return ((Java2WSDLWizard)this.getWizard()).getTargetProject();
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this._serviceInterface == null) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_mustSelectServiceInterface);
        } else if (this._serviceName == null || this._serviceName.length() == 0) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyServiceName);
        } else if (this._serviceName.matches("[^_\\p{Alpha}]")) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_serviceNameMustStartWithUnderscoreOrLetter);
        } else if (this._serviceName.matches(".*:")) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_invalidColonInServiceName);
        } else if (this._targetNamespace == null || this._targetNamespace.length() == 0) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyTargetNamespace);
        } else if (this._locationURI == null || this._locationURI.length() == 0) {
            this.setErrorMessage(Messages.Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyEndpointURI);
        } else {
            try {
                new URI(this._targetNamespace);
            }
            catch (URISyntaxException e) {
                this.setErrorMessage(String.valueOf(Messages.Java2WSDLOptionsWizardPage_errorMessage_invalidTargetNamespace) + e.getReason());
            }
            try {
                new URI(this._locationURI);
            }
            catch (URISyntaxException e) {
                this.setErrorMessage(String.valueOf(Messages.Java2WSDLOptionsWizardPage_errorMessage_invalidEndpoint) + e.getReason());
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void setDefaults() {
        this.init();
        if (this._serviceInterface != null) {
            this._serviceInterfaceText.setText(this._serviceInterface.getFullyQualifiedName());
        }
        if (this._serviceName != null) {
            this._serviceNameText.setText(this._serviceName);
        }
        if (this._targetNamespace != null) {
            this._targetNamespaceText.setText(this._targetNamespace);
        }
        if (this._locationURI != null) {
            this._locationURIText.setText(this._locationURI);
        }
        this._useWrappedMessagesCheck.setSelection(this._useWrappedMessages);
    }

    public void setVisible(boolean visible) {
        if (visible && !this._isInitialized) {
            this._selection = new StructuredSelection((Object)this.getTargetProject());
            this.setDefaults();
            this.setErrorMessage(null);
        }
        super.setVisible(visible);
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return currentValue == null || currentValue.length() == 0 || !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || currentValue.matches(oldValue));
    }
}

