/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.config.model.switchyard.ArtifactsModel;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.wizards.NewArtifactReferenceWizard;

public class ArtifactDetailsWizardPage
extends WizardPage {
    private boolean _supportsDownload;
    private Text _nameText;
    private Text _urlText;
    private Button _downloadCheckbox;

    protected ArtifactDetailsWizardPage(boolean supportsDownload) {
        super(ArtifactDetailsWizardPage.class.getName());
        this._supportsDownload = supportsDownload;
        this.setTitle(Messages.ArtifactDetailsWizardPage_wizardPageTitle);
        this.setDescription(Messages.ArtifactDetailsWizardPage_wizardPageDescription);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(content, 0);
        label.setText(Messages.ArtifactDetailsWizardPage_labelArtifactName);
        this._nameText = new Text(content, 2052);
        this._nameText.setLayoutData((Object)new GridData(768));
        this._nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactDetailsWizardPage.this.validate();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.ArtifactDetailsWizardPage_labelArtifactURL);
        this._urlText = new Text(content, 2052);
        this._urlText.setLayoutData((Object)new GridData(768));
        this._urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactDetailsWizardPage.this.validate();
            }
        });
        this._downloadCheckbox = new Button(content, 32);
        this._downloadCheckbox.setText(Messages.ArtifactDetailsWizardPage__checkboxLabelDownloadArtifactToWorkspace);
        this._downloadCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this._downloadCheckbox.setEnabled(this._supportsDownload);
        this._downloadCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArtifactDetailsWizardPage.this.getContainer().updateButtons();
            }
        });
        this.validate();
        this.setErrorMessage(null);
        this._nameText.setFocus();
        this.setControl((Control)content);
    }

    public String getArtifactName() {
        if (this._nameText == null) {
            return null;
        }
        return this._nameText.getText();
    }

    public void setArtifactName(String name) {
        if (this._nameText == null) {
            return;
        }
        this._nameText.setText(name == null ? "" : name);
    }

    public String getArtifactURL() {
        if (this._urlText == null) {
            return null;
        }
        return this._urlText.getText();
    }

    public void setArtifactURL(String url) {
        if (this._urlText == null) {
            return;
        }
        this._urlText.setText(url == null ? "" : url);
    }

    public boolean isDownloadArtifact() {
        if (this._downloadCheckbox == null) {
            return false;
        }
        return this._downloadCheckbox.getSelection();
    }

    private void validate() {
        if (this._nameText.getText().isEmpty()) {
            this.setErrorMessage(Messages.ArtifactDetailsWizardPage_errorMessage_mustSpecifyName);
        } else if (this.isDuplicateName(this._nameText.getText())) {
            this.setErrorMessage(Messages.ArtifactDetailsWizardPage_errorMessage_nameAlreadyExists);
        } else if (this._urlText.getText().isEmpty()) {
            this.setErrorMessage(Messages.ArtifactDetailsWizardPage_errorMessage_mustSpecifyURL);
        } else {
            try {
                new URL(this._urlText.getText());
                this.setErrorMessage(null);
            }
            catch (MalformedURLException e) {
                String message = NLS.bind((String)Messages.ArtifactDetailsWizardPage_errorMessage_urlInvalid, (Object)e.getLocalizedMessage());
                this.setErrorMessage(message);
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private boolean isDuplicateName(String name) {
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewArtifactReferenceWizard) {
            ArtifactsModel artifacts = ((NewArtifactReferenceWizard)wizard).getArtifacts();
            if (artifacts == null) {
                return false;
            }
            for (ArtifactModel artifact : artifacts.getArtifacts()) {
                if (!name.equals(artifact.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

