/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;

public class ServiceInterfaceConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Contract) {
            return this.validate(ctx, (Contract)eObj);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validate(IValidationContext ctx, Contract contract) {
        if (contract.getInterface() == null) {
            if (contract instanceof Service) {
                return ctx.createSuccessStatus();
            }
            if (contract instanceof Reference) {
                EList promotions = ((Reference)contract).getPromote();
                if (promotions != null && promotions.size() > 1) {
                    Interface baseInterface = ((ComponentReference)promotions.get(0)).getInterface();
                    for (ComponentReference promotedReference : promotions) {
                        if (EcoreUtil.equals((EObject)baseInterface, (EObject)promotedReference.getInterface())) continue;
                        return ctx.createFailureStatus(new Object[0]);
                    }
                }
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }
}

