/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.operations;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.AbstractSwitchYardProjectOperation;
import org.switchyard.tools.ui.wizards.NewBeanServiceClassWizardPage;
import org.switchyard.tools.ui.wizards.NewServiceTestClassWizardPage;

public class CreateBeanServiceOperation
extends AbstractSwitchYardProjectOperation {
    private static final Collection<ISwitchYardComponentExtension> REQUIRED_COMPONENTS;
    private NewBeanServiceClassWizardPage _serviceClassPage;
    private NewServiceTestClassWizardPage _serviceTestClassPage;

    static {
        ISwitchYardComponentExtension found = null;
        for (ISwitchYardComponentExtension extension : SwitchYardComponentExtensionManager.instance().getComponentExtensions()) {
            if (!"org.switchyard.components:switchyard-component-bean".equals(extension.getId())) continue;
            found = extension;
            break;
        }
        REQUIRED_COMPONENTS = found == null ? Collections.emptySet() : Collections.singleton(found);
    }

    public CreateBeanServiceOperation(NewBeanServiceClassWizardPage serviceClassPage, NewServiceTestClassWizardPage serviceTestClassPage, IAdaptable uiInfo) {
        this(serviceClassPage, serviceTestClassPage, true, uiInfo);
    }

    public CreateBeanServiceOperation(NewBeanServiceClassWizardPage serviceClassPage, NewServiceTestClassWizardPage serviceTestClassPage, boolean addServices, IAdaptable uiInfo) {
        super(null, REQUIRED_COMPONENTS, addServices, Messages.CreateBeanServiceOperation_wizardPageDescription_creatingNewBeanService, uiInfo);
        this._serviceClassPage = serviceClassPage;
        this._serviceTestClassPage = serviceTestClassPage;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 100);
            monitor.subTask(Messages.CreateBeanServiceOperation_taskLabel_creatingServiceImplementation);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50, 4);
            try {
                try {
                    this._serviceClassPage.createType((IProgressMonitor)subMonitor);
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(8, "org.switchyard.tools.ui", e.getMessage(), (Throwable)e));
                }
            }
            finally {
                subMonitor.done();
                subMonitor.setTaskName("");
            }
            try {
                try {
                    if (this._serviceTestClassPage != null) {
                        monitor.subTask(Messages.CreateBeanServiceOperation_taskLabel_creatingServiceTest);
                        subMonitor = new SubProgressMonitor(monitor, 50, 4);
                        this._serviceTestClassPage.createType((IProgressMonitor)subMonitor);
                    }
                }
                catch (CoreException e) {
                    throw new CoreException((IStatus)new Status(2, "org.switchyard.tools.ui", Messages.CreateBeanServiceOperation_exceptionMessage_errorWhileCreatingServiceTestClass, (Throwable)e));
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(8, "org.switchyard.tools.ui", e.getMessage(), (Throwable)e));
                }
            }
            finally {
                subMonitor.done();
                subMonitor.setTaskName("");
            }
        }
        finally {
            monitor.setTaskName("");
            monitor.done();
        }
    }

    @Override
    protected IProject getProject() {
        return this._serviceClassPage.getJavaProject().getProject();
    }
}

