/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.facets;

import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.switchyard.tools.ui.common.ILayoutUtilities;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.SwitchYardSettingsGroup;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardFacetInstallWizardPage
extends AbstractFacetWizardPage
implements IFacetWizardPage,
ISwitchYardFacetConstants,
ILayoutUtilities {
    private boolean _isInitialized;
    private SwitchYardSettingsGroup _settingsGroup;
    private IDataModel _config;

    public SwitchYardFacetInstallWizardPage() {
        super(Messages.SwitchYardFacetInstallWizardPage_pageName_switchYard);
        this.setTitle(Messages.SwitchYardFacetInstallWizardPage_pageTitle_switchYard);
        this.setDescription(Messages.SwitchYardFacetInstallWizardPage_pageDescription_switchYard);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this._settingsGroup = new SwitchYardSettingsGroup(content, this, (IRunnableContext)this.getWizard().getContainer());
        this._settingsGroup.getRuntimeVersionsList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    SwitchYardFacetInstallWizardPage.this._config.setProperty("SwitchYard.RUNTIME_VERSION", null);
                } else {
                    SwitchYardFacetInstallWizardPage.this._config.setProperty("SwitchYard.RUNTIME_VERSION", (Object)((ArtifactVersion)((IStructuredSelection)event.getSelection()).getFirstElement()));
                }
                SwitchYardFacetInstallWizardPage.this.validate();
            }
        });
        this._settingsGroup.getTargetRuntimesList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty() || ((IStructuredSelection)event.getSelection()).getFirstElement() == SwitchYardSettingsGroup.NULL_RUNTIME) {
                    SwitchYardFacetInstallWizardPage.this._config.setProperty("SwitchYard.RUNTIME_TARGET", null);
                } else {
                    SwitchYardFacetInstallWizardPage.this._config.setProperty("SwitchYard.RUNTIME_TARGET", ((IStructuredSelection)event.getSelection()).getFirstElement());
                }
                SwitchYardFacetInstallWizardPage.this.validate();
            }
        });
        this.setControl((Control)content);
    }

    public void transferStateToConfig() {
        super.transferStateToConfig();
        this._config.setProperty("SwitchYard.RUNTIME_COMPONENTS", this._settingsGroup.getSelectedComponents());
    }

    public void setConfig(Object config) {
        this._config = (IDataModel)config;
    }

    public void setVisible(boolean visible) {
        if (visible && !this._isInitialized) {
            this.initControls();
            this.setErrorMessage(null);
            this._isInitialized = true;
        }
        super.setVisible(visible);
    }

    private void initControls() {
        if (this._settingsGroup == null) {
            return;
        }
        if (this._config.isPropertySet("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            this._settingsGroup.setProject((IFacetedProjectWorkingCopy)this._config.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY"));
        }
        if (this._config.isPropertySet("SwitchYard.RUNTIME_TARGET")) {
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(this._config.getProperty("SwitchYard.RUNTIME_TARGET")), true);
            if (this._config.isPropertySet("SwitchYard.RUNTIME_VERSION")) {
                this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection(this._config.getProperty("SwitchYard.RUNTIME_VERSION")), true);
            }
        } else if (this._config.isPropertySet("SwitchYard.RUNTIME_VERSION")) {
            this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection(this._config.getProperty("SwitchYard.RUNTIME_VERSION")), true);
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.NULL_RUNTIME), true);
        } else if (this._settingsGroup.getSelectedTargetRuntime() != null) {
            this._config.setProperty("SwitchYard.RUNTIME_TARGET", (Object)this._settingsGroup.getSelectedTargetRuntime());
            this._config.setProperty("SwitchYard.RUNTIME_VERSION", ((IStructuredSelection)this._settingsGroup.getRuntimeVersionsList().getSelection()).getFirstElement());
        } else if (this._settingsGroup.getRuntimeVersionsList().getSelection().isEmpty()) {
            ArtifactVersion defaultVersion = (ArtifactVersion)this._config.getDefaultProperty("SwitchYard.RUNTIME_VERSION");
            if (defaultVersion != null) {
                this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection((Object)defaultVersion), true);
            }
        } else {
            this._config.setProperty("SwitchYard.RUNTIME_VERSION", ((IStructuredSelection)this._settingsGroup.getRuntimeVersionsList().getSelection()).getFirstElement());
        }
        if (this._config.isPropertySet("SwitchYard.RUNTIME_COMPONENTS")) {
            this._settingsGroup.setCheckedComponents((Set)this._config.getProperty("SwitchYard.RUNTIME_COMPONENTS"), true);
        } else {
            this._settingsGroup.setCheckedComponents((Set)this._config.getDefaultProperty("SwitchYard.RUNTIME_COMPONENTS"), true);
        }
        this._settingsGroup.setCheckedComponents(Collections.singleton(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension()), true);
    }

    private void validate() {
        IStatus status = this._config.validate();
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            default: {
                this.setErrorMessage(status.getMessage());
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

