/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IServiceNode;
import org.switchyard.tools.ui.explorer.IServicesNode;
import org.switchyard.tools.ui.explorer.impl.ServiceNode;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class ServicesNode
extends AbstractSwitchYardNode
implements IServicesNode {
    private List<IServiceNode> _services;

    public ServicesNode(SwitchYardRootNode root, SwitchYardModel configuration) {
        super(root);
        if (configuration == null) {
            this._services = Collections.emptyList();
            return;
        }
        CompositeModel composite = configuration.getComposite();
        if (composite == null) {
            this._services = Collections.emptyList();
            return;
        }
        List services = composite.getServices();
        this._services = new ArrayList<IServiceNode>(services.size());
        for (CompositeServiceModel service : services) {
            this._services.add(new ServiceNode(this, service));
        }
    }

    @Override
    public String getName() {
        return Messages.ServicesNode_labelServices;
    }

    @Override
    public List<IServiceNode> getServices() {
        return this._services;
    }

    public int hashCode() {
        return this.getRoot().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServicesNode) {
            return ((ServicesNode)obj).getRoot() == this.getRoot();
        }
        return false;
    }
}

