/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.List;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IServiceGateway;
import org.switchyard.tools.ui.explorer.IServiceNode;
import org.switchyard.tools.ui.explorer.IServicesNode;
import org.switchyard.tools.ui.explorer.impl.ServiceGateway;

public class ServiceNode
extends AbstractSwitchYardNode
implements IServiceNode {
    private CompositeServiceModel _service;
    private List<IServiceGateway> _gateways;

    public ServiceNode(IServicesNode parent, CompositeServiceModel service) {
        super(parent);
        this._service = service;
        List bindings = service.getBindings();
        this._gateways = new ArrayList<IServiceGateway>(bindings.size());
        for (BindingModel binding : bindings) {
            this._gateways.add(new ServiceGateway(this, binding));
        }
    }

    @Override
    public String getName() {
        return this._service.getName();
    }

    @Override
    public List<IServiceGateway> getGateways() {
        return this._gateways;
    }

    public CompositeServiceModel getModel() {
        return this._service;
    }

    public int hashCode() {
        return this._service.getQName() == null ? super.hashCode() : this._service.getQName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceNode) {
            ServiceNode other = (ServiceNode)obj;
            return other.getRoot().equals(this.getRoot()) && other._service.getQName() != null && this._service.getQName() != null && other._service.getQName().equals(this._service.getQName());
        }
        return false;
    }
}

