/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.m2e.core.ui.internal.editing.AddDependencyOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.editing.RemoveDependencyOperation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.impl.SwitchYardProject;
import org.switchyard.tools.ui.i18n.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SwitchYardProjectWorkingCopy
implements ISwitchYardProjectWorkingCopy {
    private final SwitchYardProject _switchYardProject;
    private MavenProject _mavenProject;
    private Map<String, ISwitchYardComponentExtension> _addedComponents = new LinkedHashMap<String, ISwitchYardComponentExtension>();
    private Map<String, ISwitchYardComponentExtension> _removedComponents = new LinkedHashMap<String, ISwitchYardComponentExtension>();
    private Set<ISwitchYardComponentExtension> _mergedComponents = new LinkedHashSet<ISwitchYardComponentExtension>();
    private volatile String _newVersion;

    public SwitchYardProjectWorkingCopy(SwitchYardProject switchYardProject) {
        this._switchYardProject = switchYardProject;
        this._mavenProject = this._switchYardProject.getMavenProject();
        this._mergedComponents.addAll(this._switchYardProject.getComponents());
    }

    @Override
    public IProject getProject() {
        return this._switchYardProject.getProject();
    }

    @Override
    public MavenProject getMavenProject() {
        return this._switchYardProject.getMavenProject();
    }

    @Override
    public String getVersion() {
        return this._newVersion == null ? this._switchYardProject.getVersion() : this._newVersion;
    }

    @Override
    public String getVersionPropertyKey() {
        return this._switchYardProject.getVersionPropertyKey();
    }

    @Override
    public Set<ISwitchYardComponentExtension> getComponents() {
        return this._mergedComponents;
    }

    @Override
    public boolean isUsingDependencyManagement() {
        return this._switchYardProject.isUsingDependencyManagement();
    }

    @Override
    public String getRawVersionString() {
        return this._switchYardProject.getRawVersionString();
    }

    @Override
    public IFile getSwitchYardConfigurationFile() {
        return this._switchYardProject.getSwitchYardConfigurationFile();
    }

    @Override
    public IFile getOutputSwitchYardConfigurationFile() {
        return this._switchYardProject.getOutputSwitchYardConfigurationFile();
    }

    @Override
    public SwitchYardModel loadSwitchYardModel(IProgressMonitor monitor) throws CoreException, IOException {
        return this._switchYardProject.loadSwitchYardModel(monitor);
    }

    @Override
    public boolean needsLoading() {
        return this._switchYardProject.needsLoading();
    }

    @Override
    public void load(IProgressMonitor monitor) {
        this._switchYardProject.load(monitor);
    }

    void reloaded() {
        this._switchYardProject.readLock();
        try {
            ISwitchYardComponentExtension component;
            this._mavenProject = this._switchYardProject.getMavenProject();
            this._mergedComponents.clear();
            this._mergedComponents.addAll(this._switchYardProject.getComponents());
            if (this._newVersion != null && this._newVersion.equals(this._switchYardProject.getVersion())) {
                this._newVersion = null;
            }
            Iterator<ISwitchYardComponentExtension> it = this._removedComponents.values().iterator();
            while (it.hasNext()) {
                component = it.next();
                if (this._mergedComponents.contains(component)) continue;
                it.remove();
            }
            it = this._addedComponents.values().iterator();
            while (it.hasNext()) {
                component = it.next();
                if (this._switchYardProject.getComponents().contains(component)) {
                    it.remove();
                }
                this._mergedComponents.add(component);
            }
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public ISwitchYardProjectWorkingCopy createWorkingCopy() {
        return this._switchYardProject.createWorkingCopy();
    }

    @Override
    public void setRuntimeVersion(String version) {
        if (version == null) {
            this._newVersion = null;
            return;
        }
        this._newVersion = version;
        if (this._newVersion.equals(this._switchYardProject.getVersion())) {
            this._newVersion = null;
        }
    }

    @Override
    public void addComponent(ISwitchYardComponentExtension component) {
        this._switchYardProject.readLock();
        try {
            this._removedComponents.remove(component.getId());
            this._mergedComponents.add(component);
            if (this._addedComponents.containsKey(component.getId()) || this._switchYardProject.getComponents().contains(component)) {
                return;
            }
            this._addedComponents.put(component.getId(), component);
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public void addComponents(Collection<ISwitchYardComponentExtension> components) {
        this._switchYardProject.readLock();
        try {
            for (ISwitchYardComponentExtension component : components) {
                this.addComponent(component);
            }
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public void removeComponent(ISwitchYardComponentExtension component) {
        this._switchYardProject.readLock();
        try {
            this._addedComponents.remove(component.getId());
            this._mergedComponents.remove(component);
            if (this._removedComponents.containsKey(component.getId()) || !this._switchYardProject.getComponents().contains(component)) {
                return;
            }
            this._removedComponents.put(component.getId(), component);
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public void removeComponents(Collection<ISwitchYardComponentExtension> components) {
        this._switchYardProject.readLock();
        try {
            for (ISwitchYardComponentExtension component : components) {
                this.removeComponent(component);
            }
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public boolean isModified() {
        this._switchYardProject.readLock();
        try {
            boolean bl = this._newVersion != null || !this._removedComponents.isEmpty() || !this._addedComponents.isEmpty();
            return bl;
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public void commit(IProgressMonitor monitor) throws CoreException {
        this._switchYardProject.readLock();
        try {
            if (!this.isModified()) {
                monitor.done();
                return;
            }
            monitor.beginTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_updatingProjectPOM, 300);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 4);
            List<Operation> updateOperations = this.processUpdates((IProgressMonitor)subMonitor);
            if (updateOperations.size() > 0) {
                subMonitor.done();
                subMonitor = new SubProgressMonitor(monitor, 100, 4);
                try {
                    this.updatePom(updateOperations);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Could not update pom.xml", (Throwable)e));
                }
                subMonitor.done();
            }
            subMonitor.done();
            List<Operation> updateFeatureOperations = this.processFeatureUpdates((IProgressMonitor)subMonitor);
            if (updateFeatureOperations.size() > 0) {
                subMonitor.done();
                subMonitor = new SubProgressMonitor(monitor, 100, 4);
                try {
                    this.updateFeatures(updateFeatureOperations);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Could not update features.xml", (Throwable)e));
                }
                subMonitor.done();
            }
            subMonitor.done();
            monitor.done();
        }
        finally {
            this._switchYardProject.readUnlock();
            this._switchYardProject.getSwitchYardFeaturesFile().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void revert() {
        this._switchYardProject.readLock();
        try {
            this._newVersion = null;
            this._addedComponents.clear();
            this._removedComponents.clear();
            this._mergedComponents.clear();
            this._mergedComponents.addAll(this._switchYardProject.getComponents());
        }
        finally {
            this._switchYardProject.readUnlock();
        }
    }

    @Override
    public void dispose() {
        this._switchYardProject.disposed(this);
    }

    private List<Operation> processFeatureUpdates(IProgressMonitor monitor) throws CoreException {
        Operation featuresOp;
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (this._switchYardProject.getSwitchYardFeaturesFile() == null || this._switchYardProject.getSwitchYardConfigurationFile() != null && !this._switchYardProject.getSwitchYardFeaturesFile().exists()) {
            return operations;
        }
        monitor.beginTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_processingSYSettingsChanges, 50);
        if (this._mavenProject != this._switchYardProject.getMavenProject()) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardProjectWorkingCopy_errorMessage_workingCopyOutOfSync));
        }
        monitor.subTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_validatingVersionProperty);
        String switchYardVersionPropertyKey = this.getVersionPropertyKey();
        String currentSwitchYardVersion = this._switchYardProject.getVersion();
        if (switchYardVersionPropertyKey != null) {
            if (this._newVersion != null) {
                operations.add(new UpdatePropertyOperation(switchYardVersionPropertyKey, this._newVersion));
            } else if (currentSwitchYardVersion == null) {
                operations.add(new UpdatePropertyOperation(switchYardVersionPropertyKey, ""));
            }
        }
        monitor.worked(33);
        monitor.subTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_validatingComponentDependencies);
        if (this._removedComponents.size() > 0) {
            ArrayList<ISwitchYardComponentExtension> removedComponentList = new ArrayList<ISwitchYardComponentExtension>();
            for (ISwitchYardComponentExtension component : this._removedComponents.values()) {
                removedComponentList.add(component);
            }
            if (removedComponentList.size() > 0) {
                featuresOp = new RemoveFeaturesOperation(removedComponentList);
                operations.add(featuresOp);
            }
        }
        monitor.worked(33);
        this.addComponent(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension());
        if (this._addedComponents.size() > 0) {
            ArrayList<ISwitchYardComponentExtension> addedComponentList = new ArrayList<ISwitchYardComponentExtension>();
            for (ISwitchYardComponentExtension component : this._addedComponents.values()) {
                addedComponentList.add(component);
            }
            if (addedComponentList.size() > 0) {
                featuresOp = new AddFeaturesOperation(addedComponentList);
                operations.add(featuresOp);
            }
        }
        monitor.worked(33);
        monitor.done();
        return operations;
    }

    private List<Operation> processUpdates(IProgressMonitor monitor) throws CoreException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        monitor.beginTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_processingSYSettingsChanges, 50);
        if (this._mavenProject != this._switchYardProject.getMavenProject()) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardProjectWorkingCopy_errorMessage_workingCopyOutOfSync));
        }
        Model model = this._switchYardProject.getMavenProject().getOriginalModel();
        monitor.subTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_validatingVersionProperty);
        String switchYardVersionPropertyKey = this.getVersionPropertyKey();
        String currentSwitchYardVersion = this._switchYardProject.getVersion();
        if (switchYardVersionPropertyKey != null) {
            if (this._newVersion != null) {
                operations.add(new UpdatePropertyOperation(switchYardVersionPropertyKey, this._newVersion));
            } else if (currentSwitchYardVersion == null) {
                operations.add(new UpdatePropertyOperation(switchYardVersionPropertyKey, ""));
            }
        }
        monitor.worked(10);
        monitor.subTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_validatingComponentDependencies);
        if (this._removedComponents.size() > 0) {
            ArrayList<Dependency> removedDependencies = new ArrayList<Dependency>();
            for (ISwitchYardComponentExtension component : this._removedComponents.values()) {
                block1: for (Dependency dependency : component.getDependencies()) {
                    for (Dependency existingDependency : model.getDependencies()) {
                        if (!existingDependency.getManagementKey().equals(dependency.getManagementKey())) continue;
                        removedDependencies.add(existingDependency);
                        continue block1;
                    }
                }
            }
            if (removedDependencies.size() > 0) {
                operations.add(new RemoveDependenciesOperation(removedDependencies));
            }
        }
        monitor.worked(10);
        this.addComponent(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension());
        if (this._addedComponents.size() > 0) {
            String versionString = this.getRawVersionString();
            ArrayList<Dependency> addedDependencies = new ArrayList<Dependency>();
            ArrayList<ISwitchYardComponentExtension> addedComponentList = new ArrayList<ISwitchYardComponentExtension>();
            for (ISwitchYardComponentExtension component : this._addedComponents.values()) {
                addedComponentList.add(component);
                block4: for (Dependency dependency : component.getDependencies()) {
                    Iterator it = model.getDependencies().iterator();
                    while (it.hasNext()) {
                        if (((Dependency)it.next()).getManagementKey().equals(dependency.getManagementKey())) continue block4;
                    }
                    dependency = dependency.clone();
                    dependency.setVersion(versionString);
                    addedDependencies.add(dependency);
                }
            }
            if (addedDependencies.size() > 0) {
                operations.add(new AddDependenciesOperation(addedDependencies));
            }
        }
        monitor.worked(10);
        monitor.subTask(Messages.SwitchYardProjectWorkingCopy_taskMessage_validatingSYPlugin);
        Set<String> existingScanners = this._switchYardProject.getPlugin().getScannerClasses();
        Set<String> addedScanners = this.collectScanners(this._addedComponents.values());
        Set<String> removedScanners = this.collectScanners(this._removedComponents.values());
        removedScanners.removeAll(addedScanners);
        addedScanners.removeAll(existingScanners);
        removedScanners.retainAll(existingScanners);
        if (addedScanners.size() > 0 || removedScanners.size() > 0) {
            operations.add(new UpdateScannersOperation(addedScanners, removedScanners));
        }
        monitor.worked(10);
        monitor.done();
        return operations;
    }

    private Set<String> collectScanners(Collection<ISwitchYardComponentExtension> components) {
        LinkedHashSet<String> scanners = new LinkedHashSet<String>();
        for (ISwitchYardComponentExtension component : components) {
            String scanner = component.getScannerClassName();
            if (scanner == null || scanner.length() <= 0) continue;
            scanners.add(scanner);
        }
        return scanners;
    }

    private void updatePom(List<Operation> operations) throws IOException, CoreException {
        IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this._switchYardProject.getMavenProjectFacade().getPom());
        if (domModel == null) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Could not update pom.xml."));
        }
        try {
            DocumentRewriteSession session = null;
            IStructuredTextUndoManager undo = null;
            domModel.aboutToChangeModel();
            undo = domModel.getStructuredDocument().getUndoManager();
            if (domModel.getStructuredDocument() instanceof IDocumentExtension4) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)domModel.getStructuredDocument();
                session = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
            }
            undo.beginRecording((Object)domModel);
            try {
                for (Operation operation : operations) {
                    try {
                        operation.process(domModel.getDocument());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                undo.endRecording((Object)domModel);
                if (session != null && domModel.getStructuredDocument() instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext4 = (IDocumentExtension4)domModel.getStructuredDocument();
                    ext4.stopRewriteSession(session);
                }
                domModel.changedModel();
            }
        }
        finally {
            try {
                domModel.save();
            }
            finally {
                domModel.releaseFromEdit();
            }
        }
    }

    private void updateFeatures(List<Operation> operations) throws IOException, CoreException {
        IDOMModel domFeatureModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this._switchYardProject.getSwitchYardFeaturesFile());
        if (domFeatureModel == null) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Could not update features.xml."));
        }
        try {
            DocumentRewriteSession session = null;
            IStructuredTextUndoManager undo = null;
            domFeatureModel.aboutToChangeModel();
            undo = domFeatureModel.getStructuredDocument().getUndoManager();
            if (domFeatureModel.getStructuredDocument() instanceof IDocumentExtension4) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)domFeatureModel.getStructuredDocument();
                session = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
            }
            undo.beginRecording((Object)domFeatureModel);
            try {
                for (Operation operation : operations) {
                    try {
                        operation.process(domFeatureModel.getDocument());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                undo.endRecording((Object)domFeatureModel);
                if (session != null && domFeatureModel.getStructuredDocument() instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext4 = (IDocumentExtension4)domFeatureModel.getStructuredDocument();
                    ext4.stopRewriteSession(session);
                }
                domFeatureModel.changedModel();
            }
        }
        finally {
            try {
                domFeatureModel.save();
            }
            finally {
                domFeatureModel.releaseFromEdit();
            }
        }
    }

    @Override
    public IFile getSwitchYardFeaturesFile() {
        return this._switchYardProject.getSwitchYardFeaturesFile();
    }

    private final class AddDependenciesOperation
    implements Operation {
        private final List<Dependency> _addedDependencies;

        private AddDependenciesOperation(List<Dependency> addedDependencies) {
            this._addedDependencies = addedDependencies;
        }

        @Override
        public void process(IDOMDocument document) {
            for (Dependency dependency : this._addedDependencies) {
                try {
                    new AddDependencyOperation(dependency).process((Document)document);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class AddFeaturesOperation
    implements Operation {
        private final List<ISwitchYardComponentExtension> _addedComponentsList;

        private AddFeaturesOperation(List<ISwitchYardComponentExtension> addedDependencies) {
            this._addedComponentsList = addedDependencies;
        }

        @Override
        public void process(IDOMDocument document) {
            Node firstFeature;
            NodeList featureNodes = document.getElementsByTagName("feature");
            if (featureNodes != null && featureNodes.getLength() > 0 && (firstFeature = featureNodes.item(0)) instanceof Element) {
                Element firstFeatureElement = (Element)firstFeature;
                NodeList childFeatures = firstFeatureElement.getElementsByTagName("feature");
                for (ISwitchYardComponentExtension component : this._addedComponentsList) {
                    try {
                        boolean foundIt = false;
                        String addIt = null;
                        String featureId = component.getBundleId();
                        int i = 0;
                        while (i < childFeatures.getLength()) {
                            Node feature = childFeatures.item(i);
                            if (feature instanceof Element) {
                                String featureIdText;
                                Node value = null;
                                if (feature.getFirstChild() instanceof Text) {
                                    value = (Text)feature.getFirstChild();
                                }
                                if ((featureIdText = value.getTextContent()).equalsIgnoreCase(featureId)) {
                                    foundIt = true;
                                } else {
                                    addIt = featureId;
                                }
                            }
                            ++i;
                        }
                        if (foundIt || addIt == null) continue;
                        Element newFeature = document.createElement("feature");
                        newFeature.setAttribute("version", "${switchyard.version}");
                        newFeature.appendChild(document.createTextNode(addIt));
                        firstFeatureElement.appendChild(newFeature);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static interface Operation {
        public void process(IDOMDocument var1);
    }

    private final class RemoveDependenciesOperation
    implements Operation {
        private final List<Dependency> _removedDependencies;

        private RemoveDependenciesOperation(List<Dependency> removedDependencies) {
            this._removedDependencies = removedDependencies;
        }

        @Override
        public void process(IDOMDocument document) {
            for (Dependency dependency : this._removedDependencies) {
                try {
                    new RemoveDependencyOperation(dependency).process((Document)document);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class RemoveFeaturesOperation
    implements Operation {
        private final List<ISwitchYardComponentExtension> _removedComponentsList;

        private RemoveFeaturesOperation(List<ISwitchYardComponentExtension> removedDependencies) {
            this._removedComponentsList = removedDependencies;
        }

        @Override
        public void process(IDOMDocument document) {
            Node firstFeature;
            NodeList featureNodes = document.getElementsByTagName("feature");
            if (featureNodes != null && featureNodes.getLength() > 0 && (firstFeature = featureNodes.item(0)) instanceof Element) {
                Element firstFeatureElement = (Element)firstFeature;
                NodeList childFeatures = firstFeatureElement.getElementsByTagName("feature");
                for (ISwitchYardComponentExtension component : this._removedComponentsList) {
                    try {
                        boolean foundIt = false;
                        String featureId = component.getBundleId();
                        Node removeIt = null;
                        int i = 0;
                        while (i < childFeatures.getLength()) {
                            Node feature = childFeatures.item(i);
                            if (feature instanceof Element) {
                                String featureIdText;
                                Node value = null;
                                if (feature.getFirstChild() instanceof Text) {
                                    value = (Text)feature.getFirstChild();
                                }
                                if ((featureIdText = value.getTextContent()).equalsIgnoreCase(featureId)) {
                                    foundIt = true;
                                    removeIt = feature;
                                }
                            }
                            ++i;
                        }
                        if (!foundIt || removeIt == null) continue;
                        firstFeatureElement.removeChild(removeIt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private final class UpdatePropertyOperation
    implements Operation {
        private final String _key;
        private final String _value;

        private UpdatePropertyOperation(String key, String value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public void process(IDOMDocument document) {
            Element property = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"properties", this._key});
            PomEdits.setText((Element)property, (String)this._value);
        }
    }

    private final class UpdateScannersOperation
    implements Operation {
        private final Set<String> _addedScanners;
        private final Set<String> _removedScanners;

        private UpdateScannersOperation(Set<String> addedScanners, Set<String> removedScanners) {
            this._addedScanners = addedScanners;
            this._removedScanners = removedScanners;
        }

        @Override
        public void process(IDOMDocument document) {
            Element configElement;
            Element switchYardPlugin = PomEdits.findChild((Element)PomEdits.findChild((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"build"), (String)"plugins"), (String)"plugin", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)"org.switchyard"), PomEdits.childEquals((String)"artifactId", (String)"switchyard-plugin")});
            if (switchYardPlugin == null) {
                if (this._addedScanners.size() == 0 || SwitchYardProjectWorkingCopy.this._switchYardProject.getPlugin().getPlugin() != null) {
                    return;
                }
                Element pluginsElement = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"build", "plugins"});
                switchYardPlugin = PomHelper.createPlugin((Element)pluginsElement, (String)"org.switchyard", (String)"switchyard-plugin", (String)SwitchYardProjectWorkingCopy.this.getRawVersionString());
                Element goalElement = PomEdits.getChild((Element)switchYardPlugin, (String[])new String[]{"executions", "execution", "goals", "goal"});
                PomEdits.setText((Element)goalElement, (String)"configure");
                PomEdits.getChild((Element)switchYardPlugin, (String[])new String[]{"configuration"});
            }
            if ((configElement = PomEdits.findChild((Element)switchYardPlugin, (String)"configuration")) == null) {
                boolean addConfig;
                List executionElements = PomEdits.findChilds((Element)PomEdits.findChild((Element)switchYardPlugin, (String)"executions"), (String)"execution");
                boolean bl = addConfig = this._addedScanners.size() > 0;
                if (executionElements.size() > 0) {
                    for (Element executionElement : executionElements) {
                        Element executionConfigElement;
                        if (PomEdits.findChild((Element)PomEdits.findChild((Element)executionElement, (String)"goals"), (String)"goal", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)"configure")}) == null || (executionConfigElement = PomEdits.findChild((Element)executionElement, (String)"configuration")) == null) continue;
                        this.updateScanners(executionConfigElement);
                        addConfig = false;
                        break;
                    }
                }
                if (addConfig) {
                    configElement = PomEdits.createElement((Element)switchYardPlugin, (String)"configuration");
                    this.updateScanners(configElement);
                }
            } else {
                this.updateScanners(configElement);
            }
        }

        private void updateScanners(Element configElement) {
            Element scannersElement = PomEdits.findChild((Element)configElement, (String)"scannerClassNames");
            if (scannersElement == null) {
                if (this._addedScanners.size() == 0) {
                    return;
                }
                scannersElement = PomEdits.getChild((Element)configElement, (String[])new String[]{"scannerClassNames"});
            }
            for (String scanner : this._removedScanners) {
                PomEdits.removeChild((Element)scannersElement, (Element)PomEdits.findChild((Element)scannersElement, (String)"param", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)scanner)}));
            }
            for (String scanner : this._addedScanners) {
                Element paramElement = PomEdits.findChild((Element)scannersElement, (String)"param", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)scanner)});
                if (paramElement != null) continue;
                paramElement = PomEdits.createElementWithText((Element)scannersElement, (String)"param", (String)scanner);
                PomEdits.format((Node)paramElement);
            }
            PomEdits.removeIfNoChildElement((Element)scannersElement);
        }
    }
}

