/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.SwitchYardNamespace;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardProject
implements ISwitchYardProject,
IMavenProjectChangedListener {
    private final IProject _project;
    private volatile IMavenProjectFacade _mavenProjectFacade;
    private volatile String _version;
    private volatile String _versionPropertyKey;
    private volatile String _rawVersionString;
    private volatile boolean _usingDependencyManagement;
    private volatile Set<ISwitchYardComponentExtension> _components;
    private volatile SwitchYardConfigurePlugin _plugin;
    private volatile IFile _switchYardConfigurationFile;
    private Set<SwitchYardProjectWorkingCopy> _workingCopies = new HashSet<SwitchYardProjectWorkingCopy>();
    private long _lastOutputTimestamp;
    private final SwitchYardProjectManager _manager;
    private ReadWriteLock _loadLock = new ReentrantReadWriteLock();
    private volatile IFile _featuresFile;

    SwitchYardProject(SwitchYardProjectManager manager, IProject project) {
        this._manager = manager;
        this._project = project;
        this._mavenProjectFacade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        this.init();
        MavenPlugin.getMavenProjectRegistry().addMavenProjectChangedListener((IMavenProjectChangedListener)this);
    }

    @Override
    public IProject getProject() {
        return this._project;
    }

    @Override
    public MavenProject getMavenProject() {
        this.readLock();
        try {
            MavenProject mavenProject = this._mavenProjectFacade == null ? null : this._mavenProjectFacade.getMavenProject();
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public String getVersionPropertyKey() {
        return this._versionPropertyKey;
    }

    @Override
    public Set<ISwitchYardComponentExtension> getComponents() {
        return Collections.unmodifiableSet(this._components);
    }

    @Override
    public boolean isUsingDependencyManagement() {
        return this._usingDependencyManagement;
    }

    @Override
    public String getRawVersionString() {
        return this._rawVersionString;
    }

    @Override
    public IFile getSwitchYardConfigurationFile() {
        return this._switchYardConfigurationFile;
    }

    @Override
    public IFile getOutputSwitchYardConfigurationFile() {
        return this._plugin._outputFile;
    }

    @Override
    public SwitchYardModel loadSwitchYardModel(IProgressMonitor monitor) throws CoreException, IOException {
        block8: {
            if (this.needsLoading()) {
                this.load(monitor);
            }
            if (this._switchYardConfigurationFile.exists()) {
                SwitchYardModel switchYardModel;
                InputStream is = this._switchYardConfigurationFile.getContents(true);
                try {
                    switchYardModel = (SwitchYardModel)new ModelPuller().pull(is);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                        break block8;
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardProject_errorMessage_exceptionWhileLodingSYFile, (Throwable)e));
                    }
                }
                is.close();
                return switchYardModel;
            }
        }
        return (SwitchYardModel)new ModelPuller().pull(new QName(this.getSwitchYardNamespaceUri(), "switchyard"));
    }

    public String getSwitchYardNamespaceUri() {
        if (this._project != null) {
            try {
                IProjectFacetVersion facetVersion;
                IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project);
                IProjectFacetVersion iProjectFacetVersion = facetVersion = ifp == null ? null : ifp.getInstalledVersion(ISwitchYardFacetConstants.SWITCHYARD_FACET);
                if (facetVersion != null) {
                    if ("1.0".equals(facetVersion.getVersionString())) {
                        return SwitchYardNamespace.V_1_0.uri();
                    }
                    if ("1.1".equals(facetVersion.getVersionString())) {
                        return SwitchYardNamespace.V_1_1.uri();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return SwitchYardNamespace.DEFAULT.uri();
    }

    @Override
    public boolean needsLoading() {
        this.readLock();
        try {
            boolean bl = this.getMavenProject() == null || this._switchYardConfigurationFile == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(IProgressMonitor monitor) {
        boolean releaseRule = Job.getJobManager().currentRule() == null;
        try {
            if (releaseRule) {
                Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
            }
            this._loadLock.writeLock().lock();
            try {
                Set<SwitchYardProjectManager.ISwitchYardProjectListener.Type> types;
                block25: {
                    IFile oldOutputFile;
                    if (!this.needsLoading()) {
                        if (this.getOutputSwitchYardConfigurationFile() == null) {
                            return;
                        }
                        this._lastOutputTimestamp = this.getOutputSwitchYardConfigurationFile().getModificationStamp();
                        return;
                    }
                    monitor.beginTask(Messages.SwitchYardProject_taskMessage_loadingMavenConfig, 100);
                    monitor.worked(10);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 75);
                    try {
                        oldOutputFile = this.getOutputSwitchYardConfigurationFile();
                        if (this._mavenProjectFacade == null) {
                            this._mavenProjectFacade = MavenPlugin.getMavenProjectRegistry().getProject(this._project);
                            if (this._mavenProjectFacade == null) {
                                MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(this._project, MavenPlugin.getMavenConfiguration().isOffline(), false), (IProgressMonitor)subMonitor);
                                return;
                            }
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                        types = Collections.emptySet();
                        break block25;
                    }
                    {
                        long outputTimestamp;
                        if (this._mavenProjectFacade.getMavenProject() == null) {
                            this._mavenProjectFacade.getMavenProject((IProgressMonitor)subMonitor);
                        }
                        subMonitor.done();
                        this.init();
                        IFile newOutputFile = this.getOutputSwitchYardConfigurationFile();
                        long l = outputTimestamp = newOutputFile == null ? 0L : newOutputFile.getModificationStamp();
                        if (outputTimestamp > this._lastOutputTimestamp || oldOutputFile == null && newOutputFile != null || oldOutputFile != null && !oldOutputFile.equals((Object)newOutputFile)) {
                            types = EnumSet.of(SwitchYardProjectManager.ISwitchYardProjectListener.Type.POM, SwitchYardProjectManager.ISwitchYardProjectListener.Type.CONFIG);
                            this._lastOutputTimestamp = outputTimestamp;
                            break block25;
                        }
                        types = EnumSet.of(SwitchYardProjectManager.ISwitchYardProjectListener.Type.POM);
                    }
                }
                Iterator<SwitchYardProjectWorkingCopy> iterator = this._workingCopies.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this._manager.notify(this, types);
                        monitor.done();
                        return;
                    }
                    SwitchYardProjectWorkingCopy workingCopy = iterator.next();
                    workingCopy.reloaded();
                }
            }
            finally {
                this._loadLock.writeLock().unlock();
            }
        }
        finally {
            if (releaseRule) {
                Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
        }
    }

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        if (events == null) {
            return;
        }
        MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
            if (this._project.equals((Object)event.getSource().getProject())) {
                if (event.getMavenProject() != null && event.getMavenProject().getMavenProject() != null && this._loadLock.writeLock().tryLock()) {
                    try {
                        this._mavenProjectFacade = null;
                        this.load((IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        this._loadLock.writeLock().unlock();
                    }
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public ISwitchYardProjectWorkingCopy createWorkingCopy() {
        this.readLock();
        try {
            SwitchYardProjectWorkingCopy workingCopy = new SwitchYardProjectWorkingCopy(this);
            this._workingCopies.add(workingCopy);
            SwitchYardProjectWorkingCopy switchYardProjectWorkingCopy = workingCopy;
            return switchYardProjectWorkingCopy;
        }
        finally {
            this.readUnlock();
        }
    }

    protected SwitchYardConfigurePlugin getPlugin() {
        return this._plugin;
    }

    protected IMavenProjectFacade getMavenProjectFacade() {
        return this._mavenProjectFacade;
    }

    void dispose() {
        MavenPlugin.getMavenProjectRegistry().removeMavenProjectChangedListener((IMavenProjectChangedListener)this);
        this._loadLock.writeLock().lock();
        try {
            this._mavenProjectFacade = null;
        }
        finally {
            this._loadLock.writeLock().unlock();
        }
    }

    void disposed(SwitchYardProjectWorkingCopy workingCopy) {
        this.readLock();
        try {
            this._workingCopies.remove(workingCopy);
        }
        finally {
            this.readUnlock();
        }
    }

    void readLock() {
        this._loadLock.readLock().lock();
    }

    void readUnlock() {
        this._loadLock.readLock().unlock();
    }

    private void init() {
        IFile temp;
        IPath resourceLocation;
        this._version = null;
        this._versionPropertyKey = "switchyard.version";
        this._components = Collections.emptySet();
        this._rawVersionString = null;
        this._usingDependencyManagement = false;
        this._plugin = new SwitchYardConfigurePlugin();
        this._switchYardConfigurationFile = null;
        MavenProject mavenProject = this.getMavenProject();
        if (mavenProject == null) {
            return;
        }
        this._version = this.readSwitchYardVersion(mavenProject);
        this._versionPropertyKey = this.readSwitchYardVersionPropertyKey(mavenProject);
        this._rawVersionString = this.readRawVersionString(mavenProject);
        if (this._rawVersionString == null) {
            this._usingDependencyManagement = true;
        } else if (this._rawVersionString == M2EUtils.UNKNOWN_VERSION_STRING) {
            if (this._version == null) {
                this._usingDependencyManagement = false;
                this._rawVersionString = "${" + this._versionPropertyKey + "}";
            } else {
                this._usingDependencyManagement = true;
                this._rawVersionString = null;
            }
        }
        this._components = this.readComponents(mavenProject);
        IPath[] iPathArray = MavenProjectUtils.getResourceLocations((IProject)this._project, (List)mavenProject.getResources());
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            resourceLocation = iPathArray[n2];
            temp = this._project.getFolder(resourceLocation).getFile("META-INF/switchyard.xml");
            if (this._switchYardConfigurationFile == null) {
                this._switchYardConfigurationFile = temp;
            }
            if (temp.exists()) {
                this._switchYardConfigurationFile = temp;
                break;
            }
            ++n2;
        }
        iPathArray = MavenProjectUtils.getResourceLocations((IProject)this._project, (List)mavenProject.getResources());
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            resourceLocation = iPathArray[n2];
            temp = this._project.getFolder(resourceLocation).getFile("features.xml");
            if (this._featuresFile == null) {
                this._featuresFile = temp;
            }
            if (temp.exists()) {
                this._featuresFile = temp;
                break;
            }
            ++n2;
        }
    }

    private String readSwitchYardVersion(MavenProject mavenProject) {
        for (Dependency dependency : mavenProject.getDependencies()) {
            if (!"org.switchyard".equals(dependency.getGroupId()) || dependency.getVersion() == null) continue;
            return dependency.getVersion();
        }
        Plugin switchYardPlugin = this.getSwitchYardPlugin();
        if (switchYardPlugin == null) {
            return null;
        }
        return switchYardPlugin.getVersion();
    }

    private Plugin getSwitchYardPlugin() {
        if (this.getMavenProject() == null) {
            return null;
        }
        return this.getMavenProject().getPlugin(M2EUtils.SWITCHYARD_PLUGIN_KEY);
    }

    private String readRawVersionString(MavenProject mavenProject) {
        Plugin switchYardPlugin;
        if (mavenProject.getDependencyManagement() != null) {
            for (Dependency dependency : mavenProject.getDependencyManagement().getDependencies()) {
                if (!"org.switchyard".equals(dependency.getGroupId())) continue;
                return null;
            }
        }
        for (Dependency dependency : mavenProject.getOriginalModel().getDependencies()) {
            if (!"org.switchyard".equals(dependency.getGroupId())) continue;
            return dependency.getVersion();
        }
        Build build = mavenProject.getOriginalModel().getBuild();
        if (build != null && (switchYardPlugin = (Plugin)build.getPluginsAsMap().get(M2EUtils.SWITCHYARD_PLUGIN_KEY)) != null) {
            return switchYardPlugin.getVersion();
        }
        return M2EUtils.UNKNOWN_VERSION_STRING;
    }

    private Set<ISwitchYardComponentExtension> readComponents(MavenProject mavenProject) {
        Collection<ISwitchYardComponentExtension> extensions = SwitchYardComponentExtensionManager.instance().getComponentExtensions();
        LinkedHashSet<ISwitchYardComponentExtension> retVal = new LinkedHashSet<ISwitchYardComponentExtension>(extensions.size());
        Set<String> dependencyKeys = this.createDependencyKeySet(mavenProject.getDependencies());
        Set<String> pluginScanners = this._plugin.getScannerClasses();
        block0: for (ISwitchYardComponentExtension extension : extensions) {
            if (extension.getScannerClassName() != null && !pluginScanners.contains(extension.getScannerClassName())) continue;
            for (Dependency dependency : extension.getDependencies()) {
                if (!dependencyKeys.contains(dependency.getManagementKey())) continue block0;
            }
            retVal.add(extension);
        }
        return retVal;
    }

    private String readSwitchYardVersionPropertyKey(MavenProject mavenProject) {
        Plugin switchYardPlugin;
        String dependencyVersion;
        boolean foundComponent = false;
        for (Dependency dependency : mavenProject.getOriginalModel().getDependencies()) {
            if (!"org.switchyard".equals(dependency.getGroupId())) continue;
            dependencyVersion = dependency.getVersion();
            if (dependencyVersion == null || !dependencyVersion.startsWith("${") || dependencyVersion.length() < 4) {
                foundComponent = true;
                continue;
            }
            return dependencyVersion.substring(2, dependencyVersion.length() - 1);
        }
        if (mavenProject.getOriginalModel().getDependencyManagement() != null) {
            for (Dependency dependency : mavenProject.getOriginalModel().getDependencyManagement().getDependencies()) {
                if (!"org.switchyard".equals(dependency.getGroupId())) continue;
                dependencyVersion = dependency.getVersion();
                if (dependencyVersion == null || !dependencyVersion.startsWith("${") || dependencyVersion.length() < 4) {
                    foundComponent = true;
                    continue;
                }
                return dependencyVersion.substring(2, dependencyVersion.length() - 1);
            }
        }
        if ((switchYardPlugin = this.getPlugin().getOriginalPlugin()) == null) {
            return foundComponent ? null : "switchyard.version";
        }
        String pluginVersion = switchYardPlugin.getVersion();
        if (pluginVersion == null || !pluginVersion.startsWith("${") || pluginVersion.length() < 4) {
            return null;
        }
        return pluginVersion.substring(2, pluginVersion.length() - 1);
    }

    private Set<String> createDependencyKeySet(Collection<Dependency> dependencies) {
        HashSet<String> dependencyKeySet = new HashSet<String>();
        for (Dependency dependency : dependencies) {
            dependencyKeySet.add(dependency.getManagementKey());
        }
        return dependencyKeySet;
    }

    @Override
    public IFile getSwitchYardFeaturesFile() {
        return this._featuresFile;
    }

    protected final class SwitchYardConfigurePlugin {
        private Plugin _switchYardPlugin;
        private Set<String> _scannerClasses;
        private IFile _outputFile;

        private SwitchYardConfigurePlugin() {
            this._switchYardPlugin = SwitchYardProject.this.getSwitchYardPlugin();
            if (this._switchYardPlugin == null) {
                this._scannerClasses = Collections.emptySet();
                this.setDefaultOutputFile();
                return;
            }
            this._scannerClasses = new HashSet<String>();
            Object configuration = this._switchYardPlugin.getConfiguration();
            if (configuration instanceof Xpp3Dom) {
                this._scannerClasses.addAll(this.parseScanners((Xpp3Dom)configuration));
                this.parseOutputFile((Xpp3Dom)configuration);
            }
            for (PluginExecution execution : this._switchYardPlugin.getExecutions()) {
                if (!execution.getGoals().contains("configure") || !((configuration = execution.getConfiguration()) instanceof Xpp3Dom)) continue;
                this._scannerClasses.addAll(this.parseScanners((Xpp3Dom)configuration));
                if (this._outputFile != null) continue;
                this.parseOutputFile((Xpp3Dom)configuration);
            }
            if (this._outputFile == null) {
                this.setDefaultOutputFile();
            }
        }

        public Set<String> getScannerClasses() {
            return this._scannerClasses;
        }

        public Plugin getPlugin() {
            return this._switchYardPlugin;
        }

        public Plugin getOriginalPlugin() {
            MavenProject mavenProject = SwitchYardProject.this.getMavenProject();
            if (mavenProject == null) {
                return null;
            }
            Model originalModel = mavenProject.getOriginalModel();
            if (originalModel == null) {
                return null;
            }
            Build build = originalModel.getBuild();
            if (build == null) {
                return null;
            }
            return (Plugin)build.getPluginsAsMap().get(M2EUtils.SWITCHYARD_PLUGIN_KEY);
        }

        public boolean updateScannerClasses(Set<String> added, Set<String> removed) {
            added.removeAll(this._scannerClasses);
            removed.retainAll(this._scannerClasses);
            if (added.isEmpty() && removed.isEmpty()) {
                return false;
            }
            Plugin plugin = this.getOriginalPlugin();
            if (plugin == null) {
                if (added.isEmpty()) {
                    return false;
                }
                boolean createExecution = true;
                if (this._switchYardPlugin != null) {
                    for (PluginExecution execution : this._switchYardPlugin.getExecutions()) {
                        if (!execution.getGoals().contains("configure")) continue;
                        createExecution = false;
                        break;
                    }
                }
                this.installSwitchYardPlugin(createExecution, added);
            } else {
                Xpp3Dom scannerElement;
                Xpp3Dom[] children;
                Xpp3Dom[] children2;
                Xpp3Dom configuration = null;
                Object pluginConfiguration = plugin.getConfiguration();
                if (pluginConfiguration instanceof Xpp3Dom && (children2 = (configuration = (Xpp3Dom)pluginConfiguration).getChildren("scannerClassNames")) != null && children2.length > 0) {
                    this.removeScanners(children2[0], removed);
                    this.addScanners(children2[0], added);
                    return true;
                }
                for (PluginExecution execution : plugin.getExecutions()) {
                    Xpp3Dom[] children3;
                    Object test;
                    if (!execution.getGoals().contains("configure") || !((test = execution.getConfiguration()) instanceof Xpp3Dom) || (children3 = ((Xpp3Dom)test).getChildren("scannerClassNames")) == null || children3.length <= 0) continue;
                    this.removeScanners(children3[0], removed);
                    this.addScanners(children3[0], added);
                    return true;
                }
                if (configuration == null) {
                    configuration = new Xpp3Dom("configuration");
                    plugin.setConfiguration((Object)configuration);
                }
                if ((children = configuration.getChildren("scannerClassNames")) == null || children.length == 0) {
                    scannerElement = new Xpp3Dom("scannerClassNames");
                    configuration.addChild(scannerElement);
                } else {
                    scannerElement = children[0];
                }
                this.addScanners(scannerElement, added);
            }
            return true;
        }

        private void removeScanners(Xpp3Dom scannerElement, Set<String> removed) {
            int index = 0;
            while (index < scannerElement.getChildCount()) {
                Xpp3Dom child = scannerElement.getChild(index);
                if ("param".equals(child.getName()) && removed.contains(child.getValue())) {
                    scannerElement.removeChild(index);
                    --index;
                }
                ++index;
            }
        }

        private void addScanners(Xpp3Dom scannerElement, Set<String> added) {
            for (String scanner : added) {
                Xpp3Dom paramElement = new Xpp3Dom("param");
                paramElement.setValue(scanner);
                scannerElement.addChild(paramElement);
            }
        }

        private Set<String> parseScanners(Xpp3Dom configuration) {
            Xpp3Dom scannerClassNames = configuration.getChild("scannerClassNames");
            if (scannerClassNames == null) {
                return Collections.emptySet();
            }
            HashSet<String> scannerClasses = new HashSet<String>();
            Xpp3Dom[] xpp3DomArray = scannerClassNames.getChildren("param");
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom param = xpp3DomArray[n2];
                this._scannerClasses.add(param.getValue());
                ++n2;
            }
            return scannerClasses;
        }

        private void parseOutputFile(Xpp3Dom configuration) {
            String outputFile;
            Xpp3Dom outputFileElement = configuration.getChild("outputFile");
            if (outputFileElement != null && (outputFile = outputFileElement.getValue()) != null && outputFile.length() > 0) {
                this._outputFile = SwitchYardProject.this._project.getFile((IPath)new Path(outputFile));
                return;
            }
            Xpp3Dom outputDirectoryElement = configuration.getChild("outputDirectory");
            if (outputDirectoryElement != null && outputDirectoryElement.getValue() != null) {
                this._outputFile = SwitchYardProject.this._project.getFile(new Path(outputDirectoryElement.getValue()).append("META-INF").append("switchyard.xml"));
            }
        }

        private void installSwitchYardPlugin(boolean createExecution, Set<String> scanners) {
            Model model = SwitchYardProject.this.getMavenProject().getOriginalModel();
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            build.addPlugin(M2EUtils.createSwitchYardPlugin(SwitchYardProject.this._rawVersionString, createExecution, scanners));
        }

        private void setDefaultOutputFile() {
            MavenProject mavenProject = SwitchYardProject.this.getMavenProject();
            if (mavenProject == null) {
                return;
            }
            this._outputFile = SwitchYardProject.this._project.getWorkspace().getRoot().getFile(SwitchYardProject.this._mavenProjectFacade.getOutputLocation().append("META-INF").append("switchyard.xml"));
        }
    }
}

