/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.ui.common.ESBInterfaceInputDialog;
import org.switchyard.tools.ui.common.IInterfaceControlAdapter;
import org.switchyard.tools.ui.i18n.Messages;

public class ESBInterfaceControlAdapter
implements IInterfaceControlAdapter {
    private EsbInterface _interface = SwitchyardFactory.eINSTANCE.createEsbInterface();

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setRelatedInterface(Interface related) {
    }

    @Override
    public void init(Interface intf) {
        this._interface = SwitchyardFactory.eINSTANCE.createEsbInterface();
        if (intf instanceof EsbInterface) {
            EsbInterface esbIntfc = (EsbInterface)intf;
            this._interface.setFaultType(esbIntfc.getFaultType());
            this._interface.setInputType(esbIntfc.getInputType());
            this._interface.setOutputType(esbIntfc.getOutputType());
        } else {
            this._interface.setFaultType(null);
            this._interface.setInputType(null);
            this._interface.setOutputType(null);
        }
    }

    @Override
    public boolean browse(Shell shell, IJavaElement element) {
        int rtn_code;
        ESBInterfaceInputDialog dialog = new ESBInterfaceInputDialog(shell);
        if (this._interface.getFaultType() != null && !this._interface.getFaultType().trim().isEmpty()) {
            dialog.setFaultType(this._interface.getFaultType());
        }
        if (this._interface.getOutputType() != null && !this._interface.getOutputType().trim().isEmpty()) {
            dialog.setOutputType(this._interface.getOutputType());
        }
        if (this._interface.getInputType() != null && !this._interface.getInputType().trim().isEmpty()) {
            dialog.setInputType(this._interface.getInputType());
        }
        if ((rtn_code = dialog.open()) == 0) {
            if (dialog.getFaultType() != null && !dialog.getFaultType().trim().isEmpty()) {
                this._interface.setFaultType(dialog.getFaultType());
            }
            if (dialog.getOutputType() != null && !dialog.getOutputType().trim().isEmpty()) {
                this._interface.setOutputType(dialog.getOutputType());
            }
            if (dialog.getInputType() != null && !dialog.getInputType().trim().isEmpty()) {
                this._interface.setInputType(dialog.getInputType());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean open(Shell shell, IJavaProject project, boolean useRelated) {
        return this.browse(shell, (IJavaElement)project);
    }

    @Override
    public String getText() {
        if (this._interface == null) {
            return "";
        }
        if (this._interface.getInputType() == null && this._interface.getOutputType() == null && this._interface.getFaultType() == null) {
            return "";
        }
        String renderText = "";
        renderText = this._interface.getOutputType() != null ? "(" + this._interface.getOutputType() + ") " : "(void) ";
        renderText = String.valueOf(renderText) + "esbOperation(";
        renderText = this._interface.getInputType() != null ? String.valueOf(renderText) + this._interface.getInputType() + ")" : String.valueOf(renderText) + ")";
        if (this._interface.getFaultType() != null) {
            renderText = String.valueOf(renderText) + " throws " + this._interface.getFaultType();
        }
        return renderText;
    }

    @Override
    public IStatus validate(IJavaProject project) {
        if (this._interface.getInputType() == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.ESBInterfaceControlAdapter_statusMessage_specifyInputType);
        }
        if (this._interface.getFaultType() != null && this._interface.getOutputType() == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.ESBInterfaceControlAdapter_statusMessage_specifyingFaultTypeRequiresOutputType);
        }
        return Status.OK_STATUS;
    }
}

