/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.facets.SwitchYardFacetInstallWizardPage;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardSettingsAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IProject _project;
    private IWorkbenchPart _targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._targetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            this.internalRun();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private void internalRun() throws CoreException {
        if (this._project == null || this._targetPart == null) {
            return;
        }
        IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project);
        if (ifp == null) {
            if (MessageDialog.openQuestion((Shell)this._targetPart.getSite().getShell(), (String)Messages.SwitchYardSettingsAction_messageDialog_title_addSYCapabilitiesAndFacet, (String)Messages.SwitchYardSettingsAction_messageDialog_message_addSYCapabilitiesAndFacet)) {
                this.convertToFacetedProject();
            }
            return;
        }
        if (!ifp.hasProjectFacet(ISwitchYardFacetConstants.SWITCHYARD_FACET)) {
            if (MessageDialog.openQuestion((Shell)this._targetPart.getSite().getShell(), (String)Messages.SwitchYardSettingsAction_messageDialog_title_addSYCapabilities, (String)Messages.SwitchYardSettingsAction_messageDialog_message_addSYCapabilities)) {
                this.installSwitchYardFacet(ifp.createWorkingCopy());
            }
            return;
        }
        this.displayPropertyDialog();
    }

    private void convertToFacetedProject() throws CoreException {
        IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        this.installSwitchYardFacet(ifp.createWorkingCopy());
    }

    private void installSwitchYardFacet(final IFacetedProjectWorkingCopy fpwc) {
        try {
            Object config;
            String installPresetId = this.isJarPackaging() ? "preset.switchyard.jar.1_1" : "preset.switchyard.basic.1_1";
            IPreset preset = ProjectFacetsManager.getPreset((String)installPresetId);
            if (preset instanceof IDynamicPreset) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("CONTEXT_KEY_FACETED_PROJECT", fpwc);
                context.put("CONTEXT_KEY_PRIMARY_RUNTIME", fpwc.getPrimaryRuntime());
                context.put("CONTEXT_KEY_FIXED_FACETS", fpwc.getFixedProjectFacets());
                preset = ((IDynamicPreset)preset).resolve(context);
            }
            if (preset == null) {
                MessageDialog.openError((Shell)this._targetPart.getSite().getShell(), (String)Messages.SwitchYardSettingsAction_errorMessage_title_errorInstallingSYFacet, (String)Messages.SwitchYardSettingsAction_errorMessage_errorInstallingSYFacet);
                return;
            }
            for (IProjectFacetVersion pfv : preset.getProjectFacets()) {
                fpwc.addProjectFacet(pfv);
            }
            if (fpwc.getProjectFacetAction(ISwitchYardFacetConstants.SWITCHYARD_FACET) != null && (config = fpwc.getProjectFacetAction(ISwitchYardFacetConstants.SWITCHYARD_FACET).getConfig()) instanceof IDataModel && !((IDataModel)config).isPropertySet("SwitchYard.RUNTIME_VERSION")) {
                ModifyFacetedProjectWizard modifyWizard = new ModifyFacetedProjectWizard(fpwc){

                    public IWizardPage[] getPages() {
                        IWizardPage[] iWizardPageArray = super.getPages();
                        int n = iWizardPageArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWizardPage page = iWizardPageArray[n2];
                            if (page instanceof SwitchYardFacetInstallWizardPage) {
                                return new IWizardPage[]{page};
                            }
                            ++n2;
                        }
                        return new IWizardPage[0];
                    }
                };
                modifyWizard.setShowFacetsSelectionPage(false);
                WizardDialog dialog = new WizardDialog(this._targetPart.getSite().getShell(), (IWizard)modifyWizard);
                dialog.setBlockOnOpen(true);
                dialog.open();
                return;
            }
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            fpwc.commitChanges(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (e.getCause() instanceof CoreException) {
                    Activator.getDefault().getLog().log(((CoreException)e.getCause()).getStatus());
                }
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardSettingsAction_logMessage_errorInitializingSYFacet, (Throwable)e));
            }
            this.displayPropertyDialog();
        }
        finally {
            fpwc.dispose();
        }
    }

    private boolean isJarPackaging() {
        IMavenProjectFacade mavenFacade = MavenPlugin.getMavenProjectRegistry().getProject(this._project);
        return mavenFacade == null || "jar".equals(mavenFacade.getPackaging());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this._project = null;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IProject) {
            this._project = (IProject)obj;
        } else if (obj instanceof ISwitchYardNode) {
            this._project = ((ISwitchYardNode)obj).getRoot().getProject();
        }
    }

    public void dispose() {
        this._project = null;
        this._targetPart = null;
        super.dispose();
    }

    private void displayPropertyDialog() {
        PreferencesUtil.createPropertyDialogOn((Shell)this._targetPart.getSite().getShell(), (IAdaptable)this._project, (String)"org.switchyard.tools.ui.configuration.page", null, null, (int)0).open();
    }
}

