/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.actions.SwitchYardSettingsAction;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.facets.SwitchYardFacetInstallWizardPage;
import org.switchyard.tools.ui.i18n.Messages;

public class ConvertWarToJarAction
extends SwitchYardSettingsAction {
    private IProject _project;
    private IWorkbenchPart _targetPart;

    @Override
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._targetPart = targetPart;
    }

    @Override
    public void run(IAction action) {
        try {
            this.internalRun();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private void internalRun() throws CoreException {
        if (this._project == null || this._targetPart == null) {
            return;
        }
        IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project);
        if (ifp == null) {
            if (MessageDialog.openQuestion((Shell)this._targetPart.getSite().getShell(), (String)Messages.ConvertWarToJarAction_messageDialog_title_AddSYCapabilitiesAndFacets, (String)Messages.ConvertWarToJarAction_messageDialog_message_AddSYCapabilitiesAndFacets)) {
                this.convertToFacetedProject();
                this.updateOpenShiftProject();
            }
            return;
        }
        if (!ifp.hasProjectFacet(ISwitchYardFacetConstants.SWITCHYARD_FACET)) {
            if (MessageDialog.openQuestion((Shell)this._targetPart.getSite().getShell(), (String)Messages.ConvertWarToJarAction_messageDialog_title_AddSYCapabilities, (String)Messages.ConvertWarToJarAction_messageDialog_message_AddSYCapabilities)) {
                this.installSwitchYardFacet(ifp.createWorkingCopy());
                this.updateOpenShiftProject();
            }
            return;
        }
        this.displayPropertyDialog();
    }

    private void convertToFacetedProject() throws CoreException {
        IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        this.removeOpenShiftFacets(ifp.createWorkingCopy());
        this.installSwitchYardFacet(ifp.createWorkingCopy());
    }

    private void removeOpenShiftFacets(IFacetedProjectWorkingCopy fpwc) throws CoreException {
        IFacetedProject ifp = ProjectFacetsManager.create((IProject)this._project, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        Set ipfvs = ifp.getProjectFacets();
        for (IProjectFacetVersion pf : ipfvs) {
            String id = pf.getProjectFacet().getId();
            if (id.equalsIgnoreCase("jboss.m2") || id.equalsIgnoreCase("java") || id.equalsIgnoreCase("jst.cdi")) continue;
            fpwc.removeProjectFacet(pf);
        }
    }

    private void installSwitchYardFacet(final IFacetedProjectWorkingCopy fpwc) {
        block15: {
            try {
                Object config;
                this.removeOpenShiftFacets(fpwc);
                IPreset preset = ProjectFacetsManager.getPreset((String)"preset.switchyard.jar.1_1");
                if (preset instanceof IDynamicPreset) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("CONTEXT_KEY_FACETED_PROJECT", fpwc);
                    context.put("CONTEXT_KEY_PRIMARY_RUNTIME", fpwc.getPrimaryRuntime());
                    context.put("CONTEXT_KEY_FIXED_FACETS", fpwc.getFixedProjectFacets());
                    preset = ((IDynamicPreset)preset).resolve(context);
                }
                if (preset == null) {
                    MessageDialog.openError((Shell)this._targetPart.getSite().getShell(), (String)Messages.ConvertWarToJarAction_errorDialog_title_errorInstallingSYFacet, (String)Messages.ConvertWarToJarAction_errorDialog_message_errorInstallingSYFacet);
                    return;
                }
                for (IProjectFacetVersion pfv : preset.getProjectFacets()) {
                    fpwc.addProjectFacet(pfv);
                }
                if (fpwc.getProjectFacetAction(ISwitchYardFacetConstants.SWITCHYARD_FACET) != null && (config = fpwc.getProjectFacetAction(ISwitchYardFacetConstants.SWITCHYARD_FACET).getConfig()) instanceof IDataModel && !((IDataModel)config).isPropertySet("SwitchYard.RUNTIME_VERSION")) {
                    ModifyFacetedProjectWizard modifyWizard = new ModifyFacetedProjectWizard(fpwc){

                        public IWizardPage[] getPages() {
                            IWizardPage[] iWizardPageArray = super.getPages();
                            int n = iWizardPageArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IWizardPage page = iWizardPageArray[n2];
                                if (page instanceof SwitchYardFacetInstallWizardPage) {
                                    return new IWizardPage[]{page};
                                }
                                ++n2;
                            }
                            return new IWizardPage[0];
                        }
                    };
                    modifyWizard.setShowFacetsSelectionPage(false);
                    WizardDialog dialog = new WizardDialog(this._targetPart.getSite().getShell(), (IWizard)modifyWizard);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    return;
                }
                try {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    fpwc.commitChanges(monitor);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof CoreException) {
                            Activator.getDefault().getLog().log(((CoreException)e.getCause()).getStatus());
                        }
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.ConvertWarToJarAction_errorMessage_errorInitializingSYFacet, (Throwable)e));
                    }
                    this.displayPropertyDialog();
                }
                catch (CoreException e1) {
                    if (e1.getCause() instanceof CoreException) {
                        Activator.getDefault().getLog().log(((CoreException)e1.getCause()).getStatus());
                        break block15;
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.ConvertWarToJarAction_errorMessage_errorInitializingSYFacet, (Throwable)e1));
                }
            }
            finally {
                fpwc.dispose();
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this._project = null;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IProject) {
            this._project = (IProject)obj;
        } else if (obj instanceof ISwitchYardNode) {
            this._project = ((ISwitchYardNode)obj).getRoot().getProject();
        }
    }

    @Override
    public void dispose() {
        this._project = null;
        this._targetPart = null;
        super.dispose();
    }

    private void displayPropertyDialog() {
        PreferencesUtil.createPropertyDialogOn((Shell)this._targetPart.getSite().getShell(), (IAdaptable)this._project, (String)"org.switchyard.tools.ui.configuration.page", null, null, (int)0).open();
    }

    private void updateProject(IProject project, int waitTime) throws Exception {
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        NullProgressMonitor monitor = new NullProgressMonitor();
        configurationManager.updateProjectConfiguration(project, (IProgressMonitor)monitor);
        project.build(6, (IProgressMonitor)monitor);
        if (waitTime > 0) {
            Thread.sleep(waitTime);
        }
    }

    private Element warProfileExists(Element profiles, Namespace ns) {
        List profileList = profiles.getChildren();
        for (Element profile : profileList) {
            Element build = profile.getChild("build", ns);
            Element plugins = build.getChild("plugins", ns);
            List pluginList = plugins.getChildren();
            for (Element plugin : pluginList) {
                Element artifactId = plugin.getChild("artifactId", ns);
                if (!artifactId.getText().equalsIgnoreCase("maven-war-plugin")) continue;
                return plugin;
            }
        }
        return null;
    }

    private void updateOpenShiftProject() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ConvertWarToJarAction.this.handlePOMUpdates();
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)e.getCause()).getStatus());
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.ConvertWarToJarAction_errorMesssage_ErrorInPOMForSYProject, (Throwable)e));
        }
    }

    private void handlePOMUpdates() throws CoreException {
        if (this._project == null || this._targetPart == null) {
            return;
        }
        IFile pomFile = this._project.getFile("pom.xml");
        if (pomFile != null) {
            SAXBuilder builder = new SAXBuilder();
            File xmlFile = new File(pomFile.getLocationURI());
            try {
                Element artifactId;
                Element plugin;
                Element profiles;
                Document doc = builder.build(xmlFile);
                Element rootNode = doc.getRootElement();
                boolean madeChanges = false;
                Element packagingNode = rootNode.getChild("packaging", rootNode.getNamespace());
                if (packagingNode != null && packagingNode.getText().equalsIgnoreCase("war")) {
                    packagingNode.setText("jar");
                    madeChanges = true;
                }
                if ((profiles = rootNode.getChild("profiles", rootNode.getNamespace())) != null && (plugin = this.warProfileExists(profiles, rootNode.getNamespace())) != null && (artifactId = plugin.getChild("artifactId", rootNode.getNamespace())).getText().equalsIgnoreCase("maven-war-plugin")) {
                    Element configuration;
                    artifactId.setText("maven-jar-plugin");
                    Element version = plugin.getChild("version", rootNode.getNamespace());
                    if (version != null) {
                        version.setText("2.3.1");
                    }
                    if ((configuration = plugin.getChild("configuration", rootNode.getNamespace())) != null) {
                        configuration.removeChild("warName", rootNode.getNamespace());
                    }
                    madeChanges = true;
                }
                if (madeChanges) {
                    XMLOutputter xmlOutput = new XMLOutputter();
                    xmlOutput.setFormat(Format.getPrettyFormat());
                    xmlOutput.output(doc, (Writer)new FileWriter(xmlFile.getAbsolutePath()));
                    this._project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    this.updateProject(this._project, -1);
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

