/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadataSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;

public final class M2EUtils {
    public static final String SWITCHYARD_VERSION = "switchyard.version";
    public static final String SWITCHYARD_CORE_GROUP_ID = "org.switchyard";
    public static final String SWITCHYARD_API_ARTIFACT_ID = "switchyard-api";
    public static final String SWITCHYARD_PLUGIN_ARTIFACT_ID = "switchyard-plugin";
    public static final String MAVEN_MAIN_JAVA_PATH = "src/main/java";
    public static final String MAVEN_MAIN_RESOURCES_PATH = "src/main/resources";
    public static final String MAVEN_TEST_JAVA_PATH = "src/test/java";
    public static final String MAVEN_TEST_RESOURCES_PATH = "src/test/resources";
    public static final String JBOSS_PUBLIC_REPOSITORY_DEFAULT_ID = "jboss-public-repository";
    public static final String SWITCHYARD_XML = "switchyard.xml";
    public static final String META_INF = "META-INF";
    public static final String UNKNOWN_VERSION_STRING = new String("unknown");
    public static final String SWITCHYARD_PLUGIN_KEY = Plugin.constructKey((String)"org.switchyard", (String)"switchyard-plugin");
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String SCANNER_CLASS_NAMES_ELEMENT = "scannerClassNames";
    public static final String OUTPUT_FILE_ELEMENT = "outputFile";
    public static final String OUTPUT_DIRECTORY_ELEMENT = "outputDirectory";
    public static final String PARAM_ELEMENT = "param";
    public static final String CONFIGURE_GOAL = "configure";
    public static final String JBOSS_PUBLIC_REPOSITORY_URL = "http://repository.jboss.org/nexus/content/groups/public";

    public static Dependency createSwitchYardDependency(String groupId, String artifactId) {
        return M2EUtils.createSwitchYardDependency(groupId, artifactId, null);
    }

    public static Dependency createSwitchYardDependency(String groupId, String artifactId, String scope) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setScope(scope);
        return dependency;
    }

    public static Repository createJBossPublicRepository(String id) {
        Repository repository = new Repository();
        repository.setId(id);
        repository.setName("JBoss Public Maven Repository");
        repository.setUrl(JBOSS_PUBLIC_REPOSITORY_URL);
        repository.setLayout("default");
        return repository;
    }

    public static List<ArtifactVersion> resolveSwitchYardVersionRange(IProgressMonitor monitor) throws CoreException {
        try {
            return M2EUtils.resolveVersionRange(((RepositorySystem)((MavenImpl)MavenPlugin.getMaven()).getPlexusContainer().lookup(RepositorySystem.class)).createArtifact(SWITCHYARD_CORE_GROUP_ID, SWITCHYARD_API_ARTIFACT_ID, "[,]", "jar"), monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Error resolving version range", (Throwable)e));
        }
    }

    public static List<ArtifactVersion> resolveVersionRange(Artifact artifact, IProgressMonitor monitor) throws CoreException {
        try {
            IMaven maven = MavenPlugin.getMaven();
            ArtifactMetadataSource source = (ArtifactMetadataSource)((MavenImpl)maven).getPlexusContainer().lookup(ArtifactMetadataSource.class, "org.apache.maven.artifact.metadata.ArtifactMetadataSource", "maven");
            return source.retrieveAvailableVersions(artifact, maven.getLocalRepository(), maven.getArtifactRepositories());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", "Error resolving version range", (Throwable)e));
        }
    }

    public static Plugin createSwitchYardPlugin(String version, boolean createExecution, Set<String> scanners) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(SWITCHYARD_PLUGIN_ARTIFACT_ID);
        plugin.setGroupId(SWITCHYARD_CORE_GROUP_ID);
        plugin.setVersion(version);
        if (createExecution) {
            PluginExecution execution = new PluginExecution();
            execution.addGoal(CONFIGURE_GOAL);
            plugin.addExecution(execution);
        }
        if (scanners.isEmpty()) {
            return plugin;
        }
        Xpp3Dom configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
        plugin.setConfiguration((Object)configuration);
        Xpp3Dom scannerElement = new Xpp3Dom(SCANNER_CLASS_NAMES_ELEMENT);
        configuration.addChild(scannerElement);
        for (String scanner : scanners) {
            Xpp3Dom paramElement = new Xpp3Dom(PARAM_ELEMENT);
            paramElement.setValue(scanner);
            scannerElement.addChild(paramElement);
        }
        return plugin;
    }

    public static File getSwitchYardOutputFile(MavenProject project) {
        if (project == null) {
            return null;
        }
        Plugin plugin = M2EUtils.findSwitchYardPlugin(project.getModel());
        if (plugin == null) {
            return null;
        }
        Xpp3Dom configuration = M2EUtils.findSwitchYardPluginConfiguration(plugin);
        if (configuration != null) {
            Xpp3Dom node = configuration.getChild(OUTPUT_FILE_ELEMENT);
            if (node != null && node.getValue() != null) {
                return new File(project.getBasedir(), node.getValue());
            }
            node = configuration.getChild(OUTPUT_DIRECTORY_ELEMENT);
            if (node != null && node.getValue() != null) {
                return new File(new File(project.getBasedir(), node.getValue()), "META-INF/switchyard.xml");
            }
        }
        return new File(project.getBuild().getOutputDirectory(), "META-INF/switchyard.xml");
    }

    private static Plugin findSwitchYardPlugin(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            return null;
        }
        for (Plugin plugin : build.getPlugins()) {
            if (!SWITCHYARD_CORE_GROUP_ID.equals(plugin.getGroupId()) || !SWITCHYARD_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())) continue;
            return plugin;
        }
        return null;
    }

    private static Xpp3Dom findSwitchYardPluginConfiguration(Plugin plugin) {
        Object configuration = plugin.getConfiguration();
        if (configuration instanceof Xpp3Dom) {
            return (Xpp3Dom)configuration;
        }
        for (PluginExecution execution : plugin.getExecutions()) {
            if (!execution.getGoals().contains(CONFIGURE_GOAL)) continue;
            configuration = execution.getConfiguration();
            if (configuration instanceof Xpp3Dom) {
                return (Xpp3Dom)configuration;
            }
            return null;
        }
        return null;
    }

    private M2EUtils() {
    }
}

