/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.IJiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.JiraAttributeMapper;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.JiraFieldType;
import com.atlassian.connector.eclipse.internal.jira.core.JiraRepositoryConnector;
import com.atlassian.connector.eclipse.internal.jira.core.JiraTaskMapper;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.WorkLogConverter;
import com.atlassian.connector.eclipse.internal.jira.core.html.HTML2TextReader;
import com.atlassian.connector.eclipse.internal.jira.core.model.AllowedValue;
import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Comment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueLink;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraVersion;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.ProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.Subtask;
import com.atlassian.connector.eclipse.internal.jira.core.model.User;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraInsufficientPermissionException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteCustomFieldValue;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteIssue;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskDataHandler
extends AbstractTaskDataHandler {
    private static final String CONTEXT_ATTACHEMENT_FILENAME = "mylyn-context.zip";
    private static final String CONTEXT_ATTACHEMENT_FILENAME_LEGACY = "mylar-context.zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION = "mylyn/context/zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY = "mylar/context/zip";
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"com.atlassian.connector.eclipse.jira.core/debug/dataHandler"));
    private static final String REASSIGN_OPERATION = "reassign";
    public static final String STOP_PROGRESS_OPERATION = "301";
    public static final String START_PROGRESS_OPERATION = "4";
    public static final Object IN_PROGRESS_STATUS = "3";
    public static final Object OPEN_STATUS = "1";
    public static final Object REOPEN_STATUS = "4";
    private static final String LEAVE_OPERATION = "leave";
    private static final JiraVersion TASK_DATA_VERSION_1_0 = new JiraVersion("1.0");
    private static final JiraVersion TASK_DATA_VERSION_2_0 = new JiraVersion("2.0");
    private static final JiraVersion TASK_DATA_VERSION_2_2 = new JiraVersion("2.2");
    private static final JiraVersion TASK_DATA_VERSION_CURRENT = new JiraVersion("3.0");
    private final IJiraClientFactory clientFactory;

    public JiraTaskDataHandler(IJiraClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            JiraIssue jiraIssue;
            monitor.beginTask(Messages.JiraTaskDataHandler_Getting_task, -1);
            JiraClient client = this.clientFactory.getJiraClient(repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails(monitor);
            }
            if ((jiraIssue = this.getJiraIssue(client, taskId, repository.getRepositoryUrl(), monitor)) != null) {
                TaskData taskData = this.createTaskData(repository, client, jiraIssue, null, monitor);
                return taskData;
            }
            try {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "JIRA ticket not found: " + taskId, null));
            }
            catch (JiraException e) {
                IStatus status = JiraCorePlugin.toStatus(repository, e);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private JiraIssue getJiraIssue(JiraClient client, String taskId, String repositoryUrl, IProgressMonitor monitor) throws JiraException {
        return client.getIssueById(taskId, monitor);
    }

    public TaskData createTaskData(TaskRepository repository, JiraClient client, JiraIssue jiraIssue, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        return this.createTaskData(repository, client, jiraIssue, oldTaskData, false, monitor);
    }

    public TaskData createTaskData(TaskRepository repository, JiraClient client, JiraIssue jiraIssue, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "jira", repository.getRepositoryUrl(), jiraIssue.getId());
        this.initializeTaskData(repository, data, client, jiraIssue.getProject(), monitor);
        this.updateTaskData(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.addOperations(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        return data;
    }

    private Project ensureProjectHasDetails(JiraClient client, TaskRepository repository, Project project, IProgressMonitor monitor) throws JiraException {
        if (!project.hasDetails()) {
            client.getCache().refreshProjectDetails(project.getId(), monitor);
            return client.getCache().getProjectById(project.getId());
        }
        return project;
    }

    public void initializeTaskData(TaskRepository repository, TaskData data, JiraClient client, Project project, IProgressMonitor monitor) throws JiraException {
        int n;
        SecurityLevel[] securityLevels;
        Project[] jiraProjects;
        project = this.ensureProjectHasDetails(client, repository, project, monitor);
        data.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        this.createAttribute(data, JiraAttribute.CREATION_DATE);
        TaskAttribute summaryAttribute = this.createAttribute(data, JiraAttribute.SUMMARY);
        summaryAttribute.getMetaData().setType("shortRichText");
        TaskAttribute descriptionAttribute = this.createAttribute(data, JiraAttribute.DESCRIPTION);
        descriptionAttribute.getMetaData().setType("longRichText");
        this.createAttribute(data, JiraAttribute.STATUS);
        this.createAttribute(data, JiraAttribute.ISSUE_KEY);
        this.createAttribute(data, JiraAttribute.TASK_URL);
        this.createAttribute(data, JiraAttribute.USER_ASSIGNED);
        this.createAttribute(data, JiraAttribute.USER_REPORTER);
        this.createAttribute(data, JiraAttribute.MODIFICATION_DATE);
        TaskAttribute projectAttribute = this.createAttribute(data, JiraAttribute.PROJECT);
        Project[] projectArray = jiraProjects = client.getCache().getProjects();
        int n2 = jiraProjects.length;
        int n3 = 0;
        while (n3 < n2) {
            Project jiraProject = projectArray[n3];
            projectAttribute.putOption(jiraProject.getId(), jiraProject.getName());
            ++n3;
        }
        projectAttribute.setValue(project.getId());
        TaskAttribute resolutions = this.createAttribute(data, JiraAttribute.RESOLUTION);
        Resolution[] jiraResolutions = client.getCache().getResolutions();
        if (jiraResolutions.length > 0) {
            Resolution[] resolutionArray = jiraResolutions;
            int n4 = jiraResolutions.length;
            int n5 = 0;
            while (n5 < n4) {
                Resolution resolution = resolutionArray[n5];
                resolutions.putOption(resolution.getId(), resolution.getName());
                ++n5;
            }
        } else {
            resolutions.putOption("1", "Fixed");
            resolutions.putOption("2", "Won't Fix");
            resolutions.putOption("3", "Duplicate");
            resolutions.putOption(START_PROGRESS_OPERATION, "Incomplete");
            resolutions.putOption("5", "Cannot Reproduce");
        }
        TaskAttribute priorities = this.createAttribute(data, JiraAttribute.PRIORITY);
        Priority[] jiraPriorities = client.getCache().getPriorities();
        int i = 0;
        while (i < jiraPriorities.length) {
            Priority priority = jiraPriorities[i];
            priorities.putOption(priority.getId(), priority.getName());
            if (i == jiraPriorities.length / 2) {
                priorities.setValue(priority.getId());
            }
            ++i;
        }
        this.createAttribute(data, JiraAttribute.RANK);
        TaskAttribute types = this.createAttribute(data, JiraAttribute.TYPE);
        IssueType[] jiraIssueTypes = project.getIssueTypes();
        if (jiraIssueTypes == null || jiraIssueTypes.length == 0) {
            jiraIssueTypes = client.getCache().getIssueTypes();
        }
        int i2 = 0;
        while (i2 < jiraIssueTypes.length) {
            IssueType type = jiraIssueTypes[i2];
            if (!type.isSubTaskType()) {
                types.putOption(type.getId(), type.getName());
                if (i2 == 0) {
                    types.setValue(type.getId());
                }
            }
            ++i2;
        }
        this.createAttribute(data, JiraAttribute.PARENT_KEY);
        this.createAttribute(data, JiraAttribute.PARENT_ID);
        this.createAttribute(data, JiraAttribute.DUE_DATE);
        this.createAttribute(data, JiraAttribute.ESTIMATE);
        if (!data.isNew()) {
            this.createAttribute(data, JiraAttribute.ACTUAL);
            this.createAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        TaskAttribute affectsVersions = this.createAttribute(data, JiraAttribute.AFFECTSVERSIONS);
        Version[] versionArray = project.getVersions();
        int n6 = versionArray.length;
        int n7 = 0;
        while (n7 < n6) {
            Version version = versionArray[n7];
            affectsVersions.putOption(version.getId(), version.getName());
            ++n7;
        }
        TaskAttribute components = this.createAttribute(data, JiraAttribute.COMPONENTS);
        Component[] componentArray = project.getComponents();
        int n8 = componentArray.length;
        n6 = 0;
        while (n6 < n8) {
            Component component = componentArray[n6];
            components.putOption(component.getId(), component.getName());
            ++n6;
        }
        TaskAttribute fixVersions = this.createAttribute(data, JiraAttribute.FIXVERSIONS);
        Version[] versionArray2 = project.getVersions();
        int n9 = versionArray2.length;
        n8 = 0;
        while (n8 < n9) {
            Version version = versionArray2[n8];
            fixVersions.putOption(version.getId(), version.getName());
            ++n8;
        }
        TaskAttribute env = this.createAttribute(data, JiraAttribute.ENVIRONMENT);
        env.getMetaData().setType("longRichText");
        if (!data.isNew()) {
            TaskAttribute commentAttribute = this.createAttribute(data, JiraAttribute.COMMENT_NEW);
            commentAttribute.getMetaData().setType("longRichText");
        }
        if ((securityLevels = project.getSecurityLevels()) != null) {
            TaskAttribute securityLevelAttribute = this.createAttribute(data, JiraAttribute.SECURITY_LEVEL);
            SecurityLevel[] securityLevelArray = securityLevels;
            n = securityLevels.length;
            int n10 = 0;
            while (n10 < n) {
                SecurityLevel securityLevel = securityLevelArray[n10];
                securityLevelAttribute.putOption(securityLevel.getId(), securityLevel.getName());
                ++n10;
            }
            securityLevelAttribute.setValue(SecurityLevel.NONE.getId());
        }
        data.getRoot().createAttribute("attribute.jira.worklog.new");
        this.createAttribute(data, JiraAttribute.LABELS);
        TaskAttribute projectRoles = this.createAttribute(data, JiraAttribute.PROJECT_ROLES);
        projectRoles.putOption("All Users", "All Users");
        ProjectRole[] roles = client.getCache().getProjectRoles();
        if (roles != null) {
            ProjectRole[] projectRoleArray = roles;
            int n11 = roles.length;
            n = 0;
            while (n < n11) {
                ProjectRole projectRole = projectRoleArray[n];
                projectRoles.putOption(projectRole.getName(), projectRole.getName());
                ++n;
            }
        }
        this.createAttribute(data, JiraAttribute.VOTES);
    }

    public TaskAttribute createAttribute(TaskData data, JiraAttribute key) {
        TaskAttribute attribute = data.getRoot().createAttribute(key.id());
        attribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.getName()).setType(key.getType().getTaskType()).putValue("type", key.getType().getKey());
        return attribute;
    }

    private void updateTaskData(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        Serializable version;
        Serializable[] serializableArray;
        IssueType issueType;
        SecurityLevel securityLevel;
        int n;
        IssueLink[] issueLinks;
        String parentKey = jiraIssue.getParentKey();
        if (parentKey != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_KEY, parentKey);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_KEY);
        }
        String parentId = jiraIssue.getParentId();
        if (parentId != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_ID, parentId);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_ID);
        }
        Subtask[] subtasks = jiraIssue.getSubtasks();
        if (subtasks != null && subtasks.length > 0) {
            this.createAttribute(data, JiraAttribute.SUBTASK_IDS);
            this.createAttribute(data, JiraAttribute.SUBTASK_KEYS);
            Subtask[] subtaskArray = subtasks;
            int n2 = subtasks.length;
            int n3 = 0;
            while (n3 < n2) {
                Subtask subtask = subtaskArray[n3];
                this.addAttributeValue(data, JiraAttribute.SUBTASK_IDS, subtask.getIssueId());
                this.addAttributeValue(data, JiraAttribute.SUBTASK_KEYS, subtask.getIssueKey());
                ++n3;
            }
        }
        if ((issueLinks = jiraIssue.getIssueLinks()) != null && issueLinks.length > 0) {
            HashMap<String, TaskAttribute> links = new HashMap<String, TaskAttribute>();
            IssueLink[] issueLinkArray = issueLinks;
            n = issueLinks.length;
            int n4 = 0;
            while (n4 < n) {
                String desc;
                String key;
                IssueLink link = issueLinkArray[n4];
                if (link.getInwardDescription() == null) {
                    key = String.valueOf(link.getLinkTypeId()) + "outward";
                    desc = link.getOutwardDescription();
                } else {
                    key = String.valueOf(link.getLinkTypeId()) + "inward";
                    desc = link.getInwardDescription();
                }
                String label = String.valueOf(this.capitalize(desc)) + ":";
                TaskAttribute attribute = (TaskAttribute)links.get(key);
                if (attribute == null) {
                    attribute = data.getRoot().createAttribute("attribute.jira.link::" + key);
                    attribute.getMetaData().setKind("task.common.kind.default").setLabel(label).setType(JiraFieldType.ISSUELINKS.getTaskType()).putValue("type", JiraFieldType.ISSUELINKS.getKey());
                    links.put(key, attribute);
                }
                attribute.addValue(link.getIssueKey());
                if (link.getInwardDescription() != null) {
                    attribute = data.getRoot().getMappedAttribute(JiraAttribute.LINKED_IDS.id());
                    if (attribute == null) {
                        attribute = this.createAttribute(data, JiraAttribute.LINKED_IDS);
                    }
                    this.addAttributeValue(data, JiraAttribute.LINKED_IDS, link.getIssueId());
                }
                ++n4;
            }
        }
        this.setAttributeValue(data, JiraAttribute.CREATION_DATE, JiraUtil.dateToString(jiraIssue.getCreated()));
        this.setAttributeValue(data, JiraAttribute.SUMMARY, jiraIssue.getSummary());
        this.setAttributeValue(data, JiraAttribute.DESCRIPTION, jiraIssue.getDescription());
        this.setAttributeValue(data, JiraAttribute.ISSUE_KEY, jiraIssue.getKey());
        this.setAttributeValue(data, JiraAttribute.TASK_URL, jiraIssue.getUrl());
        this.setAttributeValue(data, JiraAttribute.RESOLUTION, jiraIssue.getResolution() == null ? "" : jiraIssue.getResolution().getId());
        this.setAttributeValue(data, JiraAttribute.MODIFICATION_DATE, JiraUtil.dateToString(jiraIssue.getUpdated()));
        this.setAttributeValue(data, JiraAttribute.USER_ASSIGNED, JiraTaskDataHandler.getPerson(data, client, jiraIssue.getAssignee(), jiraIssue.getAssigneeDisplayName()));
        this.setAttributeValue(data, JiraAttribute.USER_REPORTER, JiraTaskDataHandler.getPerson(data, client, jiraIssue.getReporter(), jiraIssue.getReporterName()));
        this.setAttributeValue(data, JiraAttribute.PROJECT, jiraIssue.getProject().getId());
        if (jiraIssue.getStatus() != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(JiraAttribute.STATUS.id());
            attribute.putOption(jiraIssue.getStatus().getId(), jiraIssue.getStatus().getName());
            attribute.setValue(jiraIssue.getStatus().getId());
        }
        if (jiraIssue.getPriority() != null) {
            this.setAttributeValue(data, JiraAttribute.PRIORITY, jiraIssue.getPriority().getId());
        } else {
            this.removeAttribute(data, JiraAttribute.PRIORITY);
        }
        if (jiraIssue.getRank() != null) {
            this.setAttributeValue(data, JiraAttribute.RANK, jiraIssue.getRank().toString());
        }
        if ((securityLevel = jiraIssue.getSecurityLevel()) != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(JiraAttribute.SECURITY_LEVEL.id());
            if (attribute == null) {
                attribute = this.createAttribute(data, JiraAttribute.SECURITY_LEVEL);
                attribute.getMetaData().setReadOnly(true);
            }
            if (!attribute.getOptions().containsKey(securityLevel.getId())) {
                attribute.putOption(securityLevel.getId(), securityLevel.getName());
            }
            attribute.setValue(securityLevel.getId());
        }
        if ((issueType = jiraIssue.getType()) != null) {
            TaskAttribute attribute = this.setAttributeValue(data, JiraAttribute.TYPE, issueType.getId());
            if (issueType.isSubTaskType()) {
                attribute.getMetaData().setReadOnly(true).putValue("isSubtaskType", Boolean.toString(true));
                attribute.clearOptions();
                attribute.putOption(issueType.getId(), issueType.getName());
            }
        } else {
            this.removeAttribute(data, JiraAttribute.TYPE);
        }
        if (jiraIssue.getInitialEstimate() != null && !jiraIssue.getInitialEstimate().equals(jiraIssue.getEstimate())) {
            this.setAttributeValue(data, JiraAttribute.INITIAL_ESTIMATE, "" + jiraIssue.getInitialEstimate());
        } else {
            this.removeAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        this.setAttributeValue(data, JiraAttribute.ESTIMATE, "" + jiraIssue.getEstimate());
        this.setAttributeValue(data, JiraAttribute.ACTUAL, String.valueOf(jiraIssue.getActual()));
        if (jiraIssue.getDue() != null) {
            this.setAttributeValue(data, JiraAttribute.DUE_DATE, JiraUtil.dateToString(jiraIssue.getDue()));
        } else if (!jiraIssue.hasDueDate()) {
            this.removeAttribute(data, JiraAttribute.DUE_DATE);
        }
        if (jiraIssue.getComponents() != null) {
            serializableArray = jiraIssue.getComponents();
            int n5 = serializableArray.length;
            n = 0;
            while (n < n5) {
                Serializable component = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.COMPONENTS, ((Component)component).getId());
                ++n;
            }
        }
        if (jiraIssue.getReportedVersions() != null) {
            serializableArray = jiraIssue.getReportedVersions();
            int n6 = serializableArray.length;
            n = 0;
            while (n < n6) {
                version = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.AFFECTSVERSIONS, ((Version)version).getId());
                ++n;
            }
        }
        if (jiraIssue.getFixVersions() != null) {
            serializableArray = jiraIssue.getFixVersions();
            int n7 = serializableArray.length;
            n = 0;
            while (n < n7) {
                version = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.FIXVERSIONS, ((Version)version).getId());
                ++n;
            }
        }
        if (jiraIssue.getEnvironment() != null) {
            this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, jiraIssue.getEnvironment());
        } else {
            this.removeAttribute(data, JiraAttribute.ENVIRONMENT);
        }
        if (jiraIssue.getVotes() > 0) {
            this.setAttributeValue(data, JiraAttribute.VOTES, Integer.toString(jiraIssue.getVotes()));
        } else {
            this.removeAttribute(data, JiraAttribute.VOTES);
        }
        if (jiraIssue.getLabels().length > 0) {
            this.setAttributeValue(data, JiraAttribute.LABELS, StringUtils.join((Object[])jiraIssue.getLabels(), (String)" "));
        }
        this.addAttributeValue(data, JiraAttribute.PROJECT_ROLES, "All Users");
        this.addComments(data, jiraIssue, client);
        this.addAttachments(data, jiraIssue, client);
        this.addEditableCustomFields(data, jiraIssue);
        this.addCustomFieldsValues(data, jiraIssue);
        this.addWorklog(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.updateMarkup(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        Map<String, List<AllowedValue>> editableKeys = this.getEditableKeys(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.updateProperties(data, editableKeys);
    }

    private void addEditableCustomFields(TaskData data, JiraIssue jiraIssue) {
        IssueField[] editableAttributes = jiraIssue.getEditableFields();
        if (editableAttributes != null) {
            IssueField[] issueFieldArray = editableAttributes;
            int n = editableAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                IssueField field = issueFieldArray[n2];
                if (field.getId().startsWith("customfield")) {
                    String mappedKey = this.mapCommonAttributeKey(field.getId());
                    if (!data.getRoot().getAttributes().containsKey(mappedKey)) {
                        String name = String.valueOf(field.getName()) + ":";
                        String kind = JiraAttribute.valueById(mappedKey).getKind();
                        String type = field.getType();
                        String taskType = JiraFieldType.fromKey(type).getTaskType();
                        if (taskType == null && type != null && type.startsWith("com.atlassian.jira.toolkit")) {
                            taskType = "shortText";
                        }
                        TaskAttribute attribute = data.getRoot().createAttribute(mappedKey);
                        attribute.getMetaData().defaults().setKind(kind).setLabel(name).setReadOnly(false).setType(taskType).putValue("type", type);
                    }
                }
                ++n2;
            }
        }
    }

    public static IRepositoryPerson getPerson(TaskData data, JiraClient client, String userId, String fullName) {
        if (userId == null || "-1".equals(userId)) {
            userId = "";
        }
        User user = fullName != null ? client.getCache().putUser(userId, fullName) : client.getCache().getUser(userId);
        IRepositoryPerson person = data.getAttributeMapper().getTaskRepository().createPerson(userId);
        if (user != null) {
            person.setName(user.getFullName());
        }
        return person;
    }

    private void addComments(TaskData data, JiraIssue jiraIssue, JiraClient client) {
        int i = 1;
        ArrayList<Comment> comments = new ArrayList<Comment>(Arrays.asList(jiraIssue.getComments()));
        Collections.sort(comments, new CommentDateComparator());
        for (Comment comment : comments) {
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + i);
            TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
            taskComment.setAuthor(JiraTaskDataHandler.getPerson(data, client, comment.getAuthor(), comment.getAuthorDisplayName()));
            taskComment.setNumber(Integer.valueOf(i));
            String commentText = comment.getComment();
            if (comment.isMarkupDetected()) {
                commentText = JiraTaskDataHandler.stripTags(commentText);
            }
            taskComment.setText(commentText);
            taskComment.setCreationDate(comment.getCreated());
            taskComment.applyTo(attribute);
            if (comment.getRoleLevel() != null) {
                TaskAttribute level = attribute.createAttribute("task.common.comment.level");
                level.setValue(comment.getRoleLevel());
            }
            ++i;
        }
    }

    private void addAttachments(TaskData data, JiraIssue jiraIssue, JiraClient client) {
        int i = 1;
        Attachment[] attachmentArray = jiraIssue.getAttachments();
        int n = attachmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attachment attachment = attachmentArray[n2];
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.attachment-" + i);
            TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)attribute);
            taskAttachment.setAttachmentId(attachment.getId());
            taskAttachment.setAuthor(JiraTaskDataHandler.getPerson(data, client, attachment.getAuthorDisplayName(), null));
            taskAttachment.setFileName(attachment.getName());
            if (CONTEXT_ATTACHEMENT_FILENAME.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION);
            } else if (CONTEXT_ATTACHEMENT_FILENAME_LEGACY.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY);
            } else {
                taskAttachment.setDescription(attachment.getName());
            }
            taskAttachment.setLength(Long.valueOf(attachment.getSize()));
            taskAttachment.setCreationDate(attachment.getCreated());
            taskAttachment.setUrl(attachment.getContent().toString());
            taskAttachment.applyTo(attribute);
            ++i;
            ++n2;
        }
    }

    private void addCustomFieldsValues(TaskData data, JiraIssue jiraIssue) {
        CustomField[] customFieldArray = jiraIssue.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField field = customFieldArray[n2];
            String mappedKey = this.mapCommonAttributeKey(field.getId());
            TaskAttribute attribute = (TaskAttribute)data.getRoot().getAttributes().get(mappedKey);
            if (attribute != null) {
                for (String value : field.getValues()) {
                    attribute.addValue(value);
                }
            }
            ++n2;
        }
    }

    private Map<String, List<AllowedValue>> getEditableKeys(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        HashMap<String, List<AllowedValue>> editableKeys = new HashMap<String, List<AllowedValue>>();
        if (!JiraRepositoryConnector.isClosed(jiraIssue)) {
            if (this.useCachedInformation(jiraIssue, oldTaskData, forceCache)) {
                TaskAttribute attribute2;
                if (oldTaskData == null) {
                    data.setPartial(true);
                    return editableKeys;
                }
                for (TaskAttribute attribute2 : oldTaskData.getRoot().getAttributes().values()) {
                    if (attribute2.getMetaData().isReadOnly()) continue;
                    editableKeys.put(attribute2.getId(), Collections.emptyList());
                }
                attribute2 = oldTaskData.getRoot().getAttribute("attribute.jira.read-only");
                if (attribute2 != null) {
                    data.getRoot().deepAddCopy(attribute2);
                }
            } else {
                IssueField[] editableAttributes = jiraIssue.getEditableFields();
                if (editableAttributes != null && editableAttributes.length > 0) {
                    IssueField[] issueFieldArray = editableAttributes;
                    int n = editableAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IssueField field = issueFieldArray[n2];
                        editableKeys.put(this.mapCommonAttributeKey(field.getId()), field.getAlloweValues());
                        ++n2;
                    }
                } else {
                    data.getRoot().createAttribute("attribute.jira.read-only");
                }
            }
        }
        return editableKeys;
    }

    private void updateProperties(TaskData data, Map<String, List<AllowedValue>> editableKeys) {
        for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
            List<AllowedValue> allowedValues;
            TaskAttributeMetaData properties = attribute.getMetaData();
            boolean editable = editableKeys.containsKey(attribute.getId().toLowerCase());
            if (editable && (attribute.getId().startsWith("attribute.jira.custom::") || !JiraAttribute.valueById(attribute.getId()).isHidden())) {
                properties.setKind("task.common.kind.default");
            }
            if ("task.common.comment.new".equals(attribute.getId()) || "task.common.resolution".equals(attribute.getId()) || "task.common.user.assigned".equals(attribute.getId()) || JiraAttribute.PROJECT_ROLES.id().equals(attribute.getId())) {
                properties.setReadOnly(false);
                continue;
            }
            if (editable && attribute.getId().startsWith("attribute.jira.custom::") && (allowedValues = editableKeys.get(attribute.getId().toLowerCase())) != null && allowedValues.size() > 0) {
                if ("singleSelect".equals(attribute.getMetaData().getType())) {
                    attribute.putOption("-1", "None");
                    if (attribute.getValues().size() == 0) {
                        attribute.addValue("-1");
                    }
                }
                for (AllowedValue allowedValue : allowedValues) {
                    attribute.putOption(allowedValue.getValue(), allowedValue.getValue());
                }
            }
            String key = properties.getValue("type");
            Map options = attribute.getOptions();
            if (JiraFieldType.SELECT.getKey().equals(key) && (options.isEmpty() || properties.isReadOnly())) {
                properties.setReadOnly(true);
                continue;
            }
            if (JiraFieldType.MULTISELECT.getKey().equals(key) && options.isEmpty()) {
                properties.setReadOnly(true);
                continue;
            }
            if (properties.isReadOnly()) {
                properties.setReadOnly(true);
                continue;
            }
            properties.setReadOnly(!editable);
        }
    }

    private void addAttributeValue(TaskData data, JiraAttribute key, String value) {
        data.getRoot().getAttribute(key.id()).addValue(value);
    }

    private TaskAttribute setAttributeValue(TaskData data, JiraAttribute key, String value) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        if (value != null) {
            attribute.setValue(value);
        }
        return attribute;
    }

    private TaskAttribute setAttributeValue(TaskData data, JiraAttribute key, IRepositoryPerson person) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        data.getAttributeMapper().setRepositoryPerson(attribute, person);
        return attribute;
    }

    private boolean useCachedInformation(JiraIssue issue, TaskData oldTaskData, boolean forceCache) {
        TaskAttribute attribute;
        if (forceCache) {
            return true;
        }
        if (oldTaskData != null && issue.getStatus() != null && (attribute = oldTaskData.getRoot().getMappedAttribute("task.common.status")) != null) {
            return attribute.getValue().equals(issue.getStatus().getId());
        }
        return false;
    }

    private void removeAttribute(TaskData data, JiraAttribute key) {
        data.getRoot().removeAttribute(key.id());
    }

    private String capitalize(String s) {
        char c;
        char uc;
        if (s.length() > 1 && (uc = Character.toUpperCase(c = s.charAt(0))) != c) {
            return String.valueOf(uc) + s.substring(1);
        }
        return s;
    }

    public static String stripTags(String text) {
        int len;
        char[] chars;
        block4: {
            if (text == null || text.length() == 0) {
                return "";
            }
            StringReader stringReader = new StringReader(text);
            HTML2TextReader html2TextReader = new HTML2TextReader(stringReader);
            try {
                chars = new char[text.length()];
                len = html2TextReader.read(chars, 0, text.length());
                if (len != -1) break block4;
                return "";
            }
            catch (IOException iOException) {
                return text;
            }
        }
        return new String(chars, 0, len);
    }

    private void updateMarkup(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        int n;
        if (!jiraIssue.isMarkupDetected()) {
            return;
        }
        if (this.useCachedData(jiraIssue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            if (data.getRoot().getAttribute("task.common.description") != null) {
                this.setAttributeValue(data, JiraAttribute.DESCRIPTION, JiraTaskDataHandler.getAttributeValue(oldTaskData, JiraAttribute.DESCRIPTION));
            }
            if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
                this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, JiraTaskDataHandler.getAttributeValue(oldTaskData, JiraAttribute.ENVIRONMENT));
            }
            CustomField[] customFieldArray = jiraIssue.getCustomFields();
            int n2 = customFieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CustomField field = customFieldArray[n3];
                if (field.isMarkupDetected()) {
                    String attributeId = this.mapCommonAttributeKey(field.getId());
                    TaskAttribute oldAttribute = oldTaskData.getRoot().getAttribute(attributeId);
                    if (oldAttribute != null) {
                        TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                        attribute.setValues(oldAttribute.getValues());
                    }
                }
                ++n3;
            }
            int i = 1;
            Comment[] commentArray = jiraIssue.getComments();
            int n4 = commentArray.length;
            n2 = 0;
            while (n2 < n4) {
                Comment comment = commentArray[n2];
                if (comment.isMarkupDetected()) {
                    String attributeId = "task.common.comment-" + i;
                    TaskAttribute oldAttribute = oldTaskData.getRoot().getAttribute(attributeId);
                    if (oldAttribute != null) {
                        TaskCommentMapper oldComment = TaskCommentMapper.createFrom((TaskAttribute)oldAttribute);
                        TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                        TaskCommentMapper newComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                        newComment.setText(oldComment.getText());
                        newComment.applyTo(attribute);
                    }
                }
                ++i;
                ++n2;
            }
            return;
        }
        try {
            RemoteIssue remoteIssue = client.getSoapClient().getIssueByKey(jiraIssue.getKey(), monitor);
            if (data.getRoot().getAttribute("task.common.description") != null) {
                if (remoteIssue.getDescription() == null) {
                    this.setAttributeValue(data, JiraAttribute.DESCRIPTION, "");
                } else {
                    this.setAttributeValue(data, JiraAttribute.DESCRIPTION, remoteIssue.getDescription());
                }
            }
            if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
                if (remoteIssue.getEnvironment() == null) {
                    this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, "");
                } else {
                    this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, remoteIssue.getEnvironment());
                }
            }
            RemoteCustomFieldValue[] fields = remoteIssue.getCustomFieldValues();
            CustomField[] customFieldArray = jiraIssue.getCustomFields();
            int n5 = customFieldArray.length;
            n = 0;
            while (n < n5) {
                CustomField field = customFieldArray[n];
                if (field.isMarkupDetected()) {
                    RemoteCustomFieldValue[] newComment = fields;
                    int attribute = fields.length;
                    int oldComment = 0;
                    while (oldComment < attribute) {
                        RemoteCustomFieldValue remoteField = newComment[oldComment];
                        if (field.getId().equals(remoteField.getCustomfieldId())) {
                            String attributeId = this.mapCommonAttributeKey(field.getId());
                            TaskAttribute attribute2 = data.getRoot().getAttribute(attributeId);
                            if (attribute2 == null) break;
                            attribute2.setValues(Arrays.asList(remoteField.getValues()));
                            break;
                        }
                        ++oldComment;
                    }
                }
                ++n;
            }
        }
        catch (JiraInsufficientPermissionException e) {
            JiraTaskDataHandler.trace(e);
        }
        boolean retrieveComments = false;
        Comment[] commentArray = jiraIssue.getComments();
        n = commentArray.length;
        int field = 0;
        while (field < n) {
            Comment comment = commentArray[field];
            if (comment.isMarkupDetected()) {
                retrieveComments = true;
            }
            ++field;
        }
        if (retrieveComments) {
            try {
                Comment[] remoteComments = client.getSoapClient().getComments(jiraIssue.getKey(), monitor);
                int i = 1;
                Comment[] commentArray2 = remoteComments;
                int n6 = remoteComments.length;
                int n7 = 0;
                while (n7 < n6) {
                    Comment remoteComment = commentArray2[n7];
                    String attributeId = "task.common.comment-" + i;
                    TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                    if (attribute != null) {
                        TaskCommentMapper comment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                        comment.setText(remoteComment.getComment());
                        comment.applyTo(attribute);
                    }
                    ++i;
                    ++n7;
                }
            }
            catch (JiraInsufficientPermissionException e) {
                JiraTaskDataHandler.trace(e);
            }
            catch (JiraServiceUnavailableException e) {
                if ("Invalid element in com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteComment - level".equals(e.getMessage())) {
                    JiraTaskDataHandler.trace(e);
                }
                throw e;
            }
        }
    }

    private boolean useCachedData(JiraIssue jiraIssue, TaskData oldTaskData, boolean forceCache) {
        if (forceCache) {
            return true;
        }
        return jiraIssue.getUpdated() != null && oldTaskData != null && jiraIssue.getUpdated().equals(JiraTaskDataHandler.getDateValue(oldTaskData, JiraAttribute.MODIFICATION_DATE));
    }

    private void addWorklog(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        if (this.useCachedData(jiraIssue, oldTaskData, forceCache) && this.useCachedInformation(jiraIssue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            List attributes = oldTaskData.getAttributeMapper().getAttributesByType(oldTaskData, "jira.worklog");
            for (TaskAttribute taskAttribute : attributes) {
                data.getRoot().deepAddCopy(taskAttribute);
            }
            TaskAttribute attribute = oldTaskData.getRoot().getAttribute("attribute.jira.worklog-not-supported");
            if (attribute != null) {
                data.getRoot().deepAddCopy(attribute);
            }
            return;
        }
        JiraWorkLog[] remoteWorklogs = jiraIssue.getWorklogs();
        if (remoteWorklogs != null) {
            int i = 1;
            JiraWorkLog[] jiraWorkLogArray = remoteWorklogs;
            int n = remoteWorklogs.length;
            int n2 = 0;
            while (n2 < n) {
                JiraWorkLog remoteWorklog = jiraWorkLogArray[n2];
                String attributeId = "attribute.jira.worklog--" + i;
                TaskAttribute attribute = data.getRoot().createAttribute(attributeId);
                attribute.getMetaData().setType("jira.worklog");
                new WorkLogConverter().applyTo(remoteWorklog, attribute);
                ++i;
                ++n2;
            }
        } else {
            data.getRoot().createAttribute("attribute.jira.worklog-not-supported");
        }
    }

    public void addOperations(TaskData data, JiraIssue issue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        if (this.useCachedInformation(issue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            List attributes = oldTaskData.getAttributeMapper().getAttributesByType(oldTaskData, "operation");
            for (TaskAttribute taskAttribute : attributes) {
                data.getRoot().deepAddCopy(taskAttribute);
            }
            return;
        }
        JiraStatus status = issue.getStatus();
        String label = status != null ? NLS.bind((String)Messages.JiraTaskDataHandler_Leave_as_X, (Object)status.getName()) : Messages.JiraTaskDataHandler_Leave;
        TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation-leave");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        attribute = data.getRoot().createAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        Iterable<JiraAction> availableActions = client.getAvailableActions(issue.getKey(), monitor);
        if (availableActions != null) {
            for (JiraAction action : availableActions) {
                attribute = data.getRoot().createAttribute("task.common.operation-" + action.getId());
                TaskOperation.applyTo((TaskAttribute)attribute, (String)action.getId(), (String)action.getName());
                List<IssueField> fields = action.getFields();
                for (IssueField field : fields) {
                    if (!"task.common.resolution".equals(this.mapCommonAttributeKey(field.getId()))) continue;
                    attribute.getMetaData().putValue("task.meta.associated.attribute", "task.common.resolution");
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            block27: {
                monitor.beginTask(Messages.JiraTaskDataHandler_Sending_task, -1);
                client = this.clientFactory.getJiraClient(repository);
                if (client == null) {
                    throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 4, "Unable to create Jira client", null));
                }
                try {
                    if (!client.getCache().hasDetails()) {
                        client.getCache().refreshDetails(monitor);
                    }
                    issue = JiraTaskDataHandler.buildJiraIssue(taskData);
                    if (taskData.isNew()) {
                        if ((issue = client.createIssue(issue, monitor)) == null) {
                            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "Could not create issue.", null));
                        }
                        if (taskData.getRoot().getAttribute("attribute.jira.worklog-not-supported") == null) {
                            this.postWorkLog(repository, client, taskData, issue, monitor);
                        }
                        var16_8 = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, issue.getId());
                        return var16_8;
                    }
                    operationId = this.getOperationId(taskData);
                    newComment = this.getNewComment(taskData);
                    changeIds = new HashSet<String>();
                    if (changedAttributes == null) break block27;
                    ** for (ta : changedAttributes)
                }
                catch (JiraException e) {
                    status = JiraCorePlugin.toStatus(repository, e);
                    StatusHandler.log((IStatus)status);
                    throw new CoreException(status);
                }
lbl-1000:
                // 1 sources

                {
                    changeIds.add(ta.getId());
                    continue;
                }
            }
            soapComment = null;
            commentVisibilityAttribute = taskData.getRoot().getMappedAttribute(JiraAttribute.PROJECT_ROLES.id());
            if (commentVisibilityAttribute != null && !"All Users".equals(commentVisibility = commentVisibilityAttribute.getValue())) {
                changeIds.remove(JiraAttribute.PROJECT_ROLES.id());
                if (newComment != null && newComment.length() > 0) {
                    soapComment = new Comment();
                    soapComment.setComment(newComment);
                    soapComment.setRoleLevel(commentVisibility);
                    newComment = null;
                }
            }
            handled = false;
            advWorkflowHandled = false;
            if (!handled && changeIds.contains("attribute.jira.worklog.new")) {
                this.postWorkLog(repository, client, taskData, issue, monitor);
                changeIds.remove("attribute.jira.worklog.new");
                if (changeIds.size() == 0) {
                    handled = true;
                }
            }
            if (!handled && changeIds.contains("task.common.user.assigned")) {
                anythingElse = new HashSet<E>(changeIds);
                anythingElse.removeAll(Arrays.asList(new String[]{"task.common.user.assigned", "task.common.comment.new"}));
                if (anythingElse.size() == 0) {
                    client.assignIssueTo(issue, this.getAssignee(taskData), newComment, monitor);
                    handled = true;
                }
            }
            if (!handled && changeIds.contains("task.common.operation")) {
                anythingElse = new HashSet<E>(changeIds);
                anythingElse.removeAll(Arrays.asList(new String[]{"task.common.operation", "task.common.comment.new", "task.common.resolution"}));
                if (anythingElse.size() == 0) {
                    client.advanceIssueWorkflow(issue, operationId, newComment, monitor);
                    handled = true;
                    advWorkflowHandled = true;
                }
            }
            if (!handled && "301".equals(operationId)) {
                client.advanceIssueWorkflow(issue, operationId, null, monitor);
                advWorkflowHandled = true;
            }
            if (!(handled || JiraRepositoryConnector.isClosed(issue) || taskData.getRoot().getMappedAttribute("attribute.jira.read-only") != null || changeIds.equals(Collections.singleton("task.common.comment.new")) || "301".equals(operationId) && changeIds.equals(Collections.singleton("task.common.operation")))) {
                client.updateIssue(issue, newComment, changeIds.contains(JiraAttribute.ESTIMATE.id()), monitor);
                handled = true;
            }
            if (!handled && newComment != null && newComment.length() > 0) {
                client.addCommentToIssue(issue.getKey(), newComment, monitor);
                handled = true;
            } else if (soapComment != null) {
                client.addCommentToIssue(issue.getKey(), soapComment.getComment(), monitor);
                handled = true;
            }
            if (!(advWorkflowHandled || "leave".equals(operationId) || "reassign".equals(operationId) || "301".equals(operationId))) {
                client.advanceIssueWorkflow(issue, operationId, null, monitor);
            }
            var16_9 = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, issue.getId());
            return var16_9;
        }
        finally {
            monitor.done();
        }
    }

    private void postWorkLog(TaskRepository repository, JiraClient client, TaskData taskData, JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        TaskAttribute submitFlagAttribute;
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("attribute.jira.worklog.new");
        if (attribute != null && (submitFlagAttribute = attribute.getAttribute("attribute.jira.worklog.new.submit.flag")) != null && submitFlagAttribute.getValue().equals(String.valueOf(true))) {
            JiraWorkLog log = new WorkLogConverter().createFrom(attribute);
            client.addWorkLog(issue.getKey(), log, monitor);
        }
    }

    private String getNewComment(TaskData taskData) {
        String newComment = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
        if (attribute != null) {
            newComment = taskData.getAttributeMapper().getValue(attribute);
        }
        return newComment;
    }

    private String getAssignee(TaskData taskData) {
        String asignee = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.user.assigned");
        if (attribute != null) {
            asignee = taskData.getAttributeMapper().getValue(attribute);
        }
        return asignee;
    }

    private String getOperationId(TaskData taskData) {
        String operationId = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        if (attribute != null) {
            operationId = taskData.getAttributeMapper().getValue(attribute);
        }
        if (operationId.length() == 0) {
            operationId = LEAVE_OPERATION;
        }
        return operationId;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        Project project;
        if (initializationData == null) {
            return false;
        }
        String product = initializationData.getProduct();
        if (product == null) {
            return false;
        }
        JiraClient client = this.clientFactory.getJiraClient(repository);
        if (!client.getCache().hasDetails()) {
            try {
                client.getCache().refreshDetails(monitor);
            }
            catch (JiraException ex) {
                IStatus status = JiraCorePlugin.toStatus(repository, ex);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        if ((project = this.getProject(client, product)) == null) {
            return false;
        }
        if (!project.hasDetails()) {
            try {
                client.getCache().refreshProjectDetails(project.getId(), monitor);
            }
            catch (JiraException e) {
                IStatus status = JiraCorePlugin.toStatus(repository, e);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        try {
            this.initializeTaskData(repository, data, client, project, monitor);
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus(repository, e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        return true;
    }

    private Project getProject(JiraClient client, String product) {
        Project[] projects;
        Project[] projectArray = projects = client.getCache().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            if (product.equals(project.getName()) || product.equals(project.getKey())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData taskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        try {
            IssueType[] jiraIssueTypes;
            TaskAttribute projectAttribute;
            monitor.beginTask(Messages.JiraTaskDataHandler_Creating_subtask, -1);
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if ((projectAttribute = parentTaskData.getRoot().getAttribute("task.common.product")) == null) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "The parent task does not have a valid project.", null));
            }
            Project project = client.getCache().getProjectById(projectAttribute.getValue());
            this.initializeTaskData(repository, taskData, client, project, monitor);
            new JiraTaskMapper(taskData).merge((ITaskMapping)new JiraTaskMapper(parentTaskData));
            taskData.getRoot().getAttribute(JiraAttribute.PROJECT.id()).setValue(project.getId());
            taskData.getRoot().getAttribute(JiraAttribute.DESCRIPTION.id()).setValue("");
            taskData.getRoot().getAttribute(JiraAttribute.SUMMARY.id()).setValue("");
            TaskAttribute typeAttribute = taskData.getRoot().getAttribute(JiraAttribute.TYPE.id());
            typeAttribute.clearOptions();
            IssueType[] issueTypeArray = jiraIssueTypes = client.getCache().getIssueTypes();
            int n = jiraIssueTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IssueType type = issueTypeArray[n2];
                if (type.isSubTaskType()) {
                    typeAttribute.putOption(type.getId(), type.getName());
                }
                ++n2;
            }
            Map options = typeAttribute.getOptions();
            if (options.size() == 0) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "The repository does not support subtasks.", null));
            }
            if (options.size() == 1) {
                typeAttribute.getMetaData().setReadOnly(true);
            }
            typeAttribute.setValue((String)options.keySet().iterator().next());
            typeAttribute.getMetaData().putValue("isSubtaskType", Boolean.TRUE.toString());
            TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_ID.id());
            attribute.setValue(parentTaskData.getTaskId());
            attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_KEY.id());
            attribute.setValue(parentTaskData.getRoot().getAttribute(JiraAttribute.ISSUE_KEY.id()).getValue());
            return true;
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus(repository, e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        finally {
            monitor.done();
        }
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        String value = task.getAttribute("isSubtaskType");
        return value == null ? true : !Boolean.parseBoolean(value);
    }

    public static JiraIssue buildJiraIssue(TaskData taskData) {
        String labels;
        TaskAttribute affectsVersionAttr;
        TaskAttribute fixVersionAttr;
        String estimate;
        String securityLevelId;
        String parentKey;
        JiraIssue issue = new JiraIssue();
        issue.setId(taskData.getTaskId());
        issue.setKey(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ISSUE_KEY));
        issue.setSummary(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.SUMMARY));
        issue.setDescription(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.DESCRIPTION));
        issue.setDue(JiraTaskDataHandler.getDateValue(taskData, JiraAttribute.DUE_DATE));
        String parentId = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PARENT_ID);
        if (parentId != null) {
            issue.setParentId(parentId);
        }
        if ((parentKey = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PARENT_KEY)) != null) {
            issue.setParentKey(parentKey);
        }
        if ((securityLevelId = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.SECURITY_LEVEL)) != null) {
            issue.setSecurityLevel(new SecurityLevel(securityLevelId));
        }
        if ((estimate = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ESTIMATE)) != null) {
            try {
                issue.setEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((estimate = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.INITIAL_ESTIMATE)) != null) {
            try {
                issue.setInitialEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        issue.setProject(new Project(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PROJECT)));
        TaskAttribute typeAttribute = JiraTaskDataHandler.getAttribute(taskData, JiraAttribute.TYPE);
        boolean subTaskType = typeAttribute != null ? JiraTaskDataHandler.hasSubTaskType(typeAttribute) : false;
        String typeId = typeAttribute.getValue();
        String typeName = typeAttribute.getOption(typeId);
        IssueType issueType = new IssueType(typeId, typeName, subTaskType);
        issue.setType(issueType);
        issue.setStatus(new JiraStatus(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.STATUS)));
        TaskAttribute componentsAttribute = taskData.getRoot().getMappedAttribute("attribute.jira.components");
        if (componentsAttribute != null) {
            ArrayList<Object> components = new ArrayList<Object>();
            for (String value : componentsAttribute.getValues()) {
                Component component = new Component(value);
                component.setName(componentsAttribute.getOption(value));
                components.add(component);
            }
            issue.setComponents(components.toArray(new Component[components.size()]));
        }
        if ((fixVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.fixversions")) != null) {
            ArrayList<Object> fixVersions = new ArrayList<Object>();
            for (String value : fixVersionAttr.getValues()) {
                Version version = new Version(value, fixVersionAttr.getOption(value));
                fixVersions.add(version);
            }
            issue.setFixVersions(fixVersions.toArray(new Version[fixVersions.size()]));
        }
        if ((affectsVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.affectsversions")) != null) {
            ArrayList<Version> affectsVersions = new ArrayList<Version>();
            for (String value : affectsVersionAttr.getValues()) {
                Version version = new Version(value, affectsVersionAttr.getOption(value));
                affectsVersions.add(version);
            }
            issue.setReportedVersions(affectsVersions.toArray(new Version[affectsVersions.size()]));
        }
        issue.setReporter(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.USER_REPORTER));
        String assignee = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.USER_ASSIGNED);
        issue.setAssignee(JiraRepositoryConnector.getAssigneeFromAttribute(assignee));
        issue.setEnvironment(JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ENVIRONMENT));
        String priorityId = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PRIORITY);
        if (priorityId != null) {
            issue.setPriority(new Priority(priorityId));
        }
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
            if (!attribute.getId().startsWith("attribute.jira.custom::")) continue;
            String id = attribute.getId().substring("attribute.jira.custom::".length());
            String type = attribute.getMetaData().getValue("type");
            String name = attribute.getMetaData().getLabel().substring(0, attribute.getMetaData().getLabel().length() - 1);
            CustomField field = new CustomField(id, type, name, attribute.getValues());
            customFields.add(field);
        }
        issue.setCustomFields(customFields.toArray(new CustomField[customFields.size()]));
        String resolutionId = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.RESOLUTION);
        if (resolutionId != null) {
            issue.setResolution(new Resolution(resolutionId, resolutionId));
        }
        if ((labels = JiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.LABELS)) != null) {
            issue.setLabels(StringUtils.split((String)labels));
        }
        return issue;
    }

    public static boolean hasSubTaskType(TaskAttribute typeAttribute) {
        return Boolean.parseBoolean(typeAttribute.getMetaData().getValue("isSubtaskType"));
    }

    private static TaskAttribute getAttribute(TaskData taskData, JiraAttribute key) {
        return taskData.getRoot().getAttribute(key.id());
    }

    private static String getAttributeValue(TaskData taskData, JiraAttribute key) {
        TaskAttribute attribute = taskData.getRoot().getAttribute(key.id());
        return attribute != null ? attribute.getValue() : null;
    }

    private static Date getDateValue(TaskData data, JiraAttribute key) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        return attribute != null ? data.getAttributeMapper().getDateValue(attribute) : null;
    }

    private static void trace(IStatus status) {
        if (TRACE_ENABLED) {
            StatusHandler.log((IStatus)status);
        }
    }

    private static void trace(Exception e) {
        if (TRACE_ENABLED) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", "Error receiving infromation from JIRA", (Throwable)e));
        }
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        JiraClient client = this.clientFactory.getJiraClient(taskRepository);
        return new JiraAttributeMapper(taskRepository, client);
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        String taskDataVersion = taskData.getVersion();
        JiraVersion version = new JiraVersion(taskDataVersion != null ? taskDataVersion : "0.0");
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_1_0)) {
            for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
                if ("task.common.product".equals(attribute.getId())) {
                    String projectName = attribute.getValue();
                    Map options = taskData.getAttributeMapper().getOptions(attribute);
                    for (String key : options.keySet()) {
                        String value = (String)options.get(key);
                        if (projectName.equals(value)) {
                            attribute.setValue(key);
                        }
                        attribute.putOption(key, value);
                    }
                    continue;
                }
                if ("task.common.user.assigned".equals(attribute.getId())) {
                    attribute.getMetaData().setReadOnly(false);
                    continue;
                }
                Object type = JiraFieldType.fromKey(attribute.getMetaData().getValue("type"));
                if (JiraFieldType.SELECT != type && JiraFieldType.MULTISELECT != type || attribute.getOptions().isEmpty()) continue;
                HashSet values = new HashSet(attribute.getValues());
                attribute.clearValues();
                Map options = attribute.getOptions();
                for (String key : options.keySet()) {
                    if (!values.contains(options.get(key))) continue;
                    attribute.addValue(key);
                }
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_2_0)) {
            ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                if (attribute.getId().startsWith("task.common.operation-")) {
                    if (attribute.getValue().equals(REASSIGN_OPERATION)) {
                        taskData.getRoot().removeAttribute(attribute.getId());
                        continue;
                    }
                    TaskAttribute associatedAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
                    if (associatedAttribute != null && associatedAttribute.getId().equals("resolution")) {
                        TaskAttribute resolutionAttribute = taskData.getRoot().getAttribute(JiraAttribute.RESOLUTION.id());
                        if (resolutionAttribute != null) {
                            Map options = associatedAttribute.getOptions();
                            for (String key : options.keySet()) {
                                resolutionAttribute.putOption(key, (String)options.get(key));
                            }
                            resolutionAttribute.getMetaData().setType("singleSelect");
                            resolutionAttribute.getMetaData().setReadOnly(false);
                        }
                        attribute.getMetaData().putValue("task.meta.associated.attribute", JiraAttribute.RESOLUTION.id());
                        attribute.removeAttribute(associatedAttribute.getId());
                    }
                } else if (attribute.getId().equals(JiraAttribute.TYPE.id()) && attribute.getOptions().isEmpty()) {
                    IssueType[] jiraIssueTypes;
                    JiraClient client = this.clientFactory.getJiraClient(taskRepository);
                    IssueType[] issueTypeArray = jiraIssueTypes = client.getCache().getIssueTypes();
                    int n = jiraIssueTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IssueType type = issueTypeArray[n2];
                        if (attribute.getValue().equals(type.getName())) {
                            attribute.putOption(type.getId(), type.getName());
                            attribute.setValue(type.getId());
                            break;
                        }
                        ++n2;
                    }
                }
                attribute.getMetaData().setType(this.getType(attribute));
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_2_2)) {
            for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
                String value;
                JiraTimeFormat format = new JiraTimeFormat();
                if (!JiraTaskDataHandler.isTimeSpanAttribute(attribute) || (value = attribute.getValue()).length() <= 0) continue;
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        attribute.setValue(String.valueOf(format.parse(value)));
                    }
                    catch (ParseException parseException) {
                        attribute.setValue("");
                    }
                }
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_CURRENT)) {
            taskData.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        }
    }

    public static boolean isTimeSpanAttribute(TaskAttribute attribute) {
        return JiraAttribute.INITIAL_ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ACTUAL.id().equals(attribute.getId());
    }

    private String getType(TaskAttribute taskAttribute) {
        if (JiraAttribute.DESCRIPTION.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.COMMENT_NEW.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.SUMMARY.id().equals(taskAttribute.getId())) {
            return "shortRichText";
        }
        if ("task.common.operation".equals(taskAttribute.getId()) || taskAttribute.getId().startsWith("task.common.operation-")) {
            return "operation";
        }
        if (taskAttribute.getId().startsWith("task.common.comment-")) {
            return "comment";
        }
        if (taskAttribute.getId().startsWith("task.common.attachment-")) {
            return "attachment";
        }
        JiraFieldType fieldType = null;
        if (JiraAttribute.CREATION_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.DUE_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.MODIFICATION_DATE.id().equals(taskAttribute.getId())) {
            fieldType = JiraFieldType.DATE;
            taskAttribute.getMetaData().putValue("type", fieldType.getKey());
        }
        if (fieldType == null) {
            fieldType = JiraFieldType.fromKey(taskAttribute.getMetaData().getValue("type"));
        }
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        fieldType = JiraAttribute.valueById(taskAttribute.getId()).getType();
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        String existingType = taskAttribute.getMetaData().getType();
        if (existingType != null) {
            return existingType;
        }
        return "shortText";
    }

    public String mapCommonAttributeKey(String key) {
        if ("summary".equals(key)) {
            return JiraAttribute.SUMMARY.id();
        }
        if ("description".equals(key)) {
            return JiraAttribute.DESCRIPTION.id();
        }
        if ("priority".equals(key)) {
            return JiraAttribute.PRIORITY.id();
        }
        if ("resolution".equals(key)) {
            return JiraAttribute.RESOLUTION.id();
        }
        if ("assignee".equals(key)) {
            return JiraAttribute.USER_ASSIGNED.id();
        }
        if ("environment".equals(key)) {
            return JiraAttribute.ENVIRONMENT.id();
        }
        if ("issuetype".equals(key)) {
            return JiraAttribute.TYPE.id();
        }
        if ("components".equals(key)) {
            return JiraAttribute.COMPONENTS.id();
        }
        if ("versions".equals(key)) {
            return JiraAttribute.AFFECTSVERSIONS.id();
        }
        if ("fixVersions".equals(key)) {
            return JiraAttribute.FIXVERSIONS.id();
        }
        if ("timetracking".equals(key)) {
            return JiraAttribute.ESTIMATE.id();
        }
        if ("duedate".equals(key)) {
            return JiraAttribute.DUE_DATE.id();
        }
        if ("labels".equals(key)) {
            return JiraAttribute.LABELS.id();
        }
        if (key.startsWith("issueLink")) {
            return "attribute.jira.link::" + key;
        }
        if (key.startsWith("customfield")) {
            return "attribute.jira.custom::" + key;
        }
        if ("security".equals(key)) {
            return JiraAttribute.SECURITY_LEVEL.id();
        }
        return key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CommentDateComparator
    implements Comparator<Comment> {
        @Override
        public int compare(Comment o1, Comment o2) {
            if (o1 != null && o2 != null && o1.getCreated() != null && o2.getCreated() != null) {
                return o1.getCreated().compareTo(o2.getCreated());
            }
            return 0;
        }
    }
}

