/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.stacks.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.jdf.stacks.client.DefaultStacksClientConfiguration;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.client.StacksClientConfiguration;
import org.jboss.jdf.stacks.client.messages.StacksMessages;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.jdf.stacks.parser.Parser;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.jobs.BarrierProgressWaitJob;
import org.jboss.tools.stacks.core.StacksCoreActivator;
import org.jboss.tools.stacks.core.Trace;

public class StacksManager {
    private static final String STACKS_URL_PROPERTY = "org.jboss.examples.stacks.url";
    private static final String URL_PROPERTY_STACKS = "org.jboss.tools.stacks.url_stacks";
    private static final String URL_PROPERTY_PRESTACKS = "org.jboss.tools.stacks.url_prestacks";
    private static final String STACKS_URL;
    private static final String PRESTACKS_URL;
    private static final String PRESTACKS_DEFAULT_URL = "https://raw.github.com/jboss-jdf/jdf-stack/1.0.0.Final/pre-stacks.yaml";

    static {
        String defaultUrl = StacksManager.getStacksUrlFromJar();
        STACKS_URL = System.getProperty(URL_PROPERTY_STACKS, System.getProperty(STACKS_URL_PROPERTY, System.getProperty("jdf.stacks.client.repo", defaultUrl)));
        PRESTACKS_URL = System.getProperty(URL_PROPERTY_PRESTACKS, System.getProperty("jdf.prestacks.client.repo", PRESTACKS_DEFAULT_URL));
    }

    public Stacks getStacks(IProgressMonitor monitor) {
        Stacks[] all = this.getStacks("Fetching JBoss Stacks", monitor, StacksType.STACKS_TYPE);
        if (all != null && all.length > 0) {
            return all[0];
        }
        return null;
    }

    public Stacks[] getStacks(String jobName, IProgressMonitor monitor, StacksType ... types) {
        if (types == null) {
            return new Stacks[0];
        }
        Trace.trace("/finest", "Request received for " + types.length + " stacks types.");
        ArrayList<Stacks> ret = new ArrayList<Stacks>(types.length);
        monitor.beginTask(jobName, types.length * 100);
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case STACKS_TYPE: {
                    Trace.trace("/finest", "Loading Stacks Model from " + STACKS_URL);
                    Stacks s = this.getStacks(STACKS_URL, jobName, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (s == null && !monitor.isCanceled()) {
                        StacksCoreActivator.pluginLog().logWarning("Stacks from " + STACKS_URL + " can not be read, using client mechanism instead");
                        s = this.getDefaultStacksFromClient((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    ret.add(s);
                    break;
                }
                case PRESTACKS_TYPE: {
                    Trace.trace("/finest", "Loading Stacks Model from " + PRESTACKS_URL);
                    ret.add(this.getStacks(PRESTACKS_URL, jobName, (IProgressMonitor)new SubProgressMonitor(monitor, 100)));
                    break;
                }
            }
            ++i;
        }
        monitor.done();
        return ret.toArray(new Stacks[ret.size()]);
    }

    public Stacks getStacks(String url, IProgressMonitor monitor) {
        return this.getStacks(url, url, 2, monitor);
    }

    protected Stacks getStacks(String url, String jobName, IProgressMonitor monitor) {
        return this.getStacks(url, jobName, 1, monitor);
    }

    protected Stacks getStacks(String url, String jobName, int cacheType, IProgressMonitor monitor) {
        return this.getStacksFromURL(url, jobName, cacheType, monitor);
    }

    protected Stacks getStacksFromURL(String url, String jobName, int cacheType, IProgressMonitor monitor) {
        Stacks stacks = null;
        try {
            Trace.trace("/finest", "Locating or downloading file for " + url);
            File f = this.getCachedFileForURL(url, jobName, cacheType, monitor);
            return this.getStacksFromFile(f);
        }
        catch (Exception e) {
            StacksCoreActivator.pluginLog().logError("Can't access or parse  " + url, (Throwable)e);
            return stacks;
        }
    }

    protected Stacks getStacksFromFile(File f) throws IOException {
        if (f != null && f.exists()) {
            Stacks stacks;
            Trace.trace("/finest", "Local file for url exists");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                Parser p = new Parser();
                stacks = p.parse((InputStream)fis);
            }
            catch (Throwable throwable) {
                StacksManager.close(fis);
                throw throwable;
            }
            StacksManager.close(fis);
            return stacks;
        }
        return null;
    }

    private Stacks getDefaultStacksFromClient(IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            final StacksClient client = new StacksClient((StacksClientConfiguration)new DefaultStacksClientConfiguration(), (StacksMessages)new JBTStacksMessages());
            BarrierProgressWaitJob.IRunnableWithProgress barrierRunnable = new BarrierProgressWaitJob.IRunnableWithProgress(){

                public Object run(IProgressMonitor monitor) throws Exception {
                    StacksCoreActivator.pluginLog().logWarning("BarrierProgressWaitJob - loading Stacks Client values");
                    return client.getStacks();
                }
            };
            BarrierProgressWaitJob fromClientJob = new BarrierProgressWaitJob("Load stacks using stacks client", barrierRunnable);
            fromClientJob.schedule();
            fromClientJob.monitorSafeJoin(monitor);
            Throwable t = fromClientJob.getThrowable();
            Object ret = fromClientJob.getReturnValue();
            if (t != null) {
                StacksCoreActivator.pluginLog().logError(t);
            }
            return (Stacks)ret;
        }
        return null;
    }

    protected File getCachedFileForURL(String url, String jobName, IProgressMonitor monitor) throws CoreException {
        return this.getCachedFileForURL(url, jobName, 1, monitor);
    }

    protected File getCachedFileForURL(String url, String jobName, int cacheType, IProgressMonitor monitor) throws CoreException {
        return new URLTransportUtility().getCachedFileForURL(url, jobName, cacheType, monitor);
    }

    private static String getStacksUrlFromJar() {
        InputStream is = null;
        try {
            is = StacksManager.class.getResourceAsStream("/org/jboss/jdf/stacks/client/config.properties");
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty("jdf.stacks.client.repo");
            return string;
        }
        catch (Exception e) {
            StacksCoreActivator.pluginLog().logWarning("Can't read stacks url from the stacks-client.jar", (Throwable)e);
        }
        finally {
            StacksManager.close(is);
        }
        return null;
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class JBTStacksMessages
    implements StacksMessages {
        private JBTStacksMessages() {
        }

        public void showDebugMessage(String arg0) {
            Trace.trace("/finer", arg0);
        }

        public void showInfoMessage(String arg0) {
            Trace.trace("/info", arg0);
        }

        public void showErrorMessage(String arg0) {
            StacksCoreActivator.pluginLog().logError(arg0);
        }

        public void showErrorMessageWithCause(String arg0, Throwable t) {
            StacksCoreActivator.pluginLog().logError(arg0, t);
        }

        public void showWarnMessage(String arg0) {
            StacksCoreActivator.pluginLog().logWarning(arg0);
        }
    }

    public static enum StacksType {
        STACKS_TYPE,
        PRESTACKS_TYPE;

    }
}

