/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.jmx.integration.JBossServerJMXRunner;
import org.jboss.ide.eclipse.as.jmx.integration.JMXSafeRunner;
import org.jboss.tools.jmx.core.IJMXRunnable;

public class JMXPoller
implements IServerStatePoller2 {
    public static final String POLLER_ID = "org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller";
    public static final int JMXPOLLER_CODE = 0x1020000;
    public static final Properties IGNORED_PROPERTIES = new Properties();
    public static final String REQUIRED_USER = "org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_USER";
    public static final String REQUIRED_PASS = "org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_PASS";
    public static final int STATE_STARTED = 1;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_TRANSITION = 2;
    private int started;
    private boolean canceled;
    private boolean done;
    private boolean waitingForCredentials = false;
    private boolean ceFound;
    private boolean nnfeFound;
    private boolean startingFound;
    private IServer server;
    private IServerStatePollerType type;
    private IServerStatePoller.PollingException pollingException = null;
    private IServerStatePoller.RequiresInfoException requiresInfoException = null;
    private Properties requiredPropertiesReturned = null;
    private boolean expectedState;

    public void beginPolling(IServer server, boolean expectedState) throws IServerStatePoller.PollingException {
        this.done = false;
        this.canceled = false;
        this.startingFound = false;
        this.nnfeFound = false;
        this.ceFound = false;
        this.server = server;
        this.expectedState = expectedState;
        this.launchJMXPoller();
    }

    private void launchJMXPoller() {
        PollerRunnable run = new PollerRunnable();
        Thread t = new Thread((Runnable)run, Messages.JMXPoller);
        t.start();
    }

    public void cancel(int type) {
        this.canceled = true;
    }

    public void cleanup() {
    }

    public boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.pollingException != null) {
            throw this.pollingException;
        }
        if (this.requiresInfoException != null) {
            throw this.requiresInfoException;
        }
        if (this.started == 0) {
            return false;
        }
        if (this.started == 1) {
            return true;
        }
        return this.done || this.canceled;
    }

    public boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.pollingException != null) {
            throw this.pollingException;
        }
        if (this.requiresInfoException != null) {
            throw this.requiresInfoException;
        }
        return this.done;
    }

    public void provideCredentials(Properties properties) {
        this.requiredPropertiesReturned = properties == null ? IGNORED_PROPERTIES : properties;
    }

    public List<String> getRequiredProperties() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(REQUIRED_USER);
        list.add(REQUIRED_PASS);
        return list;
    }

    public IServerStatePollerType getPollerType() {
        return this.type;
    }

    public void setPollerType(IServerStatePollerType type) {
        this.type = type;
    }

    public IServer getServer() {
        return this.server;
    }

    public int getTimeoutBehavior() {
        return 0;
    }

    private void log(IStatus s) {
        if (!this.canceled) {
            ServerLogger.getDefault().log(this.server, s);
        }
    }

    public IStatus getCurrentStateSynchronous(IServer server) {
        JBossServerJMXRunner runner = new JBossServerJMXRunner();
        runner.beginTransaction(server, this);
        JMXPollerRunnable runnable2 = new JMXPollerRunnable();
        try {
            int started2;
            runner.run(server, runnable2);
            int n = started2 = runnable2.result ? 1 : 2;
            if (started2 == 1) {
                Status s;
                Status status = s = new Status(0, "org.jboss.ide.eclipse.as.jmx.integration", "JMX Poller found a running server on " + server.getHost());
                return status;
            }
        }
        catch (CoreException coreException) {
        }
        finally {
            runner.endTransaction(server, this);
        }
        Status s = new Status(1, "org.jboss.ide.eclipse.as.jmx.integration", "JMX Poller did not find a running server on " + server.getHost());
        return s;
    }

    private static class JMXPollerRunnable
    implements IJMXRunnable,
    ExtensionManager.IServerJMXRunnable {
        private boolean result;

        private JMXPollerRunnable() {
        }

        public void run(MBeanServerConnection connection) throws Exception {
            Object attInfo = connection.getAttribute(new ObjectName("jboss.system:type=Server"), "Started");
            this.result = (Boolean)attInfo;
        }
    }

    private class PollerRunnable
    implements Runnable {
        private PollerRunnable() {
        }

        @Override
        public void run() {
            JBossServerJMXRunner runner2 = new JBossServerJMXRunner();
            runner2.beginTransaction(JMXPoller.this.server, this);
            JMXPollerRunnable runnable = new JMXPollerRunnable();
            JMXSafeRunner runner = new JMXSafeRunner(JMXPoller.this.server);
            while (!JMXPoller.this.done && !JMXPoller.this.canceled) {
                CoreException coreCe = null;
                try {
                    runner.run(runnable);
                    JMXPoller.this.started = runnable.result ? 1 : 2;
                }
                catch (CoreException ce) {
                    coreCe = ce;
                }
                if (JMXPoller.this.expectedState) {
                    this.handleStartupLogging(coreCe, runner);
                } else {
                    this.handleShutdownLogging(coreCe, runner);
                }
                JMXPoller.this.done = JMXPoller.this.started == 1 && JMXPoller.this.expectedState || JMXPoller.this.started == 0 && !JMXPoller.this.expectedState;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            runner2.endTransaction(JMXPoller.this.server, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCredentialRequest(Throwable t, JMXSafeRunner runner) {
            PollerRunnable pollerRunnable = this;
            synchronized (pollerRunnable) {
                if (!JMXPoller.this.waitingForCredentials) {
                    JMXPoller.this.waitingForCredentials = true;
                    JMXPoller.this.requiresInfoException = new PollingSecurityException(NLS.bind((String)Messages.securityException, (Object)t.getMessage()));
                } else if (JMXPoller.this.requiredPropertiesReturned != null) {
                    if (JMXPoller.this.requiredPropertiesReturned == IGNORED_PROPERTIES) {
                        JMXPoller.this.requiresInfoException = null;
                        JMXPoller.this.done = true;
                        JMXPoller.this.started = 1;
                    } else {
                        JMXPoller.this.requiresInfoException = null;
                        String user = (String)JMXPoller.this.requiredPropertiesReturned.get(JMXPoller.REQUIRED_USER);
                        String pass = (String)JMXPoller.this.requiredPropertiesReturned.get(JMXPoller.REQUIRED_PASS);
                        JMXPoller.this.requiredPropertiesReturned = null;
                        runner.setUser(user);
                        runner.setPass(pass);
                        JMXPoller.this.waitingForCredentials = false;
                    }
                }
            }
        }

        protected void handleShutdownLogging(Throwable t, JMXSafeRunner runner) {
            if (t == null || t.getCause() == null) {
                return;
            }
            Throwable cause = t.getCause();
            if (cause instanceof SecurityException) {
                this.handleCredentialRequest(cause, runner);
                return;
            }
            if (cause instanceof CommunicationException) {
                JMXPoller.this.started = 0;
                return;
            }
            if (cause instanceof NamingException) {
                JMXPoller.this.started = 2;
                return;
            }
            if (cause instanceof IllegalArgumentException) {
                JMXPoller.this.started = 2;
                return;
            }
            if (cause != null) {
                JMXPoller.this.pollingException = new IServerStatePoller.PollingException(cause.getMessage());
                JMXPoller.this.done = true;
            }
        }

        protected void handleStartupLogging(Throwable t, JMXSafeRunner runner) {
            if (t == null && JMXPoller.this.expectedState && !JMXPoller.this.startingFound) {
                JMXPoller.this.startingFound = true;
                Status s = new Status(1, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, Messages.ServerStarting, null);
                JMXPoller.this.log((IStatus)s);
            }
            if (t == null || t.getCause() == null) {
                return;
            }
            Throwable cause = t.getCause();
            if (cause instanceof SecurityException) {
                this.handleCredentialRequest(cause, runner);
                return;
            }
            if (cause instanceof CommunicationException) {
                JMXPoller.this.started = 0;
                if (!JMXPoller.this.ceFound) {
                    JMXPoller.this.ceFound = true;
                    Status s = new Status(2, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, cause.getMessage(), cause);
                    JMXPoller.this.log((IStatus)s);
                }
                return;
            }
            if (cause instanceof NamingException) {
                JMXPoller.this.started = 2;
                if (!JMXPoller.this.nnfeFound) {
                    JMXPoller.this.nnfeFound = true;
                    Status s = new Status(2, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, cause.getMessage(), cause);
                    JMXPoller.this.log((IStatus)s);
                }
                return;
            }
            if (cause != null) {
                JMXPoller.this.pollingException = new IServerStatePoller.PollingException(cause.getMessage());
                JMXPoller.this.done = true;
            }
        }
    }

    public class PollingSecurityException
    extends IServerStatePoller.RequiresInfoException {
        private static final long serialVersionUID = 1L;

        public PollingSecurityException(String msg) {
            super(msg);
        }
    }
}

