/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IHost;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModel;

public class JBossJVMFacadeUtility {
    public static IActiveJvm findJvmForServer(IServer server) {
        String progArgs = null;
        String main = null;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null && server.getServerState() == 2) {
            try {
                Object o = beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
                if (o instanceof IProcess) {
                    IProcess proc = (IProcess)o;
                    ILaunch launch = proc.getLaunch();
                    ILaunchConfiguration lc = launch.getLaunchConfiguration();
                    progArgs = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
                    main = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        String target = String.valueOf(main) + " " + progArgs;
        target = target.replaceAll("\"", "").trim();
        System.out.println(target);
        JvmModel model = JvmModel.getInstance();
        List hosts = model.getHosts();
        for (IHost host : hosts) {
            host.getName();
            List jvms = host.getActiveJvms();
            for (IActiveJvm jvm : jvms) {
                jvm.getPid();
                String command = jvm.getLaunchCommand();
                System.out.println(command);
                if (!command.equals(target)) continue;
                System.out.println("FOUND");
                return jvm;
            }
        }
        return null;
    }
}

