/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static int GTKCLIPBOARD = OS.gtk_clipboard_get(0);
    static int GTKPRIMARYCLIPBOARD;
    private static int TARGET;

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "PRIMARY", true);
        int primary = OS.gdk_atom_intern(buffer, false);
        GTKPRIMARYCLIPBOARD = OS.gtk_clipboard_get(primary);
        buffer = Converter.wcsToMbcs(null, "TARGETS", true);
        TARGET = OS.gdk_atom_intern(buffer, false);
    }

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        proxy.clear(this, clipboards);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        int selection_data = 0;
        int[] typeIds = transfer.getTypeIds();
        int i = 0;
        while (i < typeIds.length) {
            if ((clipboards & 1) != 0) {
                selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, typeIds[i]);
                OS.gdk_threads_leave();
            }
            if (selection_data != 0) break;
            if ((clipboards & 2) != 0) {
                selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, typeIds[i]);
                OS.gdk_threads_leave();
            }
            ++i;
        }
        if (selection_data == 0) {
            return null;
        }
        TransferData tdata = new TransferData();
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            tdata.type = OS.gtk_selection_data_get_data_type(selection_data);
            tdata.pValue = OS.gtk_selection_data_get_data(selection_data);
            tdata.length = OS.gtk_selection_data_get_length(selection_data);
            tdata.format = OS.gtk_selection_data_get_format(selection_data);
        } else {
            GtkSelectionData gtkSelectionData = new GtkSelectionData();
            OS.memmove(gtkSelectionData, selection_data, GtkSelectionData.sizeof);
            tdata.type = gtkSelectionData.type;
            tdata.pValue = gtkSelectionData.data;
            tdata.length = gtkSelectionData.length;
            tdata.format = gtkSelectionData.format;
        }
        Object result = transfer.nativeToJava(tdata);
        OS.gtk_selection_data_free(selection_data);
        return result;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        if (!proxy.setData(this, data, dataTypes, clipboards)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        int[] types;
        this.checkWidget();
        TransferData[] result = null;
        if ((clipboards & 1) != 0) {
            types = this.getAvailableClipboardTypes();
            result = new TransferData[types.length];
            int i = 0;
            while (i < types.length) {
                result[i] = new TransferData();
                result[i].type = types[i];
                ++i;
            }
        }
        if ((clipboards & 2) != 0) {
            types = this.getAvailablePrimaryTypes();
            int offset = 0;
            if (result != null) {
                TransferData[] newResult = new TransferData[result.length + types.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                offset = result.length;
                result = newResult;
            } else {
                result = new TransferData[types.length];
            }
            int i = 0;
            while (i < types.length) {
                result[offset + i] = new TransferData();
                result[offset + i].type = types[i];
                ++i;
            }
        }
        return result == null ? new TransferData[]{} : result;
    }

    public String[] getAvailableTypeNames() {
        byte[] buffer;
        int pName;
        this.checkWidget();
        int[] types1 = this.getAvailableClipboardTypes();
        int[] types2 = this.getAvailablePrimaryTypes();
        String[] result = new String[types1.length + types2.length];
        int count = 0;
        int i = 0;
        while (i < types1.length) {
            pName = OS.gdk_atom_name(types1[i]);
            if (pName != 0) {
                buffer = new byte[OS.strlen(pName)];
                OS.memmove(buffer, pName, buffer.length);
                OS.g_free(pName);
                result[count++] = "GTKCLIPBOARD " + new String(Converter.mbcsToWcs(null, buffer));
            }
            ++i;
        }
        i = 0;
        while (i < types2.length) {
            pName = OS.gdk_atom_name(types2[i]);
            if (pName != 0) {
                buffer = new byte[OS.strlen(pName)];
                OS.memmove(buffer, pName, buffer.length);
                OS.g_free(pName);
                result[count++] = "GTKPRIMARYCLIPBOARD " + new String(Converter.mbcsToWcs(null, buffer));
            }
            ++i;
        }
        if (count < result.length) {
            String[] temp = new String[count];
            System.arraycopy(result, 0, temp, 0, count);
            result = temp;
        }
        return result;
    }

    private int[] getAvailablePrimaryTypes() {
        int[] types = new int[]{};
        int selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, TARGET);
        OS.gdk_threads_leave();
        if (selection_data != 0) {
            try {
                int data;
                int format;
                int length;
                if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                    length = OS.gtk_selection_data_get_length(selection_data);
                    format = OS.gtk_selection_data_get_format(selection_data);
                    data = OS.gtk_selection_data_get_data(selection_data);
                } else {
                    GtkSelectionData gtkSelectionData = new GtkSelectionData();
                    OS.memmove(gtkSelectionData, selection_data, GtkSelectionData.sizeof);
                    length = gtkSelectionData.length;
                    format = gtkSelectionData.format;
                    data = gtkSelectionData.data;
                }
                if (length != 0) {
                    types = new int[length * 8 / format];
                    OS.memmove(types, data, length);
                }
            }
            finally {
                OS.gtk_selection_data_free(selection_data);
            }
        }
        return types;
    }

    private int[] getAvailableClipboardTypes() {
        int[] types = new int[]{};
        int selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, TARGET);
        OS.gdk_threads_leave();
        if (selection_data != 0) {
            try {
                int data;
                int format;
                int length;
                if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                    length = OS.gtk_selection_data_get_length(selection_data);
                    format = OS.gtk_selection_data_get_format(selection_data);
                    data = OS.gtk_selection_data_get_data(selection_data);
                } else {
                    GtkSelectionData gtkSelectionData = new GtkSelectionData();
                    OS.memmove(gtkSelectionData, selection_data, GtkSelectionData.sizeof);
                    length = gtkSelectionData.length;
                    format = gtkSelectionData.format;
                    data = gtkSelectionData.data;
                }
                if (length != 0) {
                    types = new int[length * 8 / format];
                    OS.memmove(types, data, length);
                }
            }
            finally {
                OS.gtk_selection_data_free(selection_data);
            }
        }
        return types;
    }

    int gtk_clipboard_wait_for_contents(int clipboard, int target) {
        String key = "org.eclipse.swt.internal.gtk.dispatchEvent";
        Display display = this.display;
        display.setData(key, new int[]{16, 17, 18, 19});
        int selection_data = OS.gtk_clipboard_wait_for_contents(clipboard, target);
        display.setData(key, null);
        return selection_data;
    }
}

