/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeManager;
import org.jboss.tools.esb.project.ui.ESBProjectPlugin;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.preference.controls.JBossRuntimeListFieldEditor;

public class ESBFacetInstallationPage
extends AbstractFacetWizardPage
implements IFacetWizardPage,
IJBossESBFacetDataModelProperties {
    private Label contextRootLabel;
    private Text contentFolder;
    private IDataModel model;
    private boolean hasValidContentFolder = true;
    private boolean hasValidSrc = true;
    private boolean hasRuntime = false;
    private Combo cmbRuntimes;
    private Button btnUserSupplied;
    private Button btnServerSupplied;
    private Button btnNew;
    private Combo cmbConfigVersions;
    private IFacetedProjectListener fpListerner;
    private IFacetedProjectWorkingCopy fpwc;

    public ESBFacetInstallationPage() {
        super("esb.facet.install.page");
        this.setTitle(JBossESBUIMessages.ESBFacetInstallationPage_Title);
        this.setDescription(JBossESBUIMessages.ESBFacetInstallationPage_Description);
    }

    private void setDefaultOutputFolder() {
        JavaFacetInstallConfig cfg = this.findJavaFacetInstallConfig();
        if (cfg != null) {
            cfg.setDefaultOutputFolder((IPath)new Path("build/classes"));
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createProjectGroup(composite);
        this.createRuntimeGroup(composite);
        this.createConfigVersionGroup(composite);
        this.setPageComplete(false);
        this.setDefaultOutputFolder();
        Dialog.applyDialogFont((Control)parent);
        this.fpwc = this.getFacetedProjectWorkingCopy();
        if (this.fpListerner == null) {
            this.fpListerner = new IFacetedProjectListener(){

                public void handleEvent(IFacetedProjectEvent event) {
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
                    final IProjectFacetVersion version = ESBFacetInstallationPage.this.fpwc.getProjectFacetVersion(facet);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (version != null) {
                                ESBFacetInstallationPage.this.initializeRuntimesCombo(ESBFacetInstallationPage.this.cmbRuntimes, null, version.getVersionString());
                                ESBFacetInstallationPage.this.initializeConfigVersionCombo(ESBFacetInstallationPage.this.cmbConfigVersions, null, version.getVersionString());
                            } else {
                                ESBFacetInstallationPage.this.initializeRuntimesCombo(ESBFacetInstallationPage.this.cmbRuntimes, null);
                                ESBFacetInstallationPage.this.initializeConfigVersionCombo(ESBFacetInstallationPage.this.cmbConfigVersions, null);
                            }
                            ESBFacetInstallationPage.this.changePageStatus();
                        }
                    });
                }
            };
        }
        if (this.fpwc != null) {
            this.fpwc.addListener(this.fpListerner, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
        }
        this.changePageStatus();
        return composite;
    }

    private void createProjectGroup(Composite parent) {
        Group prjGroup = new Group(parent, 0);
        prjGroup.setText(JBossESBUIMessages.ESBFacetInstallationPage_Group_Text_Folder);
        prjGroup.setLayout((Layout)new GridLayout(1, false));
        prjGroup.setLayoutData((Object)new GridData(768));
        this.contextRootLabel = new Label((Composite)prjGroup, 0);
        this.contextRootLabel.setText(JBossESBUIMessages.ESBFacetInstallationPage_Label_Content_Directory);
        this.contextRootLabel.setLayoutData((Object)new GridData(768));
        this.contentFolder = new Text((Composite)prjGroup, 2048);
        this.contentFolder.setLayoutData((Object)new GridData(768));
        this.contentFolder.setData("label", (Object)this.contextRootLabel);
        this.contentFolder.setText(this.model.getStringProperty("JBoss.Project.Content_Folder"));
        this.contentFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String content = ESBFacetInstallationPage.this.contentFolder.getText();
                if (content != null && !content.equals("")) {
                    ESBFacetInstallationPage.this.model.setProperty("JBoss.Project.Content_Folder", (Object)content);
                }
                ESBFacetInstallationPage.this.changePageStatus();
            }
        });
    }

    private IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        Object obj = this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (obj instanceof IFacetedProjectWorkingCopy) {
            return (IFacetedProjectWorkingCopy)obj;
        }
        return null;
    }

    private JavaFacetInstallConfig findJavaFacetInstallConfig() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc != null) {
            IFacetedProject.Action javaInstallAction = fpjwc.getProjectFacetAction(JavaFacetUtils.JAVA_FACET);
            if (javaInstallAction == null) {
                return null;
            }
            Object config = javaInstallAction.getConfig();
            if (config instanceof JavaFacetInstallConfig) {
                return (JavaFacetInstallConfig)config;
            }
            return (JavaFacetInstallConfig)Platform.getAdapterManager().getAdapter(config, JavaFacetInstallConfig.class);
        }
        return null;
    }

    private void createRuntimeGroup(Composite parent) {
        Group runtimeGroup = new Group(parent, 0);
        runtimeGroup.setText(JBossESBUIMessages.ESBFacetInstallationPage_Group_Runtime_Text);
        runtimeGroup.setLayout((Layout)new GridLayout(3, false));
        runtimeGroup.setLayoutData((Object)new GridData(768));
        this.btnServerSupplied = new Button((Composite)runtimeGroup, 16);
        this.btnServerSupplied.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ESBFacetInstallationPage.this.setServerSuppliedSelection((EventObject)e);
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.btnServerSupplied.setLayoutData((Object)gd);
        Label lblServerSupplied = new Label((Composite)runtimeGroup, 0);
        lblServerSupplied.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ESBFacetInstallationPage.this.btnServerSupplied.setSelection(true);
                ESBFacetInstallationPage.this.setServerSuppliedSelection((EventObject)e);
            }
        });
        lblServerSupplied.setText(JBossESBUIMessages.ESBFacetInstallationPage_Label_Server_Supplied_Runtime);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        lblServerSupplied.setLayoutData((Object)gd);
        this.btnUserSupplied = new Button((Composite)runtimeGroup, 16);
        this.btnUserSupplied.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ESBFacetInstallationPage.this.setUserSuppliedSelection((EventObject)e);
            }
        });
        this.cmbRuntimes = new Combo((Composite)runtimeGroup, 8);
        this.cmbRuntimes.setLayoutData((Object)new GridData(768));
        this.cmbRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String runtimeName = ESBFacetInstallationPage.this.cmbRuntimes.getText();
                JBossESBRuntime jr = (JBossESBRuntime)ESBFacetInstallationPage.this.cmbRuntimes.getData(runtimeName);
                ESBFacetInstallationPage.this.saveJBossESBRuntimeToModel(jr);
                ESBFacetInstallationPage.this.changePageStatus();
            }
        });
        this.initializeRuntimesCombo(this.cmbRuntimes, null);
        this.btnNew = new Button((Composite)runtimeGroup, 0);
        this.btnNew.setText(JBossESBUIMessages.ESBFacetInstallationPage_Button_Text_New);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ESBFacetInstallationPage.this.newJBossRuntime();
                ESBFacetInstallationPage.this.changePageStatus();
            }
        });
        if ("".equals(this.cmbRuntimes.getText())) {
            this.hasRuntime = false;
        }
        this.btnServerSupplied.setSelection(true);
        this.enableUserSupplied(false);
    }

    protected void setServerSuppliedSelection(EventObject e) {
        this.btnServerSupplied.setSelection(true);
        this.btnUserSupplied.setSelection(false);
        this.model.setBooleanProperty("jboss.is.server.supplied", true);
        this.model.setStringProperty("jboss.runtime_id", null);
        this.model.setStringProperty("jboss.runtime.home", null);
        this.enableUserSupplied(false);
        this.changePageStatus();
    }

    protected void setUserSuppliedSelection(EventObject e) {
        JBossESBRuntime jbRuntime;
        this.btnServerSupplied.setSelection(false);
        this.btnUserSupplied.setSelection(true);
        this.model.setBooleanProperty("jboss.is.server.supplied", false);
        String runtimename = this.cmbRuntimes.getText();
        if (runtimename == null || runtimename.equals("")) {
            this.hasRuntime = false;
        }
        if ((jbRuntime = JBossRuntimeManager.getInstance().findRuntimeByName(runtimename)) != null) {
            this.saveJBossESBRuntimeToModel(jbRuntime);
        }
        this.enableUserSupplied(true);
        this.changePageStatus();
    }

    private boolean checkServerSuppliedESBRuntime() {
        block9: {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
            block10: {
                block7: {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2;
                    block8: {
                        try {
                            IFacetedProjectWorkingCopy ifpwc = this.getFacetedProjectWorkingCopy();
                            if (ifpwc == null) break block7;
                            runtime2 = ifpwc.getPrimaryRuntime();
                            if (runtime2 != null) break block8;
                            this.setMessage(JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_Have_Not_Set_Target_Runtime, 2);
                            this.hasRuntime = true;
                            this.setPageComplete(this.isPageComplete());
                            return false;
                        }
                        catch (CoreException e) {
                            ESBProjectPlugin.getDefault().getLog().log(e.getStatus());
                            return false;
                        }
                    }
                    IRuntime serverRuntime = ServerCore.findRuntime((String)runtime2.getProperty("id"));
                    IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)serverRuntime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                    if (!JBossRuntimeManager.isValidESBServer((String)serverRuntime.getLocation().toOSString(), (String)this.getSelectedESBVersion().getVersionString(), (String)jbossRuntime.getJBossConfiguration())) {
                        this.hasRuntime = true;
                        this.setMessage(NLS.bind((String)JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_Invalid_ESB_Runtime, (Object)this.getSelectedESBVersion().getVersionString()), 2);
                        this.setPageComplete(this.isPageComplete());
                        return true;
                    }
                }
                String prjname = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjname);
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                if (fp == null) break block9;
                runtime = fp.getPrimaryRuntime();
                if (runtime != null) break block10;
                this.setErrorMessage(JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_No_Target_Runtime);
                this.hasRuntime = false;
                this.setPageComplete(this.isPageComplete());
                return false;
            }
            IRuntime serverRuntime = ServerCore.findRuntime((String)runtime.getProperty("id"));
            IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)serverRuntime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (!JBossRuntimeManager.isValidESBServer((String)serverRuntime.getLocation().toOSString(), (String)this.getSelectedESBVersion().getVersionString(), (String)jbossRuntime.getJBossConfiguration())) {
                this.setMessage(NLS.bind((String)JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_Invalid_ESB_Runtime, (Object)this.getSelectedESBVersion().getVersionString()), 2);
                this.hasRuntime = true;
                this.setPageComplete(this.isPageComplete());
                return true;
            }
        }
        this.setMessage(null);
        return true;
    }

    private void enableUserSupplied(boolean enabled) {
        this.cmbRuntimes.setEnabled(enabled);
        this.btnNew.setEnabled(enabled);
    }

    protected void newJBossRuntime() {
        ArrayList<JBossESBRuntime> exists = new ArrayList<JBossESBRuntime>(Arrays.asList(JBossRuntimeManager.getInstance().getRuntimes()));
        ArrayList added = new ArrayList();
        JBossRuntimeListFieldEditor.JBossRuntimeNewWizard newRtwizard = new JBossRuntimeListFieldEditor.JBossRuntimeNewWizard(exists, added){

            public boolean performFinish() {
                JBossESBRuntime rt = this.getRuntime();
                rt.setDefault(true);
                JBossRuntimeManager.getInstance().addRuntime(rt);
                JBossRuntimeManager.getInstance().save();
                return true;
            }
        };
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newRtwizard);
        if (dialog.open() == 0) {
            this.initializeRuntimesCombo(this.cmbRuntimes, null);
        }
    }

    protected void initializeRuntimesCombo(Combo cmRuntime, String runtimeName, String version) {
        JBossESBRuntime selectedJbRuntime = null;
        JBossESBRuntime defaultJbws = null;
        int selectIndex = 0;
        int defaultIndex = 0;
        cmRuntime.removeAll();
        if (runtimeName == null || "".equals(runtimeName)) {
            runtimeName = this.model.getStringProperty("jboss.runtime_id");
        }
        JBossESBRuntime[] runtimes = JBossRuntimeManager.getInstance().findRuntimeByVersion(version);
        int i = 0;
        while (i < runtimes.length) {
            JBossESBRuntime jr = runtimes[i];
            cmRuntime.add(jr.getName());
            cmRuntime.setData(jr.getName(), (Object)jr);
            if (jr.getName().equals(runtimeName)) {
                selectedJbRuntime = jr;
                selectIndex = i;
            }
            if (jr.isDefault()) {
                defaultJbws = jr;
                defaultIndex = i;
            }
            ++i;
        }
        if (selectedJbRuntime != null) {
            cmRuntime.select(selectIndex);
            if (this.btnUserSupplied.getSelection()) {
                this.saveJBossESBRuntimeToModel(selectedJbRuntime);
            }
        } else if (defaultJbws != null) {
            cmRuntime.select(defaultIndex);
            if (this.btnUserSupplied.getSelection()) {
                this.saveJBossESBRuntimeToModel(defaultJbws);
            }
        }
    }

    protected void initializeRuntimesCombo(Combo cmRuntime, String runtimeName) {
        IProjectFacetVersion version = this.getSelectedESBVersion();
        if (version != null) {
            this.initializeRuntimesCombo(this.cmbRuntimes, null, version.getVersionString());
        } else {
            this.initializeRuntimesCombo(this.cmbRuntimes, null, "");
        }
    }

    private IProjectFacetVersion getSelectedESBVersion() {
        IFacetedProjectWorkingCopy fpwc = this.getFacetedProjectWorkingCopy();
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
        if (fpwc != null) {
            return fpwc.getProjectFacetVersion(facet);
        }
        return null;
    }

    protected void saveJBossESBRuntimeToModel(JBossESBRuntime jbws) {
        if (jbws != null) {
            this.model.setStringProperty("jboss.runtime.home", jbws.getHomeDir());
            this.model.setStringProperty("jboss.runtime_id", jbws.getName());
            this.hasRuntime = true;
        } else {
            this.model.setStringProperty("jboss.runtime_id", null);
            this.model.setStringProperty("jboss.runtime.home", null);
            this.hasRuntime = false;
        }
    }

    private void changePageStatus() {
        if (!this.validFolderName(this.contentFolder.getText())) {
            this.setErrorMessage(JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_Specify_Content_Folder);
            this.hasValidContentFolder = false;
            this.setPageComplete(this.isPageComplete());
        } else if (this.btnUserSupplied.getSelection() && !this.hasRuntime) {
            this.setErrorMessage(JBossESBUIMessages.ESBFacetInstallationPage_Error_Message_Specify_ESB_Runtime);
            this.setPageComplete(this.isPageComplete());
        } else {
            if (this.btnServerSupplied.getSelection() && !this.checkServerSuppliedESBRuntime()) {
                this.setErrorMessage(null);
                return;
            }
            this.setErrorMessage(null);
            if (this.btnUserSupplied.getSelection()) {
                this.setMessage(null);
            }
            this.hasRuntime = true;
            this.hasValidSrc = true;
            this.hasValidContentFolder = true;
            this.setPageComplete(this.isPageComplete());
        }
    }

    private boolean validFolderName(String folderName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return ws.validateName(folderName, 2).isOK();
    }

    public boolean isPageComplete() {
        return this.hasValidContentFolder && this.hasValidSrc && this.hasRuntime;
    }

    public void setConfig(Object config) {
        this.model = (IDataModel)config;
    }

    public void createControl(Composite parent) {
        this.setControl((Control)this.createTopLevelComposite(parent));
    }

    public Object create() throws CoreException {
        return null;
    }

    public void dispose() {
        if (this.fpwc != null) {
            this.fpwc.removeListener(this.fpListerner);
        }
        super.dispose();
    }

    private void createConfigVersionGroup(Composite parent) {
        Group configGroup = new Group(parent, 0);
        configGroup.setText("ESB Config Version");
        configGroup.setLayout((Layout)new GridLayout(3, false));
        configGroup.setLayoutData((Object)new GridData(768));
        new GridData();
        this.cmbConfigVersions = new Combo((Composite)configGroup, 8);
        this.cmbConfigVersions.setLayoutData((Object)new GridData(768));
        this.cmbConfigVersions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String convigVersionName = ESBFacetInstallationPage.this.cmbConfigVersions.getText();
                ESBFacetInstallationPage.this.saveESBConfigVersionToModel(convigVersionName);
                ESBFacetInstallationPage.this.changePageStatus();
            }
        });
        this.initializeConfigVersionCombo(this.cmbConfigVersions, null);
    }

    protected void saveESBConfigVersionToModel(String convigVersionName) {
        this.model.setStringProperty("JBoss.Project.Config_Version", convigVersionName);
    }

    protected void initializeConfigVersionCombo(Combo cmVersions, String runtimeName) {
        IProjectFacetVersion version = this.getSelectedESBVersion();
        if (version != null) {
            this.initializeConfigVersionCombo(this.cmbConfigVersions, null, version.getVersionString());
        } else {
            this.initializeConfigVersionCombo(this.cmbConfigVersions, null, "");
        }
    }

    protected void initializeConfigVersionCombo(Combo cmVersions, String currentName, String version) {
        cmVersions.removeAll();
        cmVersions.add("1.0.1");
        double versionNumber = 0.0;
        try {
            versionNumber = Double.valueOf(version);
        }
        catch (NumberFormatException numberFormatException) {
            versionNumber = 0.0;
        }
        if (versionNumber >= 4.5) {
            cmVersions.add("1.1.0");
        }
        if (versionNumber >= 4.7) {
            cmVersions.add("1.2.0");
        }
        if (versionNumber >= 4.9 || versionNumber == 4.1) {
            cmVersions.add("1.3.0");
        }
        if (versionNumber >= 4.11) {
            cmVersions.add("1.3.1");
        }
        int index = cmVersions.getItemCount() - 1;
        String convigVersionName = cmVersions.getItem(index);
        cmVersions.select(index);
        this.saveESBConfigVersionToModel(convigVersionName);
    }
}

