/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;
import org.jboss.tools.esb.core.ESBProjectCorePlugin;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.facet.JBossClassPathCommand;
import org.jboss.tools.esb.project.ui.ESBSharedImages;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.wizards.JBossESBFacetProjectCreationDataModelProvider;
import org.jboss.tools.esb.project.ui.wizards.pages.ESBProjectFirstPage;

public class ESBProjectWizard
extends NewProjectDataModelFacetWizard
implements INewWizard {
    private IFacetedProjectWorkingCopy fpjwc;

    public ESBProjectWizard() {
        Set current = this.getFacetedProjectWorkingCopy().getProjectFacets();
        this.getFacetedProjectWorkingCopy().getPrimaryRuntime();
        this.getFacetedProjectWorkingCopy().setProjectFacets(current);
        this.setWindowTitle(JBossESBUIMessages.ESBProjectWizard_Title);
        this.setDefaultPageImageDescriptor(ESBSharedImages.getImageDescriptor(ESBSharedImages.WIZARD_NEW_PROJECT));
    }

    public ESBProjectWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(JBossESBUIMessages.ESBProjectWizard_Title);
        this.setDefaultPageImageDescriptor(ESBSharedImages.getImageDescriptor(ESBSharedImages.WIZARD_NEW_PROJECT));
    }

    protected IDataModel createDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)new JBossESBFacetProjectCreationDataModelProvider());
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        super.setFacetedProjectWorkingCopy(fpjwc);
        this.fpjwc = fpjwc;
    }

    protected IWizardPage createFirstPage() {
        return new ESBProjectFirstPage(this.model, "first.page");
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return ESBSharedImages.getImageDescriptor(ESBSharedImages.WIZARD_NEW_PROJECT);
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.jst.jboss.esb");
    }

    protected void postPerformFinish() throws InvocationTargetException {
        super.postPerformFinish();
        String prjName = this.getProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
        if (!project.exists()) {
            return;
        }
        try {
            String esbcontent = project.getPersistentProperty(IJBossESBFacetDataModelProperties.QNAME_ESB_CONTENT_FOLDER);
            IPath esbPath = new Path(esbcontent).append("META-INF");
            IFile esbFile = project.getFolder(esbPath).getFile("jboss-esb.xml");
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)esbFile);
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = fp.getPrimaryRuntime();
            if (runtime == null) {
                return;
            }
            String name = runtime.getName();
            IRuntime serverRuntime = ServerCore.findRuntime((String)name);
            RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider((IRuntimeType)serverRuntime.getRuntimeType());
            IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(serverRuntime.getId());
            JBossClassPathCommand.addClassPath((IProject)project, (IPath)serverContainerPath);
        }
        catch (CoreException e) {
            ESBProjectCorePlugin.getDefault().getLog().log(e.getStatus());
        }
    }
}

