/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.visualizer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.visualizer.FileSelectionGroup;

public class WorkbenchFileSelectionDialog
extends SelectionDialog {
    private IResource initialSelection;
    private String title;
    private String message;
    private Image image;
    private String filterPatterns;
    private IPath resultPath;
    private Label statusMessage;
    private ISelectionValidator validator;
    private FileSelectionGroup resourceGroup;

    public WorkbenchFileSelectionDialog(Shell parentShell, IPath initialSelection, String message) {
        this(parentShell, initialSelection, message, null);
    }

    public WorkbenchFileSelectionDialog(Shell parentShell, IPath initialSelection, String message, String filterPatterns) {
        super(parentShell);
        IPath initial = initialSelection;
        try {
            if (initial != null) {
                this.initialSelection = ResourcesPlugin.getWorkspace().getRoot().getFile(initial);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.title = JBossESBUIMessages.WorkbenchFileSelectionDialog_Title;
        this.message = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.filterPatterns = filterPatterns;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        if (this.image != null) {
            shell.setImage(this.image);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (WorkbenchFileSelectionDialog.this.statusMessage != null && WorkbenchFileSelectionDialog.this.validator != null) {
                    String errorMsg = WorkbenchFileSelectionDialog.this.validator.isValid((Object)WorkbenchFileSelectionDialog.this.resourceGroup.getResourceFullPath());
                    if (errorMsg == null || errorMsg.equals("")) {
                        WorkbenchFileSelectionDialog.this.statusMessage.setText("");
                        WorkbenchFileSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        WorkbenchFileSelectionDialog.this.statusMessage.setForeground(WorkbenchFileSelectionDialog.this.statusMessage.getDisplay().getSystemColor(3));
                        WorkbenchFileSelectionDialog.this.statusMessage.setText(errorMsg);
                        WorkbenchFileSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.resourceGroup = new FileSelectionGroup(dialogArea, listener, this.message, this.filterPatterns);
        this.resourceGroup.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                    IFile resultFile = (IFile)((IStructuredSelection)selection).getFirstElement();
                    WorkbenchFileSelectionDialog.this.resultPath = resultFile.getFullPath();
                    WorkbenchFileSelectionDialog.this.okPressed();
                }
            }
        });
        if (this.initialSelection != null) {
            this.resourceGroup.setSelectedResource(this.initialSelection);
        }
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        return dialogArea;
    }

    public IPath getFullPath() {
        return this.resultPath;
    }

    protected void okPressed() {
        this.resultPath = this.resourceGroup.getResourceFullPath();
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

