/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.visualizer;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.constraints.BasicEntityConstraint;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;
import org.jboss.tools.esb.project.ui.ESBProjectPlugin;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.visualizer.ESBDomParser;
import org.jboss.tools.esb.project.ui.visualizer.ESBNode;
import org.jboss.tools.esb.project.ui.visualizer.ESBNodeWithChildren;
import org.jboss.tools.esb.project.ui.visualizer.WorkbenchFileSelectionDialog;

public class ESBVisualizerView
extends ViewPart
implements IZoomableWorkbenchPart,
IShowInTarget {
    public static final String ID = "org.jboss.tools.esb.visualizer.views.ESBVisualizerView";
    private static final String ACTION_ICON_TAG = "/icons/esb/action.gif";
    private static final String SERVICE_ICON_TAG = "/icons/esb/service.gif";
    private static final String PROVIDER_ICON_TAG = "/icons/esb/provider.gif";
    private static final String BUS_ICON_TAG = "/icons/esb/bus.gif";
    private static final String PROPERTY_ICON_TAG = "/icons/esb/property.gif";
    private static final String LISTENER_ICON_TAG = "/icons/esb/listener.gif";
    private static final String ESB_FILE_ICON_TAG = "/icons/esb/esb_file.gif";
    private static final String REFRESH_ICON_TAG = "/icons/refresh.gif";
    private static final String HORIZONTAL_TREE_LAYOUT_ICON_TAG = "/icons/horizontalTreeLayout.gif";
    private static final String VERTICAL_TREE_LAYOUT_ICON_TAG = "/icons/verticalTreeLayout.gif";
    private static final String RADIAL_LAYOUT_ICON_TAG = "/icons/radialLayout.gif";
    private GraphViewer gv;
    private IFile currentFile;
    private Color defaultBorder;
    private Action openESBFileAction;
    private Action openESBFileInEditorAction;
    private Action doubleClickAction;
    private boolean doubleClickFreezesNode = false;
    private IAction horizontalLayoutAction;
    private IAction verticalLayoutAction;
    private IAction radialLayoutAction;
    private Action refreshLayoutAction;
    private ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            IFile selectedFile;
            String path;
            ESBDomParser parser;
            IStructuredSelection ssel;
            if (sourcepart != ESBVisualizerView.this && selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).getFirstElement() instanceof IFile && (parser = new ESBDomParser()).isFileESBConfig(path = (selectedFile = (IFile)ssel.getFirstElement()).getLocation().toOSString())) {
                ESBVisualizerView.this.currentFile = selectedFile;
                if (!ESBVisualizerView.this.gv.getGraphControl().isDisposed()) {
                    ESBVisualizerView.this.visualizeESB(path);
                    ESBVisualizerView.this.refreshLayoutAction.run();
                }
            }
        }
    };

    public void putMessageOnStatusLine(final String message) {
        final Display display = Display.getDefault();
        new Thread(){

            public void run() {
                display.syncExec(new Runnable(){

                    public void run() {
                        IViewSite vSite = (IViewSite)ESBVisualizerView.this.getSite();
                        IActionBars actionBars = vSite.getActionBars();
                        if (actionBars == null) {
                            return;
                        }
                        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
                        if (statusLineManager == null) {
                            return;
                        }
                        statusLineManager.setMessage(message);
                    }
                });
            }
        }.start();
    }

    public void createPartControl(Composite parent) {
        this.gv = new GraphViewer(parent, 0);
        this.gv.getGraphControl().addConstraintAdapter((ConstraintAdapter)new ESBViewerConstraintAdapter());
        this.gv.addDoubleClickListener((IDoubleClickListener)new FixNodeDoubleClickListener());
        this.gv.getGraphControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List listSelection = ((Graph)e.widget).getSelection();
                if (!listSelection.isEmpty() && listSelection.get(0) instanceof GraphNode) {
                    GraphNode node = (GraphNode)listSelection.get(0);
                    if (node.getData() != null && node.getData() instanceof ESBNode) {
                        ESBNode esbnode = (ESBNode)node.getData();
                        String modelpath = "";
                        while (esbnode != null && esbnode.getParent() != null) {
                            if (modelpath.trim().length() > 0) {
                                modelpath = "->" + modelpath;
                            }
                            modelpath = String.valueOf(esbnode.getName()) + modelpath;
                            esbnode = esbnode.getParent();
                        }
                        String message = String.valueOf(ESBVisualizerView.this.currentFile.getName()) + "->" + modelpath;
                        ESBVisualizerView.this.putMessageOnStatusLine(message);
                    }
                } else {
                    ESBVisualizerView.this.putMessageOnStatusLine(null);
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.fillToolBar();
        this.setEmptyGraph();
        this.horizontalLayoutAction.setChecked(true);
        this.horizontalLayoutAction.run();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.listener);
    }

    private void clearGraph() {
        GraphNode node;
        while (this.gv.getGraphControl().getNodes().size() > 0) {
            node = (GraphNode)this.gv.getGraphControl().getNodes().remove(0);
            node.dispose();
        }
        while (this.gv.getGraphControl().getConnections().size() > 0) {
            node = (GraphConnection)this.gv.getGraphControl().getConnections().remove(0);
            node.dispose();
        }
    }

    private void setEmptyGraph() {
        this.clearGraph();
        new GraphNode((IContainer)this.gv.getGraphControl(), 2, JBossESBUIMessages.ESBVisualizerView_EmptyNodeLabel);
    }

    public void visualizeESB(String filepath) {
        ESBDomParser parser = new ESBDomParser();
        parser.parseXmlFile(filepath);
        this.clearGraph();
        ESBNodeWithChildren root = parser.getRoot();
        root.setEsbObjectType(ESBNode.ESBType.ESB);
        GraphNode rootnode = new GraphNode((IContainer)this.gv.getGraphControl(), 2, root.getName());
        rootnode.setImage(this.getImageFromPlugin(ESB_FILE_ICON_TAG));
        this.defaultBorder = rootnode.getBorderColor();
        rootnode.setData((Object)root);
        this.drawNodes(rootnode, root);
        this.drawRefs(rootnode);
        if (this.horizontalLayoutAction.isChecked()) {
            this.horizontalLayoutAction.run();
        } else if (this.verticalLayoutAction.isChecked()) {
            this.verticalLayoutAction.run();
        } else if (this.radialLayoutAction.isChecked()) {
            this.radialLayoutAction.run();
        }
    }

    private Image getImageFromPlugin(String path) {
        ImageDescriptor descriptor;
        if (ESBProjectPlugin.getDefault().getImageRegistry().get(path) == null && (descriptor = ESBProjectPlugin.getImageDescriptor(path)) != null) {
            ESBProjectPlugin.getDefault().getImageRegistry().put(path, descriptor);
            return ESBProjectPlugin.getDefault().getImageRegistry().get(path);
        }
        return ESBProjectPlugin.getDefault().getImageRegistry().get(path);
    }

    private void drawNodes(GraphNode root, ESBNodeWithChildren parent) {
        if (parent.hasChildren()) {
            int i = 0;
            while (i < parent.getChildren().length) {
                ESBNodeWithChildren tp = (ESBNodeWithChildren)parent.getChildren()[i];
                GraphNode p = new GraphNode((IContainer)this.gv.getGraphControl(), 0, tp.getName());
                if (tp.getEsbObjectType() != null) {
                    switch (tp.getEsbObjectType()) {
                        case ACTION: {
                            p.setImage(this.getImageFromPlugin(ACTION_ICON_TAG));
                            break;
                        }
                        case SERVICE: {
                            p.setImage(this.getImageFromPlugin(SERVICE_ICON_TAG));
                            break;
                        }
                        case PROVIDER: {
                            p.setImage(this.getImageFromPlugin(PROVIDER_ICON_TAG));
                            break;
                        }
                        case BUS: {
                            p.setImage(this.getImageFromPlugin(BUS_ICON_TAG));
                            break;
                        }
                        case PROPERTY: {
                            p.setImage(this.getImageFromPlugin(PROPERTY_ICON_TAG));
                            break;
                        }
                        case LISTENER: {
                            p.setImage(this.getImageFromPlugin(LISTENER_ICON_TAG));
                            break;
                        }
                        case ESB: {
                            p.setImage(this.getImageFromPlugin(ESB_FILE_ICON_TAG));
                            break;
                        }
                    }
                }
                p.setData((Object)tp);
                this.drawNodes(p, tp);
                new GraphConnection(this.gv.getGraphControl(), 8, root, p);
                ++i;
            }
        }
    }

    private void drawRefs(GraphNode root) {
        if (this.gv.getGraphControl().getGraphModel().getNodes() != null && this.gv.getGraphControl().getGraphModel().getNodes().size() > 0) {
            for (GraphNode node : this.gv.getGraphControl().getGraphModel().getNodes()) {
                GraphNode refNode;
                ESBNodeWithChildren tp;
                if (node.getData() == null || !(node.getData() instanceof ESBNodeWithChildren) || (tp = (ESBNodeWithChildren)node.getData()).getRef() == null || tp.getRef().trim().length() <= 0 || (refNode = this.findNode(tp.getRef(), root)) == null) continue;
                GraphConnection refConnection = new GraphConnection(this.gv.getGraphControl(), 2, node, refNode);
                refConnection.changeLineColor(this.gv.getGraphControl().getDisplay().getSystemColor(9));
            }
        }
    }

    private GraphNode findNode(String name, GraphNode root) {
        if (name != null && name.trim().length() > 0 && this.gv.getGraphControl().getGraphModel().getNodes() != null && this.gv.getGraphControl().getGraphModel().getNodes().size() > 0) {
            for (GraphNode node : this.gv.getGraphControl().getGraphModel().getNodes()) {
                if (!node.getText().equalsIgnoreCase(name)) continue;
                return node;
            }
        }
        return null;
    }

    public void setFocus() {
        this.gv.getGraphControl().setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ESBVisualizerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.gv.getGraphControl());
        this.gv.getGraphControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.doubleClickAction);
    }

    private void makeActions() {
        this.openESBFileInEditorAction = new OpenESBEditorAction();
        this.doubleClickAction = new DoubleClickToggleAction();
        this.refreshLayoutAction = new Action(){

            public void run() {
                if (ESBVisualizerView.this.gv != null && ESBVisualizerView.this.gv.getGraphControl().getLayoutAlgorithm() != null) {
                    ESBVisualizerView.this.gv.setLayoutAlgorithm(ESBVisualizerView.this.gv.getGraphControl().getLayoutAlgorithm(), true);
                }
            }
        };
        this.refreshLayoutAction.setText(JBossESBUIMessages.ESBVisualizerView_Refresh_Layout_Action_Label);
        this.refreshLayoutAction.setToolTipText(JBossESBUIMessages.ESBVisualizerView_Refresh_Layout_Action_Label);
        this.refreshLayoutAction.setImageDescriptor(ESBProjectPlugin.getImageDescriptor(REFRESH_ICON_TAG));
        this.openESBFileAction = new Action(){

            public void run() {
                WorkbenchFileSelectionDialog dialog = new WorkbenchFileSelectionDialog(ESBVisualizerView.this.getSite().getShell().getShell(), null, JBossESBUIMessages.ESBVisualizerView_Open_ESB_Config_Dialog_Field_Text, ".xml");
                dialog.setTitle(JBossESBUIMessages.ESBVisualizerView_Open_ESB_Config_Dialog_Title);
                dialog.setImage(ESBVisualizerView.this.getImageFromPlugin(ESBVisualizerView.ESB_FILE_ICON_TAG));
                dialog.setValidator(new ISelectionValidator(){

                    public String isValid(Object selection) {
                        if (selection instanceof IPath) {
                            IPath selectedpath = (IPath)selection;
                            ESBDomParser parser = new ESBDomParser();
                            IPath totalPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(selectedpath);
                            String path = totalPath.toOSString();
                            if (parser.isFileESBConfig(path)) {
                                return null;
                            }
                            return JBossESBUIMessages.ESBVisualizerView_Select_ESB_File_Warning;
                        }
                        if (selection == null) {
                            return JBossESBUIMessages.ESBVisualizerView_Select_ESB_File_Warning;
                        }
                        return null;
                    }
                });
                int rtn_code = dialog.open();
                if (rtn_code == 0) {
                    IPath resultPath = dialog.getFullPath();
                    IPath totalPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(resultPath);
                    IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(dialog.getFullPath().toFile().toURI());
                    if (files != null && files.length > 0) {
                        ESBVisualizerView.this.currentFile = files[0];
                    }
                    String path = totalPath.toOSString();
                    ESBVisualizerView.this.visualizeESB(path);
                }
            }
        };
        this.openESBFileAction.setText(JBossESBUIMessages.ESBVisualizerView_Open_ESB_Config_Action_Label);
        this.openESBFileAction.setToolTipText(JBossESBUIMessages.ESBVisualizerView_Open_ESB_Config_Action_Label);
        this.openESBFileAction.setImageDescriptor(ESBProjectPlugin.getImageDescriptor(ESB_FILE_ICON_TAG));
    }

    private void fillToolBar() {
        ZoomContributionViewItem toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.openESBFileAction);
        bars.getMenuManager().add((IAction)this.openESBFileInEditorAction);
        bars.getMenuManager().add((IAction)this.doubleClickAction);
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.refreshLayoutAction);
        this.horizontalLayoutAction = new LayoutAction(this.gv, (LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        this.horizontalLayoutAction.setImageDescriptor(ESBProjectPlugin.getImageDescriptor(HORIZONTAL_TREE_LAYOUT_ICON_TAG));
        this.horizontalLayoutAction.setToolTipText(JBossESBUIMessages.ESBVisualizerView_Use_Horizontal_Tree_Layout_Action_Label);
        this.horizontalLayoutAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equalsIgnoreCase("checked")) {
                    Boolean state = (Boolean)event.getNewValue();
                    if (state.equals(Boolean.TRUE)) {
                        ESBVisualizerView.this.verticalLayoutAction.setChecked(false);
                        ESBVisualizerView.this.radialLayoutAction.setChecked(false);
                    } else if (!ESBVisualizerView.this.verticalLayoutAction.isChecked() && !ESBVisualizerView.this.radialLayoutAction.isChecked()) {
                        ESBVisualizerView.this.horizontalLayoutAction.setChecked(true);
                    }
                }
            }
        });
        toolbar.add(this.horizontalLayoutAction);
        this.verticalLayoutAction = new LayoutAction(this.gv, (LayoutAlgorithm)new TreeLayoutAlgorithm(1));
        this.verticalLayoutAction.setImageDescriptor(ESBProjectPlugin.getImageDescriptor(VERTICAL_TREE_LAYOUT_ICON_TAG));
        this.verticalLayoutAction.setToolTipText(JBossESBUIMessages.ESBVisualizerView_Use_Vertical_Tree_Layout_Action_Label);
        this.verticalLayoutAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equalsIgnoreCase("checked")) {
                    Boolean state = (Boolean)event.getNewValue();
                    if (state.equals(Boolean.TRUE)) {
                        ESBVisualizerView.this.horizontalLayoutAction.setChecked(false);
                        ESBVisualizerView.this.radialLayoutAction.setChecked(false);
                    } else if (!ESBVisualizerView.this.horizontalLayoutAction.isChecked() && !ESBVisualizerView.this.radialLayoutAction.isChecked()) {
                        ESBVisualizerView.this.verticalLayoutAction.setChecked(true);
                    }
                }
            }
        });
        toolbar.add(this.verticalLayoutAction);
        this.radialLayoutAction = new LayoutAction(this.gv, (LayoutAlgorithm)new RadialLayoutAlgorithm(1));
        this.radialLayoutAction.setImageDescriptor(ESBProjectPlugin.getImageDescriptor(RADIAL_LAYOUT_ICON_TAG));
        this.radialLayoutAction.setToolTipText(JBossESBUIMessages.ESBVisualizerView_Use_Radial_Layout_Action_Label);
        this.radialLayoutAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equalsIgnoreCase("checked")) {
                    Boolean state = (Boolean)event.getNewValue();
                    if (state.equals(Boolean.TRUE)) {
                        ESBVisualizerView.this.horizontalLayoutAction.setChecked(false);
                        ESBVisualizerView.this.verticalLayoutAction.setChecked(false);
                    } else if (!ESBVisualizerView.this.horizontalLayoutAction.isChecked() && !ESBVisualizerView.this.verticalLayoutAction.isChecked()) {
                        ESBVisualizerView.this.radialLayoutAction.setChecked(true);
                    }
                }
            }
        });
        toolbar.add(this.radialLayoutAction);
        toolbar.add((IContributionItem)toolbarZoomContributionViewItem);
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.gv;
    }

    private void openESBAction() {
        if (this.currentFile != null) {
            GraphNode node;
            Graph graph = this.gv.getGraphControl();
            String modelpath = "";
            if (!graph.getSelection().isEmpty() && (node = (GraphNode)graph.getSelection().get(0)).getData() != null && node.getData() instanceof ESBNode) {
                ESBNode esbnode = (ESBNode)node.getData();
                while (esbnode != null && esbnode.getParent() != null) {
                    if (modelpath.trim().length() > 0) {
                        modelpath = "/" + modelpath;
                    }
                    modelpath = String.valueOf(esbnode.getName()) + modelpath;
                    esbnode = esbnode.getParent();
                }
                modelpath = "FileSystems/" + this.currentFile.getProject().getName() + "/" + this.currentFile.getProjectRelativePath().toString() + "/" + modelpath;
                IWorkbenchPage page = this.getSite().getPage();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", modelpath);
                map.put("tab", "Tree");
                map.put("org.eclipse.ui.editorID", "org.jboss.tools.common.model.ui.editor.EditorPartWrapper");
                try {
                    IMarker marker = this.currentFile.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttributes(map);
                    IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection ss;
        Object first;
        if (this.gv == null || context == null) {
            return false;
        }
        ISelection sel = context.getSelection();
        if (sel instanceof IStructuredSelection && (first = (ss = (IStructuredSelection)sel).getFirstElement()) instanceof IFile) {
            ESBDomParser parser = new ESBDomParser();
            String path = ((IFile)first).getLocation().toOSString();
            if (parser.isFileESBConfig(path)) {
                this.currentFile = (IFile)first;
                this.visualizeESB(path);
                return true;
            }
            return false;
        }
        return false;
    }

    private class DoubleClickToggleAction
    extends Action {
        public DoubleClickToggleAction() {
            super(JBossESBUIMessages.ESBVisualizerView_DoubleClick_Toggle_Action_label);
            this.setChecked(ESBVisualizerView.this.doubleClickFreezesNode);
        }

        public void run() {
            ESBVisualizerView.this.doubleClickFreezesNode = !ESBVisualizerView.this.doubleClickFreezesNode;
            this.setChecked(ESBVisualizerView.this.doubleClickFreezesNode);
        }
    }

    private class ESBViewerConstraintAdapter
    implements ConstraintAdapter {
        private ESBViewerConstraintAdapter() {
        }

        public void populateConstraint(Object object, LayoutConstraint constraint) {
            if (constraint instanceof BasicEntityConstraint) {
                BasicEntityConstraint basicEntityConstraint = (BasicEntityConstraint)constraint;
                GraphNode graphnode = (GraphNode)object;
                Object data = graphnode.getData();
                if (data != null && data instanceof ESBNode) {
                    boolean wasMoved;
                    basicEntityConstraint.hasPreferredLocation = wasMoved = ((ESBNode)data).isMovementLocked();
                }
            }
        }
    }

    private class FixNodeDoubleClickListener
    implements IDoubleClickListener {
        private FixNodeDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent e) {
            GraphNode node;
            Graph graph;
            if (e.getSource() instanceof GraphViewer && !(graph = ((GraphViewer)e.getSource()).getGraphControl()).getSelection().isEmpty() && (node = (GraphNode)graph.getSelection().get(0)).getData() != null && node.getData() instanceof ESBNode) {
                if (ESBVisualizerView.this.doubleClickFreezesNode) {
                    ESBNode to;
                    to.setIsMovementLocked(!(to = (ESBNode)node.getData()).isMovementLocked());
                    if (to.isMovementLocked()) {
                        node.setBorderWidth(3);
                        node.setBorderColor(ESBVisualizerView.this.gv.getGraphControl().getDisplay().getSystemColor(9));
                    } else {
                        node.setBorderWidth(1);
                        node.setBorderColor(ESBVisualizerView.this.defaultBorder);
                    }
                } else {
                    ESBVisualizerView.this.openESBAction();
                }
            }
        }
    }

    private class LayoutAction
    extends Action {
        private LayoutAlgorithm[] layouts;
        private int currentLayout;
        private GraphViewer gv;

        public LayoutAction(GraphViewer gv, LayoutAlgorithm layout) {
            super(JBossESBUIMessages.ESBVisualizerView_Change_Layout_Action_Label);
            this.currentLayout = 0;
            this.gv = gv;
            this.layouts = new LayoutAlgorithm[1];
            this.layouts[0] = layout;
        }

        public void run() {
            super.run();
            int temp = this.currentLayout + 1;
            if (temp == this.layouts.length) {
                temp = 0;
            }
            this.currentLayout = temp;
            if (this.gv.getGraphControl().getLayoutAlgorithm() == null || !this.gv.getGraphControl().getLayoutAlgorithm().equals(this.layouts[this.currentLayout])) {
                this.gv.setLayoutAlgorithm(this.layouts[this.currentLayout], true);
            }
        }
    }

    private class OpenESBEditorAction
    extends Action {
        public OpenESBEditorAction() {
            super(JBossESBUIMessages.ESBVisualizerView_Open_ESB_Editor_Action_Label);
        }

        public void run() {
            ESBVisualizerView.this.openESBAction();
        }
    }
}

