/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;

public class ESBProjectDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IJavaProject) {
            element = ((IJavaProject)element).getProject();
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            ImageDescriptor overlay = null;
            if (this.hasFacet(project, "jst.jboss.esb")) {
                overlay = ESBProjectDecorator.getESBImageDescriptor();
            }
            if (overlay != null) {
                decoration.addOverlay(overlay);
            }
        }
    }

    private boolean hasFacet(IProject project, String facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static ImageDescriptor getESBImageDescriptor() {
        ImageDescriptor imageDescriptor = null;
        Path path = new Path("icons/obj16/esb_module_ovr.gif");
        URL gifImageURL = FileLocator.find((Bundle)Platform.getBundle((String)"org.jboss.tools.esb.project.ui"), (IPath)path, null);
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }
}

