/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizard;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizardValidator;

public class JBossWSGenerateWizardPage
extends WizardPage {
    private JBossWSGenerateWizard wizard;
    private Text name;
    private Combo projects;
    private boolean bHasChanged = false;
    private Text packageName;
    private Text className;

    protected JBossWSGenerateWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Title);
        this.setDescription(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createDialogArea(parent);
        this.wizard = (JBossWSGenerateWizard)this.getWizard();
        Group group = new Group(composite, 0);
        group.setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Project_Group);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)gd);
        this.projects = new Combo((Composite)group, 2052);
        this.projects.setToolTipText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Project_Group_Tooltip);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.projects.setLayoutData((Object)gd);
        this.refreshProjectList(this.wizard.getServiceModel().getWebProjectName());
        this.projects.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSGenerateWizardPage.this.wizard.setProject(JBossWSGenerateWizardPage.this.projects.getText());
                JBossWSGenerateWizardPage.this.name.setText(JBossWSGenerateWizardPage.this.updateDefaultName());
                JBossWSGenerateWizardPage.this.className.setText(JBossWSGenerateWizardPage.this.updateDefaultClassName());
                JBossWSGenerateWizardPage.this.bHasChanged = true;
                JBossWSGenerateWizardPage.this.setPageComplete(JBossWSGenerateWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group group2 = new Group(composite, 0);
        group2.setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Web_Service_Group);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)gd);
        new Label((Composite)group2, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_ServiceName_Label);
        this.name = new Text((Composite)group2, 2048);
        gd = new GridData(768);
        this.name.setLayoutData((Object)gd);
        this.name.setText(this.updateDefaultName());
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateWizardPage.this.wizard.setServiceName(JBossWSGenerateWizardPage.this.name.getText());
                JBossWSGenerateWizardPage.this.bHasChanged = true;
                JBossWSGenerateWizardPage.this.setPageComplete(JBossWSGenerateWizardPage.this.isPageComplete());
            }
        });
        Group group3 = new Group(composite, 0);
        group3.setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Class_Group);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setLayoutData((Object)gd);
        new Label((Composite)group3, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Package_Label);
        this.packageName = new Text((Composite)group3, 2048);
        gd = new GridData(768);
        this.packageName.setLayoutData((Object)gd);
        this.packageName.setText(this.wizard.getPackageName());
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateWizardPage.this.wizard.setPackageName(JBossWSGenerateWizardPage.this.packageName.getText());
                JBossWSGenerateWizardPage.this.setPageComplete(JBossWSGenerateWizardPage.this.isPageComplete());
            }
        });
        new Label((Composite)group3, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_ClassName_Label);
        this.className = new Text((Composite)group3, 2048);
        gd = new GridData(768);
        this.className.setLayoutData((Object)gd);
        this.className.setText(this.updateDefaultClassName());
        this.className.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateWizardPage.this.wizard.setClassName(JBossWSGenerateWizardPage.this.className.getText());
                JBossWSGenerateWizardPage.this.setPageComplete(JBossWSGenerateWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)composite);
    }

    private void refreshProjectList(String projectName) {
        String[] projectNames = this.getProjects();
        boolean foundInitialProject = false;
        this.projects.removeAll();
        int i = 0;
        while (i < projectNames.length) {
            this.projects.add(projectNames[i]);
            if (projectNames[i].equals(projectName)) {
                foundInitialProject = true;
            }
            ++i;
        }
        if (foundInitialProject) {
            this.projects.setText(projectName);
        }
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    private Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private String updateDefaultName() {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        String currentName = this.wizard.getServiceName();
        IStatus status = JBossWSGenerateWizardValidator.isWSNameValid();
        try {
            if (status.getSeverity() == 4 && !JavaEEProjectUtilities.isDynamicWebProject((IProject)this.wizard.getProject())) {
                return currentName;
            }
        }
        catch (NullPointerException nullPointerException) {
            return currentName;
        }
        String testName = currentName;
        int i = 1;
        while (status != null) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setServiceName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSNameValid();
            ++i;
        }
        return testName;
    }

    private String updateDefaultClassName() {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        String currentName = this.wizard.getClassName();
        if (this.wizard.getProject() == null) {
            return currentName;
        }
        boolean isDynamicWebProject = false;
        try {
            if (this.wizard.getProject().getNature("org.eclipse.wst.common.project.facet.core.nature") != null) {
                isDynamicWebProject = true;
            }
        }
        catch (CoreException coreException) {}
        if (!isDynamicWebProject) {
            return currentName;
        }
        String testName = currentName;
        IStatus status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
        int i = 1;
        while (status != null && status.getSeverity() == 4) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setClassName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
            ++i;
        }
        return testName;
    }

    private boolean validate() {
        IStatus status;
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        if (!this.projects.isDisposed() && this.projects.getText().length() > 0) {
            model.setWebProjectName(this.projects.getText());
        }
        if (((JBossWSGenerateWizard)this.getWizard()).getProject() == null) {
            this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NoProjectSelected);
            return false;
        }
        IFile web = ((JBossWSGenerateWizard)this.getWizard()).getWebFile();
        if (web == null || !web.exists()) {
            this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NotDynamicWebProject);
            return false;
        }
        try {
            if ("".equals(JBossWSCreationUtils.getJavaProjectSrcLocation((IProject)((JBossWSGenerateWizard)this.getWizard()).getProject()))) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NoSrcInProject);
                return false;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if ((status = JBossWSGenerateWizardValidator.isWSNameValid()) != null) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        IStatus classNameStatus = JBossWSGenerateWizardValidator.isWSClassValid(model.getCustomClassName(), this.wizard.getProject());
        if (classNameStatus != null) {
            if (classNameStatus.getSeverity() == 4) {
                this.setMessage(classNameStatus.getMessage(), 3);
                return false;
            }
            if (classNameStatus.getSeverity() == 2) {
                this.setMessage(classNameStatus.getMessage(), 2);
                return true;
            }
        }
        this.setMessage(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Description);
        this.setErrorMessage(null);
        return true;
    }

    private String[] getProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> dynamicProjects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            boolean isDynamicWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)projects[i]);
            if (isDynamicWebProject) {
                dynamicProjects.add(projects[i].getName());
            }
            ++i;
        }
        return dynamicProjects.toArray(new String[dynamicProjects.size()]);
    }

    protected boolean hasChanged() {
        return this.bHasChanged;
    }
}

