/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.ws.creation.core.commands.MergeWebXMLCommand;
import org.jboss.tools.ws.creation.core.commands.ServiceSampleCreationCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizardPage;

public class JBossWSGenerateWizard
extends Wizard
implements INewWizard {
    private static final String JDT_EDITOR = "org.eclipse.jdt.ui.CompilationUnitEditor";
    String NAMEDEFAULT = "HelloWorld";
    String PACKAGEDEFAULT = "org.jboss.samples.webservices";
    String CLASSDEFAULT = "HelloWorld";
    private String serviceName = this.NAMEDEFAULT;
    private String packageName = this.PACKAGEDEFAULT;
    private String className = this.CLASSDEFAULT;
    private boolean useDefaultServiceName = true;
    private boolean useDefaultClassName = true;
    private IStructuredSelection selection;
    private IProject project;
    private static String WEB = "web.xml";
    private static String JAVA = ".java";
    private static String WEBINF = "WEB-INF";
    private IFile webFile;

    public JBossWSGenerateWizard() {
        super.setWindowTitle(JBossWSUIMessages.JBossWS_GenerateWizard_Title);
        super.setHelpAvailable(false);
    }

    public void addPages() {
        super.addPages();
        JBossWSGenerateWizardPage onePage = new JBossWSGenerateWizardPage("onePage");
        this.addPage((IWizardPage)onePage);
        this.setDefaultPageImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor("wizard/WebServiceWizBan.png"));
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ServiceModel model = new ServiceModel();
            model.setWebProjectName(this.project.getName());
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            model.setJavaProject(javaProject);
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
            model.setServiceName(this.getServiceName());
            model.setUpdateWebxml(true);
            model.setCustomPackage(this.getPackageName());
            String classFilePath = JBossWSCreationUtils.composeSrcPackageClassPath((IProject)this.project, (String)model.getCustomPackage(), (String)this.className);
            File file = null;
            file = classFilePath != null ? JBossWSCreationUtils.findFileByPath((String)classFilePath) : JBossWSCreationUtils.findFileByPath((String)(String.valueOf(this.className) + JAVA), (String)this.project.getLocation().toOSString());
            if (file != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
                return false;
            }
            IStatus status = null;
            try {
                MergeWebXMLCommand mergeCommand = new MergeWebXMLCommand(model);
                status = mergeCommand.execute(null, null);
            }
            catch (ExecutionException e) {
                JBossWSUIPlugin.log(e);
            }
            if (status != null && status.getSeverity() == 4) {
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)status.getMessage());
                return false;
            }
            try {
                ServiceSampleCreationCommand cmd = new ServiceSampleCreationCommand(model);
                cmd.execute(null, null);
                this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (cmd.getResource() != null && cmd.getResource() instanceof IFile) {
                    this.openResource((IFile)cmd.getResource());
                }
            }
            catch (ExecutionException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
            catch (CoreException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (this.selection.getFirstElement() instanceof IProject) {
            this.project = (IProject)this.selection.getFirstElement();
        }
        if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
            this.webFile = this.project.getParent().getFolder(JBossWSCreationUtils.getWebContentRootPath((IProject)this.project).append(WEBINF)).getFile(WEB);
        }
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isUseDefaultServiceName() {
        return this.useDefaultServiceName;
    }

    public void setUseDefaultServiceName(boolean useDefaultServiceName) {
        this.useDefaultServiceName = useDefaultServiceName;
    }

    public boolean isUseDefaultClassName() {
        return this.useDefaultClassName;
    }

    public void setUseDefaultClassName(boolean useDefaultClassName) {
        this.useDefaultClassName = useDefaultClassName;
    }

    public IProject getProject() {
        return this.project;
    }

    public ServiceModel getServiceModel() {
        ServiceModel model = new ServiceModel();
        if (this.project != null) {
            model.setWebProjectName(this.project.getName());
        }
        if (this.getPackageName() != null) {
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
        }
        model.setServiceName(this.getServiceName());
        model.setUpdateWebxml(true);
        model.setCustomPackage(this.getPackageName());
        model.setCustomClassName(this.getClassName());
        return model;
    }

    public void setProject(String projectName) {
        IProject test;
        if (projectName != null && projectName.trim().length() > 0 && (test = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            this.project = test;
            if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
                this.webFile = this.project.getParent().getFolder(JBossWSCreationUtils.getWebContentRootPath((IProject)this.project).append(WEBINF)).getFile(WEB);
            }
        }
    }

    public IFile getWebFile() {
        return this.webFile;
    }

    protected void openResource(final IFile resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = JBossWSUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (String)JBossWSGenerateWizard.JDT_EDITOR, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JBossWSUIPlugin.log(e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }
}

