/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.jboss.tools.ws.ui.utils.NetUtils;
import org.jboss.tools.ws.ui.utils.URIEncoder;
import org.jboss.tools.ws.ui.utils.URLUtils;
import org.jboss.tools.ws.ui.utils.Validator;
import org.jboss.tools.ws.ui.utils.WSDLPartsToXSDTypeMapper;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Node;

public class SchemaUtils {
    private static final String SIMPLE_TYPE_NAME = "simpleType";
    private static final String DOUBLE_TYPE_NAME = "double";
    private static final String INT_TYPE_NAME = "int";
    private static final String STRING_TYPE_NAME = "string";
    private static final String BOOLEAN_TYPE_NAME = "boolean";
    private static final String DECIMAL_TYPE_NAME = "decimal";
    private static final String PRECISION_DECIMAL_TYPE_NAME = "precisionDecimal";
    private static final String FLOAT_TYPE_NAME = "float";
    private static final String DURATION_TYPE_NAME = "duration";
    private static final String DATETIME_TYPE_NAME = "dateTime";
    private static final String DATE_TYPE_NAME = "date";
    private static final String TIME_TYPE_NAME = "time";
    private static final String GYEARMONTH_TYPE_NAME = "gYearMonth";
    private static final String GYEAR_TYPE_NAME = "gYear";
    private static final String GMONTHDAY_TYPE_NAME = "gMonthDay";
    private static final String GDAY_TYPE_NAME = "gDay";
    private static final String GMONTH_TYPE_NAME = "gMonth";
    private static final String HEXBINARY_TYPE_NAME = "hexBinary";
    private static final String BASE64BINARY_TYPE_NAME = "base64Binary";
    private static final String ANYURI_TYPE_NAME = "anyURI";
    private static final String NOTATION_TYPE_NAME = "NOTATION";
    private static Vector<XSDSchema> schemaList_;
    private static Vector<QName> w3SchemaQNameList_;
    private static Vector<XSDSchema> constantSchemaList_;
    private static HashMap<String, String> namespacesAndPrefixes_;
    private static String wsdlUrl_;
    private static Vector<String> schemaURI_;
    private static Definition definition_;
    private static boolean rootIsQualified_;
    private static String rootURI_;
    private static final String DEF_FACTORY_PROPERTY_NAME = "javax.wsdl.factory.DefinitionFactory";
    private static final String PRIVATE_DEF_FACTORY_CLASS = "org.apache.wsif.wsdl.WSIFWSDLFactoryImpl";
    public static final String SOAP_NS_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_ENVELOPE_NS_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP12_NS_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP12_PREFIX = "soap12";
    public static final String SOAP_PREFIX = "soap";

    static {
        rootIsQualified_ = false;
        rootURI_ = null;
        w3SchemaQNameList_ = new Vector();
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/2000/10/XMLSchema", "schema"));
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/1999/XMLSchema", "schema"));
        constantSchemaList_ = new Vector();
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2000/10/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/1999/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://schemas.xmlsoap.org/soap/encoding/"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://schemas.xmlsoap.org/wsdl/"));
        namespacesAndPrefixes_ = new HashMap();
    }

    public static Vector<String> loadWSDL(Definition wsdlDefinition) throws WSDLException {
        Vector<String> errorMessages = new Vector<String>();
        definition_ = wsdlDefinition;
        schemaList_ = new Vector();
        if (definition_ != null) {
            wsdlUrl_ = wsdlDefinition.getDocumentBaseURI();
            SchemaUtils.gatherSchemas(definition_, wsdlUrl_);
            int i = 0;
            while (i < schemaList_.size()) {
                EList errors;
                XSDSchema xsdSchema = schemaList_.elementAt(i);
                if (xsdSchema != null && !(errors = xsdSchema.getAllDiagnostics()).isEmpty()) {
                    ListIterator li = errors.listIterator();
                    while (li.hasNext()) {
                        XSDDiagnostic xd = (XSDDiagnostic)li.next();
                        String msg = xd.getMessage();
                        if (xd.getSeverity().getValue() == XSDDiagnosticSeverity.FATAL_LITERAL.getValue() || msg != null && msg.length() > 0 && msg.toLowerCase().indexOf("#array") != -1) {
                            li.remove();
                            continue;
                        }
                        if (msg == null || msg.length() <= 0) continue;
                        errorMessages.addElement(xd.getMessage());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < constantSchemaList_.size()) {
                schemaList_.addElement(constantSchemaList_.elementAt(i));
                ++i;
            }
        }
        return errorMessages;
    }

    public static String getSampleSOAPInputMessage(Definition wsdlDefinition, String serviceName, String portName, String bindingName, String opName) {
        try {
            SchemaUtils.loadWSDL(wsdlDefinition);
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        namespacesAndPrefixes_ = new HashMap();
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                if (portName == null || !portKey.contentEquals(portName)) continue;
                Port port = (Port)ports.get(portKey);
                Binding wsdlBinding = port.getBinding();
                PortType portType = wsdlBinding.getPortType();
                List operations = portType.getOperations();
                for (Operation operation : operations) {
                    if (opName == null || !operation.getName().contentEquals(opName)) continue;
                    Message inputMsg = operation.getInput().getMessage();
                    Collection parts = inputMsg.getParts().values();
                    StringBuffer buf = new StringBuffer();
                    for (Part part : parts) {
                        if (part.getName().equalsIgnoreCase("header")) continue;
                        WSDLPartsToXSDTypeMapper mapper = new WSDLPartsToXSDTypeMapper();
                        mapper.addSchemas(schemaList_);
                        buf.append(SchemaUtils.startProcessingPartXML(wsdlDefinition, part));
                    }
                    return buf.toString();
                }
            }
        }
        return null;
    }

    public static Definition readWSDLURL(URL contextURL) throws WSDLException, NullPointerException {
        Properties props = System.getProperties();
        String oldPropValue = props.getProperty(DEF_FACTORY_PROPERTY_NAME);
        wsdlUrl_ = contextURL.toExternalForm();
        props.setProperty(DEF_FACTORY_PROPERTY_NAME, PRIVATE_DEF_FACTORY_CLASS);
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        String context = null;
        if (contextURL != null) {
            context = contextURL.toString();
        }
        Definition def = wsdlReader.readWSDL(context);
        if (oldPropValue != null) {
            props.setProperty(DEF_FACTORY_PROPERTY_NAME, oldPropValue);
        } else {
            props.remove(DEF_FACTORY_PROPERTY_NAME);
        }
        return def;
    }

    public static String getSampleSOAPMessageHeader(Definition wsdlDefinition, String serviceName, String portName, String bindingName, String opName) {
        try {
            SchemaUtils.loadWSDL(wsdlDefinition);
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        namespacesAndPrefixes_ = new HashMap();
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                if (portName == null || !portKey.contentEquals(portName)) continue;
                Port port = (Port)ports.get(portKey);
                Binding wsdlBinding = port.getBinding();
                List operations = wsdlBinding.getBindingOperations();
                for (BindingOperation operation : operations) {
                    if (opName == null || !operation.getName().contentEquals(opName)) continue;
                    BindingInput input = operation.getBindingInput();
                    List extensions = input.getExtensibilityElements();
                    for (Object extension : extensions) {
                        if (!(extension instanceof SOAPHeader)) continue;
                        SOAPHeader header = (SOAPHeader)extension;
                        String part = header.getPart();
                        StringBuffer buf = new StringBuffer();
                        WSDLPartsToXSDTypeMapper mapper = new WSDLPartsToXSDTypeMapper();
                        mapper.addSchemas(schemaList_);
                        buf.append(SchemaUtils.startProcessingPartXML(wsdlDefinition, part, header.getMessage().getNamespaceURI()));
                        return buf.toString();
                    }
                }
            }
        }
        return null;
    }

    private static XSDSchema getSchemaForNamespace(String namespaceURI) {
        for (XSDSchema schema : schemaList_) {
            if (schema == null || schema.getTargetNamespace() == null || !schema.getTargetNamespace().equals(namespaceURI)) continue;
            return schema;
        }
        return null;
    }

    private static String getURIForNamespacePrefix(String nsPrefix) {
        for (XSDSchema schema : schemaList_) {
            String nsURI = (String)schema.getQNamePrefixToNamespaceMap().get(nsPrefix);
            if (nsURI == null) continue;
            return nsURI;
        }
        return null;
    }

    private static final void gatherSchemas(Definition definition, String definitionURL) {
        Map imports;
        List extTypes;
        Types types = definition.getTypes();
        if (types != null && (extTypes = types.getExtensibilityElements()) != null) {
            int i = 0;
            while (i < extTypes.size()) {
                Schema schemaElement;
                XSDSchema xsdSchema = null;
                Object obj = extTypes.get(i);
                if (obj instanceof Schema) {
                    schemaElement = (Schema)obj;
                    if (SchemaUtils.isW3SchemaElementType(schemaElement.getElementType()) && (xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement())) != null) {
                        xsdSchema.update();
                        xsdSchema.updateElement();
                        if (!SchemaUtils.checkSchemaURI(definitionURL)) {
                            schemaList_.addElement(xsdSchema);
                            SchemaUtils.gatherSchemaDirective(xsdSchema, definitionURL);
                        }
                    }
                } else if (obj instanceof UnknownExtensibilityElement && SchemaUtils.isW3SchemaElementType((schemaElement = (UnknownExtensibilityElement)obj).getElementType())) {
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    if (!SchemaUtils.checkSchemaURI(definitionURL)) {
                        schemaList_.addElement(xsdSchema);
                        SchemaUtils.gatherSchemaDirective(xsdSchema, definitionURL);
                    }
                }
                ++i;
            }
        }
        if ((imports = definition.getImports()) != null) {
            SchemaUtils.gatherImportedSchemas(definition, imports);
        }
    }

    private static final boolean isW3SchemaElementType(QName qname) {
        int i = 0;
        while (i < w3SchemaQNameList_.size()) {
            QName w3SchemaQName = w3SchemaQNameList_.elementAt(i);
            if (w3SchemaQName.equals(qname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean checkSchemaURI(String schemaURI) {
        boolean found = false;
        if (schemaURI != null && (schemaURI = SchemaUtils.normalize(schemaURI)) != null) {
            if (schemaURI.equals(SchemaUtils.normalize(wsdlUrl_))) {
                return false;
            }
            if (schemaURI_ == null) {
                return false;
            }
            Enumeration<String> e = schemaURI_.elements();
            while (e.hasMoreElements()) {
                String uri = e.nextElement();
                if (!schemaURI.equals(uri)) continue;
                found = true;
                break;
            }
            if (!found) {
                schemaURI_.addElement(schemaURI);
            }
        }
        return found;
    }

    private static String normalize(String uri) {
        try {
            String encodedURI = URIEncoder.encode(uri, "UTF-8");
            URI normalizedURI = new URI(encodedURI);
            normalizedURI = normalizedURI.normalize();
            return normalizedURI.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return uri;
        }
    }

    private static final void gatherSchemaDirective(XSDSchema xsdSchema, String xsdSchemaURL) {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            for (Object content : xsdSchemaContents) {
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)content;
                StringBuffer xsdSchemaDirectiveURL = new StringBuffer();
                String xsdSchemaDirectiveLocation = xsdSchemaDirective.getSchemaLocation();
                if (xsdSchemaDirectiveLocation != null && xsdSchemaDirectiveLocation.indexOf(58) == -1 && xsdSchemaURL != null && xsdSchemaURL.indexOf(58) != -1) {
                    int index = xsdSchemaURL.lastIndexOf(47);
                    if (index != -1) {
                        xsdSchemaDirectiveURL.append(xsdSchemaURL.substring(0, index + 1));
                    } else {
                        xsdSchemaDirectiveURL.append(xsdSchemaURL);
                        xsdSchemaDirectiveURL.append('/');
                    }
                }
                xsdSchemaDirectiveURL.append(xsdSchemaDirectiveLocation);
                String xsdSchemaDirectiveURLString = URLUtils.encodeURLString(xsdSchemaDirectiveURL.toString());
                XSDSchema resolvedSchema = xsdSchemaDirective.getResolvedSchema();
                if (resolvedSchema == null && xsdSchemaDirectiveURLString.length() > 0) {
                    resolvedSchema = SchemaUtils.getSchema(xsdSchemaDirectiveURLString);
                }
                if (resolvedSchema == null || SchemaUtils.checkSchemaURI(xsdSchemaDirectiveURLString)) continue;
                schemaList_.addElement(resolvedSchema);
                SchemaUtils.gatherSchemaDirective(resolvedSchema, xsdSchemaDirectiveURLString);
            }
        }
    }

    private static final XSDSchema getSchema(String locURI) {
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)(locURI = URLUtils.encodeURLString(locURI)));
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream(locURI);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        return xsdSchema;
    }

    private static final void gatherImportedSchemas(Definition definition, Map<?, ?> imports) {
        Iterator<?> iterator = imports.keySet().iterator();
        while (iterator.hasNext()) {
            List importList = (List)imports.get(iterator.next());
            int i = 0;
            while (i < importList.size()) {
                Import imp = (Import)importList.get(i);
                StringBuffer locURI = new StringBuffer(imp.getLocationURI());
                if (!Validator.validateURL(locURI.toString())) {
                    String base = definition.getDocumentBaseURI();
                    locURI.insert(0, base.substring(0, base.lastIndexOf(47) + 1));
                }
                try {
                    URL tryURL = new URL(locURI.toString());
                    Definition importDef = SchemaUtils.readWSDLURL(tryURL);
                    SchemaUtils.gatherSchemas(importDef, locURI.toString());
                }
                catch (WSDLException wSDLException) {
                    SchemaUtils.gatherSchema(locURI.toString());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private static final void gatherSchema(String locURI) {
        XSDSchema xsdSchema = SchemaUtils.getSchema(locURI);
        if (xsdSchema != null) {
            schemaList_.addElement(xsdSchema);
            SchemaUtils.gatherSchemaDirective(xsdSchema, locURI);
        }
    }

    private static XSDSchema findFirstSchemaWithPartNameAsChild(String partName) {
        for (XSDSchema schema : schemaList_) {
            DOMBuilder domBuilder = new DOMBuilder();
            Element jdomSchemaElement = domBuilder.build(schema.getElement());
            List kids = jdomSchemaElement.getChildren();
            for (Object kid : kids) {
                Element kidElement;
                if (!(kid instanceof Element) || (kidElement = (Element)kid).getAttribute("name") == null || !kidElement.getAttributeValue("name").equals(partName)) continue;
                return schema;
            }
        }
        return null;
    }

    private static Element findFirstElementWithPartNameInSchema(XSDSchema schema, String partName) {
        DOMBuilder domBuilder = new DOMBuilder();
        Element jdomSchemaElement = domBuilder.build(schema.getElement());
        List kids = jdomSchemaElement.getChildren();
        for (Object kid : kids) {
            Element kidElement;
            if (!(kid instanceof Element) || (kidElement = (Element)kid).getAttribute("name") == null || !kidElement.getAttributeValue("name").equals(partName)) continue;
            return kidElement;
        }
        return null;
    }

    private static String startProcessingPartXML(Definition wsdlDefinition, String partName, String partUri) {
        XSDSchema schema = SchemaUtils.findFirstSchemaWithPartNameAsChild(partName);
        DOMBuilder domBuilder = new DOMBuilder();
        Element jdomSchemaElement = domBuilder.build(schema.getElement());
        Element jdomElement = SchemaUtils.findFirstElementWithPartNameInSchema(schema, partName);
        String typeAttr = jdomElement.getAttributeValue("type");
        String nsprefix = null;
        String nstypename = typeAttr;
        if (typeAttr.indexOf(58) > 0) {
            nsprefix = typeAttr.substring(0, typeAttr.indexOf(58));
            nstypename = typeAttr.substring(typeAttr.indexOf(58) + 1, typeAttr.length());
        }
        String uri = schema.getTargetNamespace();
        if (nsprefix != null && !nsprefix.equalsIgnoreCase("tns")) {
            uri = SchemaUtils.getNSURI(nsprefix, wsdlDefinition);
        }
        StringBuffer buf = new StringBuffer();
        if (nsprefix != null && !nsprefix.equalsIgnoreCase("tns")) {
            if (schema.getTargetNamespace().equals(uri)) {
                buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement, jdomElement));
            } else {
                XSDSchema importXSD = SchemaUtils.getSchemaForNamespace(uri);
                if (importXSD != null) {
                    importXSD.updateElement(true);
                    Element jdomSchemaElement2 = domBuilder.build(importXSD.getElement());
                    Element child = jdomSchemaElement2.getChild(nstypename);
                    buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement2, child));
                }
            }
        } else {
            buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement, jdomElement));
        }
        return buf.toString();
    }

    private static String startProcessingPartXML(Definition wsdlDefinition, Part part) {
        DOMBuilder domBuilder = new DOMBuilder();
        WSDLPartsToXSDTypeMapper mapper = new WSDLPartsToXSDTypeMapper();
        mapper.addSchemas(schemaList_);
        XSDNamedComponent xsdComponent = mapper.getXSDTypeFromSchema(part);
        if (xsdComponent == null) {
            return "<error>Generating sample SOAP request</error>";
        }
        xsdComponent.updateElement(true);
        XSDSchema schema = xsdComponent.getSchema();
        schema.updateElement(true);
        if (!schema.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            rootIsQualified_ = true;
            rootURI_ = schema.getTargetNamespace();
        }
        Element jdomSchemaElement = domBuilder.build(schema.getElement());
        Element jdomElement = domBuilder.build(xsdComponent.getElement());
        String typeAttr = xsdComponent.getElement().getAttribute("type");
        String nsprefix = null;
        String nstypename = typeAttr;
        if (typeAttr.indexOf(58) > 0) {
            nsprefix = typeAttr.substring(0, typeAttr.indexOf(58));
            nstypename = typeAttr.substring(typeAttr.indexOf(58) + 1, typeAttr.length());
        }
        String uri = schema.getTargetNamespace();
        if (nsprefix != null && !nsprefix.equalsIgnoreCase("tns")) {
            uri = SchemaUtils.getNSURI(nsprefix, wsdlDefinition);
        }
        StringBuffer buf = new StringBuffer();
        if (nsprefix != null && !nsprefix.equalsIgnoreCase("tns")) {
            if (schema.getTargetNamespace().equals(uri)) {
                Element jdomSchemaElement2 = domBuilder.build(xsdComponent.getElement());
                buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement, jdomSchemaElement2));
            } else {
                XSDSchema importXSD = SchemaUtils.getSchemaForNamespace(uri);
                if (importXSD != null) {
                    importXSD.updateElement(true);
                    Element jdomSchemaElement2 = domBuilder.build(importXSD.getElement());
                    Element child = jdomSchemaElement2.getChild(nstypename);
                    buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement2, child));
                }
            }
        } else if (part.getTypeName() != null && SchemaUtils.isTypeBaseXSDOrSimple(part.getTypeName().getNamespaceURI(), part.getTypeName().getLocalPart())) {
            buf.append(String.valueOf('<') + part.getName() + ">?</" + part.getName() + '>');
        } else {
            buf.append(SchemaUtils.createXMLForJDOMElement2(jdomSchemaElement, jdomElement));
        }
        return buf.toString();
    }

    private static Element findJDOMTypeInSchema(Element schemaElement, String typeName) {
        if (schemaElement != null) {
            String nstypename = null;
            nstypename = typeName.indexOf(58) > -1 ? typeName.substring(typeName.indexOf(58) + 1, typeName.length()) : typeName;
            List kids = schemaElement.getChildren();
            for (Object kid : kids) {
                if (!(kid instanceof Element)) continue;
                Element kidelement = (Element)kid;
                if (kidelement.getName().equals("complexType") && kidelement.getAttributeValue("name").equals(nstypename)) {
                    return kidelement;
                }
                if (kidelement.getName().equals(SIMPLE_TYPE_NAME) && kidelement.getAttributeValue("name").equals(nstypename)) {
                    return kidelement;
                }
                if (!kidelement.getName().equals("attribute") || !kidelement.getAttributeValue("name").equals(nstypename)) continue;
                return kidelement;
            }
        }
        return null;
    }

    private static Element findJDOMTypeInSchemaByNameAttr(Element schemaElement, String name) {
        if (schemaElement != null) {
            List kids = schemaElement.getChildren();
            for (Object kid : kids) {
                if (!(kid instanceof Element)) continue;
                Element kidelement = (Element)kid;
                if (kidelement.getName().equals("complexType") && kidelement.getAttributeValue("name").equals(name)) {
                    return kidelement;
                }
                if (kidelement.getName().equals(SIMPLE_TYPE_NAME) && kidelement.getAttributeValue("name").equals(name)) {
                    return kidelement;
                }
                if (kidelement.getName().equals("attribute") && kidelement.getAttributeValue("name").equals(name)) {
                    return kidelement;
                }
                if (!kidelement.getName().equals("element") || !kidelement.getAttributeValue("name").equals(name)) continue;
                return kidelement;
            }
        }
        return null;
    }

    private static Element findJDOMElementInSchema(Element schemaElement, String typeName) {
        if (schemaElement != null) {
            List kids = schemaElement.getChildren();
            for (Object kid : kids) {
                String attrvalue;
                Element kidelement;
                if (!(kid instanceof Element) || !(kidelement = (Element)kid).getName().equals("element") || (attrvalue = kidelement.getAttributeValue("type")) == null || !attrvalue.equals(typeName)) continue;
                kidelement = SchemaUtils.findJDOMTypeInSchema(schemaElement, typeName);
                return kidelement;
            }
        }
        return null;
    }

    private static Element findJDOMElementInSchemaByName(Element schemaElement, String typeName) {
        if (schemaElement != null) {
            List kids = schemaElement.getChildren();
            for (Object kid : kids) {
                String nsprefix;
                String testUri;
                XSDSchema importXSD;
                String elemType;
                String attrvalue;
                Element kidelement;
                if (!(kid instanceof Element) || !(kidelement = (Element)kid).getName().equals("element") || (attrvalue = kidelement.getAttributeValue("name")) == null || !attrvalue.equals(typeName) || (elemType = kidelement.getAttributeValue("type")) == null || (importXSD = SchemaUtils.getSchemaForNamespace(testUri = SchemaUtils.getURIForNamespacePrefix(nsprefix = elemType.substring(0, elemType.indexOf(58))))) == null) continue;
                DOMBuilder domBuilder = new DOMBuilder();
                importXSD.updateElement(true);
                Element importXSDSchema = domBuilder.build(importXSD.getElement());
                Element element2 = SchemaUtils.findJDOMTypeInSchema(importXSDSchema, elemType);
                if (element2 != null) {
                    return element2;
                }
                element2 = SchemaUtils.findJDOMElementInSchema(importXSDSchema, elemType);
                if (element2 == null) continue;
                return element2;
            }
        }
        return null;
    }

    private static String handleAttributes(Element element) {
        StringBuffer buf = new StringBuffer();
        List kids = element.getChildren();
        boolean isQualified = false;
        for (Element kid : kids) {
            String testUri;
            XSDSchema importXSD;
            if (!kid.getName().equals("attribute") || kid.getAttribute("ref") == null) continue;
            String elemType = kid.getAttributeValue("ref");
            String nsprefix = elemType.substring(0, elemType.indexOf(58));
            String typename = elemType.substring(elemType.indexOf(58) + 1, elemType.length());
            if (elemType.indexOf(58) > -1 && !elemType.startsWith("xs:") && !elemType.startsWith("xsd:")) {
                isQualified = true;
            }
            if ((importXSD = SchemaUtils.getSchemaForNamespace(testUri = SchemaUtils.getURIForNamespacePrefix(nsprefix))) == null) continue;
            DOMBuilder domBuilder = new DOMBuilder();
            importXSD.updateElement(true);
            Element importXSDSchema = domBuilder.build(importXSD.getElement());
            Element element2 = SchemaUtils.findJDOMTypeInSchema(importXSDSchema, typename);
            if (element2 != null) {
                element = element2;
            } else {
                element2 = SchemaUtils.findJDOMElementInSchema(importXSDSchema, typename);
                if (element2 != null) {
                    element = element2;
                }
            }
            if (element == null) continue;
            if (isQualified) {
                String prefix = SchemaUtils.makePrefixFromURI(testUri);
                if (!namespacesAndPrefixes_.containsKey(prefix)) {
                    buf.append(" xmlns:" + prefix + "=\"" + testUri + "\"");
                    namespacesAndPrefixes_.put(prefix, testUri);
                }
                buf.append(String.valueOf(' ') + prefix + ':');
            }
            String name = element.getAttributeValue("name");
            buf.append(String.valueOf(name) + "=\"?\" ");
        }
        return buf.toString();
    }

    private static boolean namespacePrefixListContainsURI(String uri) {
        return namespacesAndPrefixes_ != null && namespacesAndPrefixes_.containsValue(uri);
    }

    private static String makePrefixFromURI(String uri) {
        String tnsprefix;
        if (SchemaUtils.namespacePrefixListContainsURI(uri)) {
            for (Map.Entry<String, String> entry : namespacesAndPrefixes_.entrySet()) {
                if (!entry.getValue().equals(uri)) continue;
                return entry.getKey();
            }
        }
        if ((tnsprefix = uri.substring(uri.indexOf("://") + 3, uri.length())).contains(":")) {
            tnsprefix = uri.substring(0, uri.indexOf(58));
        }
        if (tnsprefix.length() > 4) {
            if (tnsprefix.endsWith("/")) {
                tnsprefix = tnsprefix.substring(0, tnsprefix.length() - 1);
            }
            if (tnsprefix.lastIndexOf(47) > -1) {
                tnsprefix = tnsprefix.substring(tnsprefix.lastIndexOf(47) + 1, tnsprefix.length());
            }
            if (tnsprefix.length() > 4) {
                tnsprefix = tnsprefix.substring(0, 4);
            }
            if (namespacesAndPrefixes_.containsKey(tnsprefix = tnsprefix.toLowerCase())) {
                int i = 1;
                String test = String.valueOf(tnsprefix) + i;
                while (namespacesAndPrefixes_.containsKey(test)) {
                    test = String.valueOf(tnsprefix) + ++i;
                }
                tnsprefix = test;
            }
        }
        return tnsprefix;
    }

    private static boolean elementHasChildren(Element element) {
        boolean rtnflag = false;
        if (element.getChildren() != null && element.getChildren().size() > 0) {
            List kids = element.getChildren();
            for (Element kid : kids) {
                boolean kidflag;
                if (kid.getName().equals("element")) {
                    rtnflag = true;
                }
                if (!(kidflag = SchemaUtils.elementHasChildren(kid))) continue;
                rtnflag = true;
            }
        }
        return rtnflag;
    }

    private static String createXMLForJDOMElement2(Element schemaElement, Element element) {
        String enums;
        Element parent;
        Element element2;
        StringBuffer buf = new StringBuffer();
        String nstypename = null;
        String tns = null;
        String tnsprefix = null;
        if (schemaElement.getNamespace("tns") != null) {
            tns = schemaElement.getNamespace("tns").getURI();
            tnsprefix = SchemaUtils.makePrefixFromURI(tns);
        }
        boolean isQualified = false;
        if (element.getAttribute("name") != null) {
            nstypename = element.getAttributeValue("name");
        }
        if (element.getAttribute("type") != null) {
            String type2FindName = element.getAttributeValue("type");
            if (type2FindName.indexOf(58) > -1 && !type2FindName.startsWith("xs:") && !type2FindName.startsWith("xsd:")) {
                isQualified = true;
            }
            if ((element2 = SchemaUtils.findJDOMTypeInSchema(schemaElement, type2FindName)) != null && (element = element2).getParentElement() != null && (parent = element.getParentElement()).getNamespace("tns") != null) {
                tns = parent.getNamespace("tns").getURI();
                tnsprefix = SchemaUtils.makePrefixFromURI(tns);
            }
        }
        if (element.getAttribute("ref") != null) {
            String ref2FindName = element.getAttributeValue("ref");
            if (ref2FindName.indexOf(58) > -1 && !ref2FindName.startsWith("xs:") && !ref2FindName.startsWith("xsd:")) {
                isQualified = true;
            }
            if ((element2 = SchemaUtils.findJDOMTypeInSchema(schemaElement, ref2FindName)) != null) {
                element = element2;
                if (element.getParentElement() != null && (parent = element.getParentElement()).getNamespace("tns") != null) {
                    tns = parent.getNamespace("tns").getURI();
                    tnsprefix = SchemaUtils.makePrefixFromURI(tns);
                }
            } else {
                element2 = SchemaUtils.findJDOMElementInSchema(schemaElement, ref2FindName);
                if (element2 != null && (element = element2).getParentElement() != null && (parent = element.getParentElement()).getNamespace("tns") != null) {
                    tns = parent.getNamespace("tns").getURI();
                    tnsprefix = SchemaUtils.makePrefixFromURI(tns);
                }
            }
        }
        Integer minOccurs = 1;
        String elemType = null;
        if (element.getAttributes().size() > 0) {
            String nsprefix;
            if (element.getAttribute("minOccurs") != null) {
                String value = element.getAttributeValue("minOccurs");
                minOccurs = Integer.decode(value);
            }
            if (element.getAttribute("type") != null) {
                XSDSchema importXSD;
                elemType = element.getAttributeValue("type");
                nsprefix = "";
                try {
                    nsprefix = elemType.substring(0, elemType.indexOf(58));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                String testUri = SchemaUtils.getURIfromSchemaPrefix(element, nsprefix);
                if (elemType.indexOf(58) > -1 && !elemType.startsWith("xs:") && !elemType.startsWith("xsd:")) {
                    isQualified = true;
                }
                if ((importXSD = SchemaUtils.getSchemaForNamespace(testUri)) != null) {
                    DOMBuilder domBuilder = new DOMBuilder();
                    importXSD.updateElement(true);
                    Element importXSDSchema = domBuilder.build(importXSD.getElement());
                    Element element22 = SchemaUtils.findJDOMTypeInSchema(importXSDSchema, elemType);
                    if (element22 != null) {
                        element = element22;
                    } else {
                        element22 = SchemaUtils.findJDOMElementInSchema(importXSDSchema, elemType);
                        if (element22 != null) {
                            element = element22;
                        } else {
                            element22 = SchemaUtils.findJDOMElementInSchemaByName(schemaElement, nstypename);
                            if (element22 != null) {
                                element = element22;
                            }
                        }
                    }
                } else if (schemaElement != null) {
                    Element element23 = SchemaUtils.findJDOMTypeInSchema(schemaElement, elemType);
                    if (element23 != null) {
                        element = element23;
                    } else {
                        element23 = SchemaUtils.findJDOMElementInSchema(schemaElement, elemType);
                        if (element23 != null) {
                            element = element23;
                        } else {
                            element23 = SchemaUtils.findJDOMElementInSchemaByName(schemaElement, nstypename);
                            if (element23 != null) {
                                element = element23;
                            }
                        }
                    }
                }
            }
            if (element.getAttribute("ref") != null) {
                XSDSchema importXSD;
                String typename;
                elemType = element.getAttributeValue("ref");
                nsprefix = elemType.substring(0, elemType.indexOf(58));
                nstypename = typename = elemType.substring(elemType.indexOf(58) + 1, elemType.length());
                String testUri = SchemaUtils.getURIfromSchemaPrefix(element, nsprefix);
                if (elemType.indexOf(58) > -1 && !elemType.startsWith("xs:")) {
                    isQualified = true;
                    tns = testUri;
                    tnsprefix = SchemaUtils.makePrefixFromURI(tns);
                }
                if ((importXSD = SchemaUtils.getSchemaForNamespace(testUri)) != null) {
                    DOMBuilder domBuilder = new DOMBuilder();
                    importXSD.updateElement(true);
                    Element importXSDSchema = domBuilder.build(importXSD.getElement());
                    Element element24 = SchemaUtils.findJDOMTypeInSchema(importXSDSchema, elemType);
                    if (element24 != null) {
                        element = element24;
                    } else {
                        element24 = SchemaUtils.findJDOMElementInSchema(importXSDSchema, elemType);
                        if (element24 != null) {
                            element = element24;
                        } else {
                            element24 = SchemaUtils.findJDOMElementInSchemaByName(importXSDSchema, nstypename);
                            if (element24 != null) {
                                element = element24;
                            }
                        }
                    }
                }
            }
        }
        boolean hasKids = false;
        if (SchemaUtils.elementHasChildren(element)) {
            hasKids = true;
        }
        boolean isSimpleType = false;
        if (elemType != null && SchemaUtils.isTypeBaseXSDOrSimple(tns, elemType)) {
            isSimpleType = true;
        }
        boolean hasEnums = false;
        if (element.getName().equals(SIMPLE_TYPE_NAME) && (enums = SchemaUtils.getEnumerations(element)) != null && enums.trim().length() > 0) {
            hasEnums = true;
        }
        boolean includeTNSInRoot = false;
        if (rootIsQualified_ && !isQualified) {
            includeTNSInRoot = true;
            isQualified = true;
            tnsprefix = "tns";
        } else if (isQualified) {
            rootIsQualified_ = false;
            if (tnsprefix == null) {
                tnsprefix = "tns";
            }
        }
        boolean isSequence = element.getName().equals("sequence");
        if (!isSequence) {
            if (minOccurs == 0) {
                buf.append("<!-- optional -->\n");
            }
            buf.append('<');
            if (isQualified) {
                buf.append(String.valueOf(tnsprefix) + ':');
            }
            buf.append(nstypename);
            String attributes = SchemaUtils.handleAttributes(element);
            if (attributes != null && attributes.trim().length() > 0) {
                buf.append(' ');
                buf.append(attributes);
            }
            if (isQualified) {
                if (includeTNSInRoot && !SchemaUtils.namespacePrefixListContainsURI(rootURI_)) {
                    buf.append(" xmlns:tns=\"" + rootURI_ + "\"");
                    namespacesAndPrefixes_.put(tnsprefix, rootURI_);
                } else if (!namespacesAndPrefixes_.containsKey(tnsprefix)) {
                    buf.append(" xmlns:" + tnsprefix + "=\"" + tns + "\"");
                    namespacesAndPrefixes_.put(tnsprefix, tns);
                }
            }
            if (hasKids || isSimpleType || hasEnums) {
                buf.append(">");
            } else {
                buf.append("/>");
            }
        }
        if (hasKids) {
            if (!isSequence) {
                buf.append('\n');
            }
            List kids = element.getChildren();
            for (Element kid : kids) {
                if (kid.getName().equals("complexType") || kid.getName().equals("sequence") || kid.getName().equals(SIMPLE_TYPE_NAME) || kid.getName().equals("restriction")) {
                    List innerkids = kid.getChildren();
                    for (Element innerkid : innerkids) {
                        String out = SchemaUtils.createXMLForJDOMElement2(schemaElement, innerkid);
                        buf.append(out);
                    }
                    continue;
                }
                if (!kid.getName().equals("element")) continue;
                String out = SchemaUtils.createXMLForJDOMElement2(schemaElement, kid);
                buf.append(out);
            }
        }
        if (!isSequence && (hasKids || isSimpleType || hasEnums)) {
            if (!hasKids || isSimpleType || hasEnums) {
                buf.append('?');
            }
            buf.append("</");
            if (isQualified) {
                buf.append(String.valueOf(tnsprefix) + ':');
            }
            buf.append(nstypename);
            buf.append(">\n");
        }
        return buf.toString();
    }

    private static String getEnumerations(Element element) {
        StringBuffer buf = new StringBuffer();
        List kids = element.getChildren();
        for (Element kid : kids) {
            if (kid.getChildren() != null && kid.getChildren().size() > 0) {
                buf.append(SchemaUtils.getEnumerations(kid));
            }
            if (!kid.getName().equals("enumeration")) continue;
            String value = kid.getAttributeValue("value");
            buf.append(String.valueOf(value) + '|');
        }
        return buf.toString();
    }

    private static HashMap<String, String> getDefinitionNamespaces(Definition wsdlDefinition) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put(SOAP_NS_URI, SOAP_PREFIX);
        namespaceMap.put(SOAP12_ENVELOPE_NS_URI, SOAP12_PREFIX);
        namespaceMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        namespaceMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
        Map namespaces = wsdlDefinition.getNamespaces();
        Set namespaceKeys = namespaces.keySet();
        int i = 1;
        for (String prefix : namespaceKeys) {
            String url = wsdlDefinition.getNamespace(prefix);
            if (namespaceMap.containsKey(url)) continue;
            String newprefix = "ns" + i++;
            namespaceMap.put(url, newprefix);
        }
        return namespaceMap;
    }

    private static String getNSURI(String inPrefix, Definition wsdlDefinition) {
        HashMap<String, String> map = SchemaUtils.getDefinitionNamespaces(wsdlDefinition);
        if (map.containsValue(inPrefix)) {
            for (Map.Entry<String, String> test : map.entrySet()) {
                if (!test.getValue().equals(inPrefix)) continue;
                return test.getKey();
            }
        }
        return null;
    }

    private static String getURIfromSchemaPrefix(Element el, String prefix) {
        Element e = el;
        while (e.getParentElement() != null) {
            e = e.getParentElement();
        }
        if (e.getNamespace(prefix) != null) {
            return e.getNamespace(prefix).getURI();
        }
        return null;
    }

    private static boolean isTypeBaseXSDOrSimple(String uri, String type) {
        if (uri != null) {
            String typename;
            Element element;
            XSDSchema schema = SchemaUtils.getSchemaForNamespace(uri);
            DOMBuilder domBuilder = new DOMBuilder();
            schema.updateElement(true);
            Element importXSDSchema = domBuilder.build(schema.getElement());
            if (type != null && type.indexOf(58) > -1 && (element = SchemaUtils.findJDOMTypeInSchemaByNameAttr(importXSDSchema, typename = type.substring(type.indexOf(58) + 1, type.length()))) != null && element.getAttribute("type") != null) {
                type = element.getAttributeValue("type");
            }
        }
        if (type != null && type.endsWith(STRING_TYPE_NAME) || type.endsWith(BOOLEAN_TYPE_NAME) || type.endsWith(DECIMAL_TYPE_NAME) || type.endsWith(INT_TYPE_NAME) || type.endsWith(DOUBLE_TYPE_NAME) || type.endsWith(FLOAT_TYPE_NAME) || type.endsWith(DURATION_TYPE_NAME) || type.endsWith(DATE_TYPE_NAME) || type.endsWith(TIME_TYPE_NAME) || type.endsWith(DATETIME_TYPE_NAME) || type.endsWith(ANYURI_TYPE_NAME) || type.endsWith(BASE64BINARY_TYPE_NAME) || type.endsWith(GDAY_TYPE_NAME) || type.endsWith(GMONTH_TYPE_NAME) || type.endsWith(GMONTHDAY_TYPE_NAME) || type.endsWith(GYEAR_TYPE_NAME) || type.endsWith(GYEARMONTH_TYPE_NAME) || type.endsWith(HEXBINARY_TYPE_NAME) || type.endsWith(NOTATION_TYPE_NAME) || type.endsWith(PRECISION_DECIMAL_TYPE_NAME)) {
            return true;
        }
        return type != null && type.contains(SIMPLE_TYPE_NAME);
    }
}

