/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.ws.ui.dialogs.URLTemplateParameter;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.JAXRSPathTemplateParser;

public class WSTesterURLInputsDialog
extends TitleAreaDialog {
    private TreeViewer treeRequestBody;
    private static final String NAME_COLUMN = "name";
    private static final String VALUE_COLUMN = "value";
    private static final String TYPE_COLUMN = "datatype";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value", "datatype"};
    private String stashedURL;
    private URLTemplateParameter[] parms;
    private Button mOKButton = null;

    public WSTesterURLInputsDialog(Shell parentShell, String url) {
        super(parentShell);
        this.stashedURL = url;
        this.parms = JAXRSPathTemplateParser.parse(this.stashedURL);
    }

    public String getURL() {
        return this.replaceParmsWithValues();
    }

    private String replaceString(String input, String find, String replace, boolean casesensitive) {
        String input_case_adjusted = input;
        if (!casesensitive) {
            input_case_adjusted = input.toLowerCase();
            find = find.toLowerCase();
        }
        int startPosition = input_case_adjusted.indexOf(find);
        String start = "";
        String end = "";
        if (startPosition >= 0) {
            if (startPosition > 0) {
                start = input.substring(0, startPosition);
            }
            end = input.substring(startPosition + find.length());
            return String.valueOf(start) + replace + end;
        }
        return input;
    }

    private String replaceParmsWithValues() {
        if (this.parms.length > 0 && this.stashedURL != null && this.stashedURL.trim().length() > 0) {
            String modified = this.stashedURL;
            URLTemplateParameter[] uRLTemplateParameterArray = this.parms;
            int n = this.parms.length;
            int n2 = 0;
            while (n2 < n) {
                URLTemplateParameter parm = uRLTemplateParameterArray[n2];
                if (parm.getValue() != null) {
                    modified = this.replaceString(modified, parm.getOriginalContent(), parm.getReplacementContent(), true);
                }
                ++n2;
            }
            if ((modified = modified.replace("//", "/")).startsWith("http:/") && !modified.startsWith("http://")) {
                modified = modified.replace("http:/", "http://");
            } else if (modified.startsWith("https:/") && !modified.startsWith("https://")) {
                modified = modified.replace("https:/", "https://");
            }
            return modified;
        }
        return this.stashedURL;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(JBossWSUIMessages.WSTesterURLInputsDialog_DialogTitle);
        this.setMessage(JBossWSUIMessages.WSTesterURLInputsDialog_DialogMessage);
        Composite area = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        Composite content = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        layout.marginLeft = 5;
        layout.marginRight = 5;
        GridData data = new GridData(1808);
        content.setLayoutData((Object)data);
        content.setFont(font);
        Label label = new Label(content, 0);
        label.setText(JBossWSUIMessages.WSTesterURLInputsDialog_URLParms_Label);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.treeRequestBody = new TreeViewer(content, 68160);
        this.treeRequestBody.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true);
        gd11.heightHint = 100;
        this.treeRequestBody.getTree().setLayoutData((Object)gd11);
        this.treeRequestBody.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        nameColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Name_column);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        valueColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Value_column);
        valueColumn.setWidth(200);
        TreeColumn typeColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        typeColumn.setText(JBossWSUIMessages.WSTesterURLInputsDialog_Type_Column);
        typeColumn.setWidth(200);
        this.treeRequestBody.setColumnProperties(TREE_COLUMNS);
        this.treeRequestBody.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                if (element instanceof URLTemplateParameter && property.equalsIgnoreCase(WSTesterURLInputsDialog.NAME_COLUMN)) {
                    return true;
                }
                if (element instanceof URLTemplateParameter && property.equalsIgnoreCase(WSTesterURLInputsDialog.VALUE_COLUMN)) {
                    return true;
                }
                return element instanceof URLTemplateParameter && property.equalsIgnoreCase(WSTesterURLInputsDialog.TYPE_COLUMN);
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof URLTemplateParameter) {
                    URLTemplateParameter parameter = (URLTemplateParameter)element;
                    if (columnIndex == 0) {
                        StringBuilder nameBuilder = new StringBuilder();
                        nameBuilder.append(parameter.getName());
                        if (parameter.isMandatory()) {
                            nameBuilder.append("* ");
                        }
                        return nameBuilder.toString();
                    }
                    if (columnIndex == 1) {
                        return parameter.getValue();
                    }
                    if (columnIndex == 2) {
                        return parameter.getDatatype();
                    }
                }
                return null;
            }
        });
        this.treeRequestBody.setContentProvider((IContentProvider)new ITreeContentProvider(){
            URLTemplateParameter[] parms;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof URLTemplateParameter[]) {
                    this.parms = (URLTemplateParameter[])newInput;
                }
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof URLTemplateParameter[]) {
                    return this.parms;
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof URLTemplateParameter[]) {
                    return new Object[]{this.parms};
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof URLTemplateParameter) {
                    return this.parms;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof URLTemplateParameter[]) {
                    return ((URLTemplateParameter[])element).length > 0;
                }
                return false;
            }
        });
        this.treeRequestBody.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof URLTemplateParameter && property.equalsIgnoreCase(WSTesterURLInputsDialog.VALUE_COLUMN);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof URLTemplateParameter && property.equalsIgnoreCase(WSTesterURLInputsDialog.VALUE_COLUMN)) {
                    return ((URLTemplateParameter)element).getValue();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TreeItem && property.equalsIgnoreCase(WSTesterURLInputsDialog.VALUE_COLUMN)) {
                    TreeItem ti = (TreeItem)element;
                    URLTemplateParameter parm = (URLTemplateParameter)ti.getData();
                    parm.setValue((String)value);
                    WSTesterURLInputsDialog.this.treeRequestBody.refresh(true);
                    WSTesterURLInputsDialog.this.validate();
                }
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)this.treeRequestBody.getTree());
        this.treeRequestBody.setCellEditors(cellEditorArray);
        this.treeRequestBody.setInput((Object)this.parms);
        Label mandatoryValuesLabel = new Label(content, 0);
        mandatoryValuesLabel.setText(JBossWSUIMessages.WSTesterURLInputsDialog_URLParms_Mandatory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        mandatoryValuesLabel.setLayoutData((Object)gridData);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOKButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.mOKButton.setEnabled(true);
        this.validate();
        this.setErrorMessage(null);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JBossWSUIMessages.WSTesterURLInputsDialog_Window_Title);
        super.configureShell(newShell);
    }

    private String validateParmValues() {
        URLTemplateParameter[] uRLTemplateParameterArray = this.parms;
        int n = this.parms.length;
        int n2 = 0;
        while (n2 < n) {
            URLTemplateParameter parameter = uRLTemplateParameterArray[n2];
            String errorMessage = parameter.validate();
            if (errorMessage != null) {
                return errorMessage;
            }
            ++n2;
        }
        return null;
    }

    private void validate() {
        boolean hasError;
        String errorMessage = this.validateParmValues();
        boolean bl = hasError = errorMessage != null;
        if (hasError) {
            this.setMessage(errorMessage, 2);
        } else {
            this.setMessage(JBossWSUIMessages.WSTesterURLInputsDialog_DialogMessage);
        }
    }
}

