/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.BPELImplementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.bpel.Activator;
import org.switchyard.tools.ui.bpel.BPELComponentWizard;
import org.switchyard.tools.ui.bpel.Messages;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class BPELImplementationWizardPage
extends WizardPage {
    private Component _component;
    private ComponentService _serviceInterface;
    private Link _newBPELLink;
    private Text _bpelFileText;
    private Button _browseBPELButton;
    private IJavaProject _project;
    private BPELImplementation _implementation;
    private ComponentService _service;

    public BPELImplementationWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.BPELImplementationWizardPage_wizardPageTitle);
        this.setDescription(Messages.BPELImplementationWizardPage_wizardPageDescription);
        this.setPageComplete(false);
        ResourceSet resourceSet = (ResourceSet)SwitchyardSCAEditor.getActiveEditor().getEditorInput().getAdapter(ResourceSet.class);
        if (resourceSet != null && resourceSet.getResources().size() > 0) {
            for (Resource emfResource : resourceSet.getResources()) {
                IProject project;
                IResource resource;
                String path = resourceSet.getURIConverter().normalize(emfResource.getURI()).toPlatformString(true);
                if (path == null || (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) == null || (project = resource.getProject()) == null) continue;
                this._project = JavaCore.create((IProject)project);
                break;
            }
        }
    }

    public BPELImplementation getImplementation() {
        return this._implementation;
    }

    public ComponentService getService() {
        return this._service;
    }

    public void init(Component component) {
        this._component = component;
        if (component == null || component.getService() == null) {
            return;
        }
        Iterator iterator = component.getService().iterator();
        if (iterator.hasNext()) {
            ComponentService service;
            this._serviceInterface = service = (ComponentService)iterator.next();
            return;
        }
    }

    public void createControl(org.eclipse.swt.widgets.Composite parent) {
        org.eclipse.swt.widgets.Composite contents = new org.eclipse.swt.widgets.Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        this._newBPELLink = new Link(contents, 0);
        this._newBPELLink.setText("<a>" + Messages.BPELImplementationWizardPage_newBPELFileLinkLabel + "</a>");
        this._newBPELLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPELImplementationWizardPage.this.openNewWizard();
            }
        });
        this._bpelFileText = new Text(contents, 2056);
        this._bpelFileText.setLayoutData((Object)new GridData(768));
        this._bpelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BPELImplementationWizardPage.this.validate();
            }
        });
        this._browseBPELButton = new Button(contents, 8);
        this._browseBPELButton.setText(Messages.BPELImplementationWizardPage_browseBPELFileButton);
        this._browseBPELButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPELImplementationWizardPage.this.handleBrowse();
            }
        });
        this.setControl((Control)contents);
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this._implementation == null) {
            this.setErrorMessage(Messages.BPELImplementationWizardPage_errorMessageSelectBPELFile);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void handleBrowse() {
        Object[] result;
        Object container = this._project == null ? ResourcesPlugin.getWorkspace().getRoot() : this._project.getProject();
        ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this.getShell(), (IContainer)container, "bpel");
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IFile) {
            IFile bpelFile = (IFile)result[0];
            String bpelFilePath = JavaUtil.getJavaPathForResource((IResource)bpelFile).toString();
            this._implementation = ScaFactory.eINSTANCE.createBPELImplementation();
            QName processName = Activator.getDefault().getProcessForFile(bpelFile);
            this._implementation.setProcess(processName);
            this._service = null;
            this._bpelFileText.setText(bpelFilePath);
        }
    }

    private void openNewWizard() {
        BPELComponentWizard wizard = new BPELComponentWizard(false);
        SwitchyardSCAEditor editor = SwitchyardSCAEditor.getActiveEditor();
        IResource resource = JavaUtil.getFirstResourceRoot((IJavaProject)this._project);
        StructuredSelection selection = resource == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)resource);
        IWorkbench workbench = editor == null ? PlatformUI.getWorkbench() : editor.getEditorSite().getWorkbenchWindow().getWorkbench();
        wizard.init(workbench, (IStructuredSelection)selection);
        wizard.init(this._component == null ? null : (Composite)this._component.eContainer());
        wizard.forceServiceInterfaceType(this._serviceInterface);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this._implementation = (BPELImplementation)wizard.getCreatedObject().getImplementation();
            this._service = wizard.getService();
            this._bpelFileText.setText(String.valueOf(this._implementation.getProcess().getLocalPart()) + " " + this._implementation.getProcess().getNamespaceURI());
        }
    }
}

